/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex.tree;

import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexMethodNode
extends DexElementNode {
    private long size;

    public DexMethodNode(@NotNull String displayName, @Nullable ImmutableMethodReference reference) {
        super(displayName, false, (ImmutableReference)reference);
    }

    @Nullable
    public ImmutableMethodReference getReference() {
        return (ImmutableMethodReference)super.getReference();
    }

    @Override
    public boolean isSeed(@Nullable ProguardSeedsMap seedsMap, @Nullable ProguardMap map, boolean checkChildren) {
        ImmutableMethodReference reference;
        if (seedsMap != null && (reference = this.getReference()) != null) {
            String className = PackageTreeCreator.decodeClassName(reference.getDefiningClass(), map);
            String methodName = PackageTreeCreator.decodeMethodName((MethodReference)reference, map);
            String params = PackageTreeCreator.decodeMethodParams((MethodReference)reference, map);
            if ("<init>".equals(methodName)) {
                methodName = SigUtils.getSimpleName(className);
            }
            return seedsMap.hasMethod(className, methodName + params);
        }
        return false;
    }

    @Override
    public int getMethodDefinitionsCount() {
        return this.isDefined() ? 1 : 0;
    }

    @Override
    public int getMethodReferencesCount() {
        return this.isRemoved() ? 0 : 1;
    }

    @Override
    public void update() {
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

