/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex.tree;

import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexReferencesNode;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableTypeReference;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexClassNode
extends DexElementNode {
    private long size = 0L;

    public DexClassNode(@NotNull String displayName, @Nullable ImmutableTypeReference reference) {
        super(displayName, true, (ImmutableReference)reference);
    }

    @Override
    public boolean isSeed(@Nullable ProguardSeedsMap seedsMap, @Nullable ProguardMap map, boolean checkChildren) {
        ImmutableTypeReference reference;
        if (seedsMap != null && (reference = this.getReference()) != null && seedsMap.hasClass(PackageTreeCreator.decodeClassName(reference.getType(), map))) {
            return true;
        }
        return super.isSeed(seedsMap, map, checkChildren);
    }

    @Override
    public long getSize() {
        long size = this.size;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            DexElementNode node = this.getChildAt(i);
            if (node.isDefined()) continue;
            size += node.getSize();
        }
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Nullable
    public ImmutableTypeReference getReference() {
        return (ImmutableTypeReference)super.getReference();
    }

    @Nullable
    public DexMethodNode getMethod(@NotNull String qualifiedMethodName) {
        return this.getChildByType(qualifiedMethodName, DexMethodNode.class);
    }

    @Nullable
    public DexFieldNode getField(@NotNull String qualifiedFieldName) {
        return this.getChildByType(qualifiedFieldName, DexFieldNode.class);
    }

    @Override
    public void update() {
        super.update();
        int methodDefinitions = 0;
        int methodReferences = 0;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            DexElementNode node = this.getChildAt(i);
            methodDefinitions += node.getMethodDefinitionsCount();
            methodReferences += node.getMethodReferencesCount();
        }
        this.setMethodDefinitionsCount(methodDefinitions);
        this.setMethodReferencesCount(methodReferences);
    }

    @Override
    public void sort(Comparator<DexElementNode> comparator) {
        if (this.getChildCount() == 0) {
            return;
        }
        DexElementNode first = this.getChildAt(0);
        if (first instanceof DexReferencesNode) {
            this.remove(0);
        }
        super.sort(comparator);
        if (first instanceof DexReferencesNode) {
            this.insert(first, 0);
        }
    }
}

