/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.psi.UastFakeLightMethodBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\"\u0010\u0018\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0011H\u0016J#\u0010!\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010$\u001a\u00020)2\u0006\u0010&\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010*J*\u0010+\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010)2\u0006\u0010&\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J+\u0010.\u001a\u0004\u0018\u00010(2\u0006\u0010/\u001a\u00020)2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0'\"\u00020\nH\u0016\u00a2\u0006\u0002\u00101J+\u00102\u001a\u0004\u0018\u00010#2\u0006\u0010/\u001a\u00020)2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0'\"\u00020\nH\u0016\u00a2\u0006\u0002\u00103J-\u00104\u001a\u0004\u0018\u00010(2\b\u0010/\u001a\u0004\u0018\u00010)2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0'\"\u00020\nH\u0016\u00a2\u0006\u0002\u00101J-\u00105\u001a\u0004\u0018\u00010#2\b\u0010/\u001a\u0004\u0018\u00010)2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0'\"\u00020\nH\u0016\u00a2\u0006\u0002\u00103J\u0018\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010\u00052\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010:\u001a\u0004\u0018\u00010\u00052\u0006\u0010=\u001a\u00020>J\u0012\u0010?\u001a\u0004\u0018\u00010\n2\u0006\u0010;\u001a\u00020<H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\n2\u0006\u0010;\u001a\u00020-H\u0016J\u0014\u0010?\u001a\u0004\u0018\u00010\n2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010\u000b2\u0006\u0010C\u001a\u00020<H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\u000b2\u0006\u0010C\u001a\u00020-H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010\n2\u0006\u0010E\u001a\u00020\u001cH\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010\n2\u0006\u0010E\u001a\u00020\u001cH\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0014\u0010G\u001a\u0004\u0018\u00010 2\b\u0010H\u001a\u0004\u0018\u00010 H\u0016J$\u0010I\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020L0J2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u000208H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006P"}, d2={"Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "myLintProject", "Lcom/android/tools/lint/detector/api/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/lint/detector/api/Project;)V", "packageInfoCache", "", "", "Lcom/intellij/psi/PsiPackage;", "dependencies", "Lcom/android/tools/lint/model/LintModelDependencies;", "getDependencies", "()Lcom/android/tools/lint/model/LintModelDependencies;", "extendsClass", "", "cls", "Lcom/intellij/psi/PsiClass;", "className", "strict", "implementsInterface", "interfaceName", "inheritsFrom", "findClass", "qualifiedName", "getClassType", "Lcom/intellij/psi/PsiClassType;", "psiClass", "getTypeClass", "psiType", "Lcom/intellij/psi/PsiType;", "getAllAnnotations", "", "Lorg/jetbrains/uast/UAnnotation;", "owner", "Lorg/jetbrains/uast/UAnnotated;", "inHierarchy", "", "Lcom/intellij/psi/PsiAnnotation;", "Lcom/intellij/psi/PsiModifierListOwner;", "(Lcom/intellij/psi/PsiModifierListOwner;Z)[Lcom/intellij/psi/PsiAnnotation;", "getAnnotations", "parent", "Lorg/jetbrains/uast/UElement;", "findAnnotationInHierarchy", "listOwner", "annotationNames", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "getAnnotationInHierarchy", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lorg/jetbrains/uast/UAnnotation;", "findAnnotation", "getAnnotation", "areSignaturesEqual", "method1", "Lcom/intellij/psi/PsiMethod;", "method2", "getProject", "element", "Lcom/intellij/psi/PsiElement;", "file", "Ljava/io/File;", "findJarPath", "containingFile", "Lcom/intellij/psi/PsiFile;", "getPackage", "node", "getQualifiedName", "psiClassType", "getInternalName", "erasure", "type", "computeArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "lint-api"})
@SourceDebugExtension(value={"SMAP\nDefaultJavaEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultJavaEvaluator.kt\ncom/android/tools/lint/helpers/DefaultJavaEvaluator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,483:1\n11546#2,9:484\n13472#2:493\n13473#2:495\n11555#2:496\n1#3:494\n1463#4,14:497\n*S KotlinDebug\n*F\n+ 1 DefaultJavaEvaluator.kt\ncom/android/tools/lint/helpers/DefaultJavaEvaluator\n*L\n222#1:484,9\n222#1:493\n222#1:495\n222#1:496\n222#1:494\n298#1:497,14\n*E\n"})
public class DefaultJavaEvaluator
extends JavaEvaluator {
    @Nullable
    private final com.intellij.openapi.project.Project myProject;
    @Nullable
    private final Project myLintProject;
    @NotNull
    private final Map<String, PsiPackage> packageInfoCache;

    public DefaultJavaEvaluator(@Nullable com.intellij.openapi.project.Project myProject, @Nullable Project myLintProject) {
        this.myProject = myProject;
        this.myLintProject = myLintProject;
        this.packageInfoCache = new LinkedHashMap();
    }

    @Override
    @Nullable
    public LintModelDependencies getDependencies() {
        LintModelVariant variant;
        if (this.myLintProject != null && (variant = this.myLintProject.getBuildVariant()) != null) {
            return variant.getArtifact().getDependencies();
        }
        return null;
    }

    @Override
    public boolean extendsClass(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public boolean implementsInterface(@NotNull PsiClass cls, @NotNull String interfaceName, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)interfaceName);
    }

    @Override
    public boolean inheritsFrom(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (cls == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        if (this.myProject == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)this.myProject).findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)this.myProject));
        }
        catch (Exception ex) {
            block4: {
                LintClient lintClient;
                Project project;
                if (ex instanceof ControlFlowException) {
                    throw ex;
                }
                if (!LintClient.Companion.isUnitTest() || (project = this.myLintProject) == null || (lintClient = project.getClient()) == null) break block4;
                lintClient.log(Severity.ERROR, ex, "Exception thrown for qualified class name: " + qualifiedName, new Object[0]);
            }
            return null;
        }
    }

    @Override
    @Nullable
    public PsiClassType getClassType(@Nullable PsiClass psiClass) {
        return this.myProject != null && psiClass != null ? JavaPsiFacade.getElementFactory((com.intellij.openapi.project.Project)this.myProject).createType(psiClass) : null;
    }

    @Override
    @Nullable
    public PsiClass getTypeClass(@Nullable PsiType psiType) {
        PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    @Override
    @NotNull
    public List<UAnnotation> getAllAnnotations(@NotNull UAnnotated owner, boolean inHierarchy) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            List annotations = owner instanceof UField ? ((UField)owner).getSourceAnnotations() : owner.getUAnnotations();
            PsiElement psiElement = owner.getJavaPsi();
            List<UAnnotation> mergeAnnotations = this.getAnnotations(psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null, inHierarchy, (UElement)owner);
            if (!((Collection)annotations).isEmpty()) {
                List list;
                if (mergeAnnotations.isEmpty()) {
                    return annotations;
                }
                boolean modified = false;
                LinkedHashMap map = new LinkedHashMap();
                for (UAnnotation annotation : annotations) {
                    String string = annotation.getQualifiedName();
                    if (string == null) {
                        UIdentifier uIdentifier = annotation.getUastAnchor();
                        string = uIdentifier != null ? uIdentifier.getName() : null;
                        if (string == null) continue;
                    }
                    String name = string;
                    ((Map)map).put(name, annotation);
                }
                for (UAnnotation annotation : mergeAnnotations) {
                    String signature;
                    if (annotation.getQualifiedName() == null || map.get(signature) != null) continue;
                    ((Map)map).put(signature, annotation);
                    modified = true;
                }
                if (modified) {
                    Collection collection = map.values();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                    list = CollectionsKt.toList((Iterable)collection);
                } else {
                    list = annotations;
                }
                return list;
            }
            return mergeAnnotations;
        }
        return owner.getUAnnotations();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (owner instanceof UDeclaration) {
            PsiElement psiElement = ((UDeclaration)owner).getJavaPsi();
            PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
            if (psiModifierListOwner == null) {
                return new PsiAnnotation[0];
            }
            PsiModifierListOwner psi = psiModifierListOwner;
            return this.getAllAnnotations(psi, inHierarchy);
        }
        PsiAnnotation[] psiAnnotationArray = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAllAnnotations(...)");
        return psiAnnotationArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<UAnnotation> getAnnotations(@Nullable PsiModifierListOwner owner, boolean inHierarchy, @Nullable UElement parent) {
        void $this$mapNotNullTo$iv$iv;
        PsiAnnotation[] psiAnnotations;
        PsiAnnotation[] psiAnnotationArray;
        if (owner == null) {
            return CollectionsKt.emptyList();
        }
        if (owner instanceof UDeclaration) {
            PsiElement psiElement = ((UDeclaration)owner).getJavaPsi();
            PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
            if (psiModifierListOwner == null) {
                return CollectionsKt.emptyList();
            }
            PsiModifierListOwner psi = psiModifierListOwner;
            return JavaEvaluator.getAnnotations$default(this, psi, inHierarchy, null, 4, null);
        }
        boolean withInferred = false;
        if (owner instanceof UastFakeLightMethodBase) {
            psiAnnotationArray = ((UastFakeLightMethodBase)owner).getAnnotations();
        } else {
            PsiAnnotation[] psiAnnotationArray2 = AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)withInferred);
            psiAnnotationArray = psiAnnotationArray2;
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray2, (String)"getAllAnnotations(...)");
        }
        PsiAnnotation[] $this$mapNotNull$iv = psiAnnotations = psiAnnotationArray;
        boolean $i$f$mapNotNull = false;
        PsiAnnotation[] psiAnnotationArray3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            UAnnotation it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void psi = element$iv$iv;
            boolean bl2 = false;
            UElement uElement = UastFacade.INSTANCE.convertElement((PsiElement)psi, inHierarchy ? null : parent, UAnnotation.class);
            if ((uElement instanceof UAnnotation ? (UAnnotation)uElement : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkNotNullParameter((Object)listOwner, (String)"listOwner");
        Intrinsics.checkNotNullParameter((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            PsiElement psiElement = ((UDeclaration)listOwner).getJavaPsi();
            PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
            if (psiModifierListOwner == null) {
                return null;
            }
            PsiModifierListOwner psi = psiModifierListOwner;
            return this.findAnnotationInHierarchy(psi, Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])Arrays.copyOf(annotationNames, annotationNames.length)));
    }

    @Override
    @Nullable
    public UAnnotation getAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, String ... annotationNames) {
        UAnnotation uAnnotation;
        Intrinsics.checkNotNullParameter((Object)listOwner, (String)"listOwner");
        Intrinsics.checkNotNullParameter((Object)annotationNames, (String)"annotationNames");
        PsiAnnotation psiAnnotation = this.findAnnotationInHierarchy(listOwner, Arrays.copyOf(annotationNames, annotationNames.length));
        if (psiAnnotation != null) {
            PsiAnnotation psi = psiAnnotation;
            boolean bl = false;
            UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)((UastLanguagePlugin)UastFacade.INSTANCE), (PsiElement)((PsiElement)psi), (UElement)(listOwner instanceof UElement ? (UElement)listOwner : null), null, (int)4, null);
            uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
        } else {
            uAnnotation = null;
        }
        return uAnnotation;
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        Intrinsics.checkNotNullParameter((Object)annotationNames, (String)"annotationNames");
        if (listOwner instanceof UDeclaration) {
            PsiElement psiElement = ((UDeclaration)listOwner).getJavaPsi();
            PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
            if (psiModifierListOwner == null) {
                return null;
            }
            PsiModifierListOwner psi = psiModifierListOwner;
            return this.findAnnotation(psi, Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])Arrays.copyOf(annotationNames, annotationNames.length));
    }

    @Override
    @Nullable
    public UAnnotation getAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        UAnnotation uAnnotation;
        Intrinsics.checkNotNullParameter((Object)annotationNames, (String)"annotationNames");
        PsiAnnotation psiAnnotation = this.findAnnotation(listOwner, Arrays.copyOf(annotationNames, annotationNames.length));
        if (psiAnnotation != null) {
            PsiAnnotation psi = psiAnnotation;
            boolean bl = false;
            UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)((UastLanguagePlugin)UastFacade.INSTANCE), (PsiElement)((PsiElement)psi), (UElement)(listOwner instanceof UElement ? (UElement)listOwner : null), null, (int)4, null);
            uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
        } else {
            uAnnotation = null;
        }
        return uAnnotation;
    }

    @Override
    public boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        Intrinsics.checkNotNullParameter((Object)method1, (String)"method1");
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method2");
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)method1, (PsiMethod)method2);
    }

    @Override
    @Nullable
    public Project getProject(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile virtualFile = psiFile;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        File file2 = file;
        return this.getProject(file2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Project getProject(@NotNull File file) {
        Object v1;
        void $this$maxByOrNull$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = this.myLintProject;
        if (object == null || (object = ((Project)object).getClient()) == null || (object = ((LintClient)object).getKnownProjects()) == null) {
            return null;
        }
        Object projects = object;
        if (projects.isEmpty()) {
            return null;
        }
        String path2 = file.getPath();
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)projects)), (Function1)((Function1)new Function1<Project, Boolean>(path2){
            final /* synthetic */ String $path;
            {
                this.$path = $path;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(Project it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)this.$path, (Object)it.getDir().getPath())) {
                    String string = this.$path;
                    Intrinsics.checkNotNull((Object)string);
                    if (!StringsKt.startsWith$default((String)string, (String)(it.getDir().getPath() + File.separator), (boolean)false, (int)2, null)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }));
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                Project it = (Project)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getDir().getPath().length();
                do {
                    Object e$iv = iterator$iv.next();
                    Project it2 = (Project)e$iv;
                    $i$a$-maxByOrNull-DefaultJavaEvaluator$getProject$2 = false;
                    int v$iv = it2.getDir().getPath().length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        return v1;
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile containingFile = element.getContainingFile();
        return this.findJarPath(containingFile);
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull UElement element) {
        UFile uFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UFile uFile2 = uFile = UastUtils.getContainingUFile((UElement)element);
        return uFile2 != null ? this.findJarPath(uFile2.getSourcePsi()) : null;
    }

    private final String findJarPath(PsiFile containingFile) {
        VirtualFile file;
        if (containingFile != null && (file = containingFile.getVirtualFile()) != null && Intrinsics.areEqual((Object)file.getFileSystem().getProtocol(), (Object)"jar")) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path2 = string;
            int separatorIndex = StringsKt.indexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (separatorIndex >= 0) {
                String string2 = path2.substring(0, separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return string2;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull PsiElement node) {
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiFile psiFile = node instanceof PsiFile ? (PsiFile)node : null;
        if (psiFile == null) {
            psiFile = node.getContainingFile();
        }
        if ((containingFile = psiFile) != null) {
            if (containingFile instanceof PsiJavaFile) {
                return this.packageInfoCache.computeIfAbsent(((PsiJavaFile)containingFile).getPackageName(), new Function(containingFile, this, node){
                    final /* synthetic */ PsiFile $containingFile;
                    final /* synthetic */ DefaultJavaEvaluator this$0;
                    final /* synthetic */ PsiElement $node;
                    {
                        this.$containingFile = $containingFile;
                        this.this$0 = $receiver;
                        this.$node = $node;
                    }

                    public final PsiPackage apply(String name) {
                        PsiPackage psiPackage;
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        PsiPackage pkg = JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)((PsiJavaFile)this.$containingFile).getProject()).findPackage(name);
                        if (pkg != null) {
                            psiPackage = pkg;
                        } else {
                            PsiClass cls;
                            PsiClass psiClass = cls = this.this$0.findClass(name + ".package-info");
                            PsiModifierList modifierList = psiClass != null ? psiClass.getModifierList() : null;
                            PsiManager psiManager = this.$node.getManager();
                            psiPackage = (PsiPackage)new PsiPackageImpl(name, modifierList, psiManager){
                                final /* synthetic */ PsiModifierList $modifierList;
                                {
                                    this.$modifierList = $modifierList;
                                    super($super_call_param$1, $name);
                                }

                                public PsiModifierList getAnnotationList() {
                                    return this.$modifierList != null ? (PsiModifierList)new PsiCompositeModifierList(this.getManager(), CollectionsKt.listOf((Object)this.$modifierList)) : null;
                                }
                            };
                        }
                        return psiPackage;
                    }
                });
            }
            if (containingFile instanceof KtFile && !((KtFile)containingFile).isCompiled()) {
                FqName packageFqName = ((KtFile)containingFile).getPackageFqName();
                return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)node.getProject()).findPackage(packageFqName.asString());
            }
            PsiDirectory dir = containingFile.getParent();
            if (dir != null) {
                return JavaDirectoryService.getInstance().getPackage(dir);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull UElement node) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UFile uFile = UastUtils.getContainingUFile((UElement)node);
        if (uFile == null) {
            return null;
        }
        UFile uFile2 = uFile;
        if (Lint.isKotlin(uFile2.getLang())) {
            psiElement = (PsiElement)uFile2.getSourcePsi();
        } else {
            psiElement = uFile2.getJavaPsi();
            if (psiElement == null) {
                psiElement = (PsiElement)uFile2.getSourcePsi();
            }
        }
        PsiElement psi = psiElement;
        return this.getPackage(psi);
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkNotNullParameter((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getQualifiedName((PsiClassType)erased) : super.getQualifiedName(psiClassType);
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return psiClass.getQualifiedName();
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClassType psiClassType) {
        Intrinsics.checkNotNullParameter((Object)psiClassType, (String)"psiClassType");
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getInternalName((PsiClassType)erased) : super.getInternalName(psiClassType);
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return Lint.getInternalName(psiClass);
    }

    @Override
    @Nullable
    public PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure((PsiType)type);
    }

    @Override
    @NotNull
    public Map<UExpression, PsiParameter> computeArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        Object parameter;
        UExpression argument;
        int j;
        Object[] parameters;
        List arguments;
        block10: {
            block9: {
                String first;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PsiParameterList psiParameterList = method.getParameterList();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"getParameterList(...)");
                PsiParameterList parameterList = psiParameterList;
                if (parameterList.getParametersCount() == 0) {
                    return MapsKt.emptyMap();
                }
                Map<UExpression, PsiParameter> kotlinMap = Lint.computeKotlinArgumentMapping(call, method);
                if (kotlinMap != null) {
                    return kotlinMap;
                }
                arguments = call.getValueArguments();
                Object[] objectArray = parameterList.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParameters(...)");
                parameters = objectArray;
                j = 0;
                PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters);
                String string = first = psiParameter != null ? psiParameter.getName() : null;
                if (string != null ? StringsKt.startsWith$default((String)string, (String)"$this", (boolean)false, (int)2, null) : false) break block9;
                String string2 = first;
                boolean bl = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"$self", (boolean)false, (int)2, null) : false;
                if (!bl) break block10;
            }
            if (Lint.isKotlin(call.getLang())) {
                ++j;
            }
        }
        int i = 0;
        int n = Math.min(parameters.length, arguments.size());
        HashMap map = new HashMap(2 * n);
        while (j < n) {
            argument = (UExpression)arguments.get(i);
            parameter = parameters[j];
            ((Map)map).put(argument, parameter);
            ++i;
            ++j;
        }
        if (i < arguments.size() && j > 0) {
            --j;
            while (i < arguments.size()) {
                argument = (UExpression)arguments.get(i);
                parameter = parameters[j];
                ((Map)map).put(argument, parameter);
                ++i;
            }
        }
        return map;
    }
}

