/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0004*\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\b"}, d2={"unescape", "", "s", "skipInitialNewline", "", "isNumberOrDateLiteralChar", "", "tomlStringSourceToString", "lint-api"})
public final class DefaultLintTomlParserKt {
    private static final String unescape(String s, boolean skipInitialNewline) {
        StringBuilder sb = new StringBuilder();
        int length = s.length();
        int i = 0;
        if (skipInitialNewline && length > 0 && s.charAt(i) == '\n') {
            ++i;
        }
        block16: while (i < length) {
            StringBuilder stringBuilder;
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < s.length()) {
                char next = s.charAt(i++);
                switch (next) {
                    case '\n': {
                        while (i < length && CharsKt.isWhitespace((char)s.charAt(i))) {
                            ++i;
                        }
                        continue block16;
                    }
                    case 'n': {
                        stringBuilder = sb.append('\n');
                        break;
                    }
                    case 't': {
                        stringBuilder = sb.append('\t');
                        break;
                    }
                    case 'b': {
                        stringBuilder = sb.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder = sb.append('\f');
                        break;
                    }
                    case 'r': {
                        stringBuilder = sb.append('\r');
                        break;
                    }
                    case '\"': {
                        stringBuilder = sb.append('\"');
                        break;
                    }
                    case '\\': {
                        stringBuilder = sb.append('\\');
                        break;
                    }
                    case 'u': {
                        if (i <= s.length() - 4) {
                            Comparable<StringBuilder> uc22;
                            try {
                                String string = s.substring(i, i + 4);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                char uc22 = (char)Integer.parseInt(string, 16);
                                sb.append(uc22);
                                uc22 = i += 4;
                            }
                            catch (NumberFormatException e) {
                                uc22 = sb.append(next);
                            }
                            stringBuilder = uc22;
                            break;
                        }
                        stringBuilder = sb.append(next);
                        break;
                    }
                    case 'U': {
                        if (i <= s.length() - 8) {
                            Comparable<StringBuilder> comparable;
                            try {
                                String string = s.substring(i, i + 8);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                char uc = (char)Integer.parseInt(string, 16);
                                sb.append(uc);
                                comparable = i += 8;
                            }
                            catch (NumberFormatException e) {
                                comparable = sb.append(next);
                            }
                            stringBuilder = comparable;
                            break;
                        }
                        stringBuilder = sb.append(next);
                        break;
                    }
                    default: {
                        stringBuilder = sb.append(next);
                        break;
                    }
                }
                continue;
            }
            stringBuilder = sb.append(c);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String unescape$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return DefaultLintTomlParserKt.unescape(string, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNumberOrDateLiteralChar(char $this$isNumberOrDateLiteralChar) {
        boolean bl;
        boolean bl2;
        char c = $this$isNumberOrDateLiteralChar;
        if (Character.isDigit(c)) return true;
        if (c == '.') return true;
        if (c == '+') return true;
        if (c == '-') return true;
        if (c == '_') return true;
        if (c == 'o') return true;
        if (c == 'x') return true;
        if ('a' <= c) {
            if (c < 'g') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= c) {
            if (c < 'G') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (c == 'e') return true;
        if (c == 'E') return true;
        if (c == ':') return true;
        if (c == 'T') return true;
        if (c != 'Z') return false;
        return true;
    }

    private static final String tomlStringSourceToString(String $this$tomlStringSourceToString) {
        String valueSource = $this$tomlStringSourceToString;
        if (((CharSequence)valueSource).length() == 0) {
            return valueSource;
        }
        if (StringsKt.startsWith$default((String)valueSource, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            String body = StringsKt.removeSurrounding((String)valueSource, (CharSequence)"\"\"\"");
            return DefaultLintTomlParserKt.unescape(body, true);
        }
        if (StringsKt.startsWith$default((String)valueSource, (String)"\"", (boolean)false, (int)2, null)) {
            return DefaultLintTomlParserKt.unescape$default(StringsKt.removeSurrounding((String)valueSource, (CharSequence)"\""), false, 2, null);
        }
        if (StringsKt.startsWith$default((String)valueSource, (String)"'''", (boolean)false, (int)2, null)) {
            String body = StringsKt.removeSurrounding((String)valueSource, (CharSequence)"'''");
            if (StringsKt.startsWith$default((String)body, (String)"\n", (boolean)false, (int)2, null)) {
                String string = body.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                body = string;
            }
            return body;
        }
        if (StringsKt.startsWith$default((String)valueSource, (String)"'", (boolean)false, (int)2, null)) {
            return StringsKt.removeSurrounding((String)valueSource, (CharSequence)"'");
        }
        return valueSource;
    }

    public static final /* synthetic */ String access$tomlStringSourceToString(String $receiver) {
        return DefaultLintTomlParserKt.tomlStringSourceToString($receiver);
    }

    public static final /* synthetic */ boolean access$isNumberOrDateLiteralChar(char $receiver) {
        return DefaultLintTomlParserKt.isNumberOrDateLiteralChar($receiver);
    }
}

