/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.ProgressManagerAdapter;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.utils.ILogger;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.InputStream;
import java.util.function.Predicate;

public class VendorDevices {
    private static final String[] DEVICE_FILES = new String[]{"nexus", "wear", "tv", "automotive", "desktop", "xr"};
    private final ILogger mLog;
    private Table<String, String, Device> mVendorDevices;
    private final Object mLock = new Object();

    public VendorDevices(ILogger log) {
        this.mLog = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Predicate<Device> isSupportedDevice) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorDevices != null) {
                return false;
            }
            HashBasedTable vendorDevices = HashBasedTable.create();
            for (String deviceFile : DEVICE_FILES) {
                try (InputStream stream = VendorDevices.class.getResourceAsStream(deviceFile + ".xml");){
                    DeviceParser.parse(stream).cellSet().forEach(arg_0 -> this.lambda$init$0(isSupportedDevice, (Table)vendorDevices, arg_0));
                }
                catch (Exception e) {
                    ProgressManagerAdapter.throwIfCancellation((Throwable)e);
                    this.mLog.error((Throwable)e, "Could not load " + deviceFile + " devices", new Object[0]);
                    this.mVendorDevices = HashBasedTable.create();
                    return false;
                }
            }
            this.mVendorDevices = vendorDevices;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getDevice(String id, String manufacturer) {
        Object object = this.mLock;
        synchronized (object) {
            return (Device)this.mVendorDevices.get((Object)id, (Object)manufacturer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table<String, String, Device> getDevices() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mVendorDevices;
        }
    }

    private /* synthetic */ void lambda$init$0(Predicate isSupportedDevice, Table vendorDevices, Table.Cell cell) {
        if (isSupportedDevice.test((Device)cell.getValue())) {
            vendorDevices.put((Object)((String)cell.getRowKey()), (Object)((String)cell.getColumnKey()), (Object)((Device)cell.getValue()));
        } else {
            this.mLog.warning("Unsupported device %s", new Object[]{cell.getRowKey()});
        }
    }
}

