/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.sdklib.AndroidApiLevel;
import java.util.Objects;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\u0018\u0000 +2\u00020\u0001:\u0001+B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0001H\u0016J\u001a\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u00012\u0006\u0010%\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020\u0016H\u0016J\b\u0010(\u001a\u00020\u0016H\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0016H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/android/ide/common/resources/configuration/VersionQualifier;", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "androidApiLevel", "Lcom/android/sdklib/AndroidApiLevel;", "includeMinorVersion", "", "<init>", "(Lcom/android/sdklib/AndroidApiLevel;Z)V", "()V", "(Lcom/android/sdklib/AndroidApiLevel;)V", "majorVersion", "", "(I)V", "getAndroidApiLevel", "()Lcom/android/sdklib/AndroidApiLevel;", "getIncludeMinorVersion", "()Z", "version", "getVersion$annotations", "getVersion", "()I", "getName", "", "getShortName", "since", "isValid", "hasFakeValue", "checkAndSet", "value", "config", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "equals", "qualifier", "", "isMatchFor", "isBetterMatchThan", "compareTo", "reference", "hashCode", "getFolderSegment", "getShortDisplayValue", "getLongDisplayValue", "getDisplayValueVersion", "Companion", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nVersionQualifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionQualifier.kt\ncom/android/ide/common/resources/configuration/VersionQualifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class VersionQualifier
extends ResourceQualifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final AndroidApiLevel androidApiLevel;
    private final boolean includeMinorVersion;
    @NotNull
    private static final AndroidApiLevel DEFAULT_API_LEVEL = new AndroidApiLevel(-1, 0, 2, null);
    @JvmField
    @NotNull
    public static final VersionQualifier DEFAULT = new VersionQualifier();
    @NotNull
    private static final Regex versionPattern = new Regex("^v(\\d+)(\\.(\\d+))?$");
    @NotNull
    public static final String NAME = "Platform Version";

    public VersionQualifier(@Nullable AndroidApiLevel androidApiLevel, boolean includeMinorVersion) {
        this.androidApiLevel = androidApiLevel;
        this.includeMinorVersion = includeMinorVersion;
        AndroidApiLevel androidApiLevel2 = this.androidApiLevel;
        int minorVersion = androidApiLevel2 != null ? androidApiLevel2.getMinorVersion() : 0;
        if (!(minorVersion == 0 || this.includeMinorVersion)) {
            boolean bl = false;
            String string = "Minor version must be included unless it is 0.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final AndroidApiLevel getAndroidApiLevel() {
        return this.androidApiLevel;
    }

    public final boolean getIncludeMinorVersion() {
        return this.includeMinorVersion;
    }

    public VersionQualifier() {
        this(null, false);
    }

    public VersionQualifier(@NotNull AndroidApiLevel androidApiLevel) {
        Intrinsics.checkNotNullParameter((Object)androidApiLevel, (String)"androidApiLevel");
        this(androidApiLevel, androidApiLevel.getMajorVersion() >= 36);
    }

    public VersionQualifier(int majorVersion) {
        this(majorVersion != DEFAULT_API_LEVEL.getMajorVersion() ? new AndroidApiLevel(majorVersion, 0, 2, null) : null, false);
    }

    public final int getVersion() {
        AndroidApiLevel androidApiLevel = this.androidApiLevel;
        return androidApiLevel != null ? androidApiLevel.getMajorVersion() : DEFAULT_API_LEVEL.getMajorVersion();
    }

    @Deprecated(message="Use androidApiLevel instead.", replaceWith=@ReplaceWith(expression="androidApiLevel?.majorVersion", imports={}))
    public static /* synthetic */ void getVersion$annotations() {
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public String getShortName() {
        return "Version";
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.androidApiLevel != null;
    }

    @Override
    public boolean hasFakeValue() {
        return false;
    }

    @Override
    public boolean checkAndSet(@NotNull String value, @NotNull FolderConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        VersionQualifier versionQualifier = Companion.getQualifier(value);
        if (versionQualifier == null) {
            return false;
        }
        VersionQualifier qualifier = versionQualifier;
        config.setVersionQualifier(qualifier);
        return true;
    }

    @Override
    public boolean equals(@Nullable Object qualifier) {
        return qualifier instanceof VersionQualifier && Intrinsics.areEqual((Object)this.androidApiLevel, (Object)((VersionQualifier)qualifier).androidApiLevel) && this.includeMinorVersion == ((VersionQualifier)qualifier).includeMinorVersion;
    }

    @Override
    public boolean isMatchFor(@NotNull ResourceQualifier qualifier) {
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        if (!(qualifier instanceof VersionQualifier)) {
            return false;
        }
        AndroidApiLevel androidApiLevel = this.androidApiLevel;
        if (androidApiLevel == null) {
            androidApiLevel = DEFAULT_API_LEVEL;
        }
        AndroidApiLevel thisApiLevel = androidApiLevel;
        AndroidApiLevel qualifierApiLevel = ((VersionQualifier)qualifier).androidApiLevel;
        return qualifierApiLevel == null || thisApiLevel.compareTo(qualifierApiLevel) <= 0;
    }

    @Override
    public boolean isBetterMatchThan(@Nullable ResourceQualifier compareTo2, @NotNull ResourceQualifier reference) {
        AndroidApiLevel androidApiLevel;
        AndroidApiLevel compareApiLevel;
        AndroidApiLevel androidApiLevel2;
        AndroidApiLevel thisApiLevel;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (compareTo2 == null) {
            return true;
        }
        AndroidApiLevel androidApiLevel3 = this.androidApiLevel;
        if (androidApiLevel3 == null) {
            androidApiLevel3 = thisApiLevel = DEFAULT_API_LEVEL;
        }
        if ((androidApiLevel2 = ((VersionQualifier)compareTo2).androidApiLevel) == null) {
            androidApiLevel2 = compareApiLevel = DEFAULT_API_LEVEL;
        }
        if ((androidApiLevel = ((VersionQualifier)reference).androidApiLevel) == null) {
            androidApiLevel = DEFAULT_API_LEVEL;
        }
        AndroidApiLevel referenceApiLevel = androidApiLevel;
        return Intrinsics.areEqual((Object)compareApiLevel, (Object)referenceApiLevel) && ((VersionQualifier)compareTo2).includeMinorVersion == ((VersionQualifier)reference).includeMinorVersion ? false : (Intrinsics.areEqual((Object)compareApiLevel, (Object)referenceApiLevel) ? Intrinsics.areEqual((Object)this.androidApiLevel, (Object)referenceApiLevel) && this.includeMinorVersion == ((VersionQualifier)reference).includeMinorVersion : (Intrinsics.areEqual((Object)thisApiLevel, (Object)referenceApiLevel) ? true : thisApiLevel.compareTo(compareApiLevel) > 0));
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.androidApiLevel, this.includeMinorVersion};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public String getFolderSegment() {
        Object object;
        block3: {
            block2: {
                object = this.getDisplayValueVersion();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "v" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public String getShortDisplayValue() {
        Object object;
        block3: {
            block2: {
                object = this.getDisplayValueVersion();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "API " + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public String getLongDisplayValue() {
        Object object;
        block3: {
            block2: {
                object = this.getDisplayValueVersion();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "API Level " + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getDisplayValueVersion() {
        return this.androidApiLevel == null ? null : (this.includeMinorVersion ? this.androidApiLevel.getMajorVersion() + "." + this.androidApiLevel.getMinorVersion() : String.valueOf(this.androidApiLevel.getMajorVersion()));
    }

    @JvmStatic
    @Nullable
    public static final VersionQualifier getQualifier(@NotNull String segment) {
        return Companion.getQualifier(segment);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/ide/common/resources/configuration/VersionQualifier$Companion;", "", "<init>", "()V", "DEFAULT_API_LEVEL", "Lcom/android/sdklib/AndroidApiLevel;", "DEFAULT", "Lcom/android/ide/common/resources/configuration/VersionQualifier;", "versionPattern", "Lkotlin/text/Regex;", "NAME", "", "getQualifier", "segment", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final VersionQualifier getQualifier(@NotNull String segment) {
            Integer minorVersion;
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            MatchResult matchResult = versionPattern.matchEntire((CharSequence)segment);
            if (matchResult == null) {
                return null;
            }
            MatchResult match2 = matchResult;
            Integer n = StringsKt.toIntOrNull((String)((String)match2.getGroupValues().get(1)));
            if (n == null) {
                return null;
            }
            int majorVersion = n;
            Integer n2 = minorVersion = StringsKt.toIntOrNull((String)((String)match2.getGroupValues().get(3)));
            return new VersionQualifier(new AndroidApiLevel(majorVersion, n2 != null ? n2 : 0), minorVersion != null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

