/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\r\u0010\u0013\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0014J\u0006\u0010\u0015\u001a\u00020\u0011J.\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00110\u001bJ\u0017\u0010\u001c\u001a\u00020\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/PathCollection;", "", "physicalFiles", "", "Ljava/nio/file/Path;", "physicalDirectories", "virtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualDirectories", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;)V", "getPhysicalFiles", "()Ljava/util/Collection;", "getPhysicalDirectories", "getVirtualFiles", "getVirtualDirectories", "isEmpty", "", "hasFiles", "hasVirtual", "hasVirtual$lint_cli", "isNotEmpty", "partition", "Lkotlin/Pair;", "fileSystem", "Lcom/intellij/openapi/vfs/local/CoreLocalFileSystem;", "keepVirtual", "Lkotlin/Function1;", "plus", "paths", "toString", "", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nUastEnvironmentVirtualFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastEnvironmentVirtualFileUtils.kt\ncom/android/tools/lint/PathCollection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n3301#2,10:258\n3301#2,10:268\n3301#2,10:278\n3301#2,10:288\n*S KotlinDebug\n*F\n+ 1 UastEnvironmentVirtualFileUtils.kt\ncom/android/tools/lint/PathCollection\n*L\n196#1:258,10\n197#1:268,10\n198#1:278,10\n199#1:288,10\n*E\n"})
public final class PathCollection {
    @NotNull
    private final Collection<Path> physicalFiles;
    @NotNull
    private final Collection<Path> physicalDirectories;
    @NotNull
    private final Collection<VirtualFile> virtualFiles;
    @NotNull
    private final Collection<VirtualFile> virtualDirectories;

    public PathCollection(@NotNull Collection<? extends Path> physicalFiles, @NotNull Collection<? extends Path> physicalDirectories, @NotNull Collection<? extends VirtualFile> virtualFiles, @NotNull Collection<? extends VirtualFile> virtualDirectories) {
        Intrinsics.checkNotNullParameter(physicalFiles, (String)"physicalFiles");
        Intrinsics.checkNotNullParameter(physicalDirectories, (String)"physicalDirectories");
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        Intrinsics.checkNotNullParameter(virtualDirectories, (String)"virtualDirectories");
        this.physicalFiles = physicalFiles;
        this.physicalDirectories = physicalDirectories;
        this.virtualFiles = virtualFiles;
        this.virtualDirectories = virtualDirectories;
    }

    @NotNull
    public final Collection<Path> getPhysicalFiles() {
        return this.physicalFiles;
    }

    @NotNull
    public final Collection<Path> getPhysicalDirectories() {
        return this.physicalDirectories;
    }

    @NotNull
    public final Collection<VirtualFile> getVirtualFiles() {
        return this.virtualFiles;
    }

    @NotNull
    public final Collection<VirtualFile> getVirtualDirectories() {
        return this.virtualDirectories;
    }

    public final boolean isEmpty() {
        return this.physicalFiles.isEmpty() && this.physicalDirectories.isEmpty() && this.virtualFiles.isEmpty() && this.virtualDirectories.isEmpty();
    }

    public final boolean hasFiles() {
        return !this.physicalFiles.isEmpty() || !this.virtualFiles.isEmpty();
    }

    public final boolean hasVirtual$lint_cli() {
        return !this.virtualFiles.isEmpty() || !this.virtualDirectories.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final Pair<PathCollection, PathCollection> partition(@NotNull CoreLocalFileSystem fileSystem, @NotNull Function1<? super VirtualFile, Boolean> keepVirtual) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter(keepVirtual, (String)"keepVirtual");
        Iterable $this$partition$iv = this.physicalFiles;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Path p0 = (Path)element$iv;
            boolean bl = false;
            boolean bl2 = PathCollection.partition$keepPhysical(fileSystem, keepVirtual, p0) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List physicalFilesT = (List)pair.component1();
        List physicalFilesF = (List)pair.component2();
        Iterable $this$partition$iv2 = this.physicalDirectories;
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        for (Object element$iv : $this$partition$iv2) {
            Path p0 = (Path)element$iv;
            boolean bl = false;
            boolean bl3 = PathCollection.partition$keepPhysical(fileSystem, keepVirtual, p0) ? first$iv2.add(element$iv) : second$iv2.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv2, second$iv2);
        List physicalDirsT = (List)pair2.component1();
        List physicalDirsF = (List)pair2.component2();
        Iterable $this$partition$iv3 = this.virtualFiles;
        boolean $i$f$partition3 = false;
        ArrayList first$iv3 = new ArrayList();
        ArrayList second$iv3 = new ArrayList();
        for (Object element$iv : $this$partition$iv3) {
            boolean bl = (Boolean)keepVirtual.invoke(element$iv) != false ? first$iv3.add(element$iv) : second$iv3.add(element$iv);
        }
        Pair pair3 = new Pair(first$iv3, second$iv3);
        List virtualFilesT = (List)pair3.component1();
        List virtualFilesF = (List)pair3.component2();
        Iterable $this$partition$iv4 = this.virtualDirectories;
        boolean $i$f$partition4 = false;
        ArrayList first$iv4 = new ArrayList();
        ArrayList second$iv4 = new ArrayList();
        for (Object element$iv : $this$partition$iv4) {
            boolean bl = (Boolean)keepVirtual.invoke(element$iv) != false ? first$iv4.add(element$iv) : second$iv4.add(element$iv);
        }
        Pair pair4 = new Pair(first$iv4, second$iv4);
        List virtualDirsT = (List)pair4.component1();
        List virtualDirsF = (List)pair4.component2();
        return TuplesKt.to((Object)new PathCollection(physicalFilesT, physicalDirsT, virtualFilesT, virtualDirsT), (Object)new PathCollection(physicalFilesF, physicalDirsF, virtualFilesF, virtualDirsF));
    }

    @NotNull
    public final PathCollection plus(@NotNull Collection<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Set newPhysicalFiles = CollectionsKt.toMutableSet((Iterable)this.physicalFiles);
        Set newPhysicalDirectories = CollectionsKt.toMutableSet((Iterable)this.physicalDirectories);
        for (Path path : paths) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl = Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? newPhysicalDirectories.add(path) : newPhysicalFiles.add(path);
        }
        return new PathCollection(newPhysicalFiles, newPhysicalDirectories, this.virtualFiles, this.virtualDirectories);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("PathCollection {").append('\n');
        $this$toString_u24lambda_u240.append("  physical: ");
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.plus(this.physicalDirectories, (Iterable)this.physicalFiles), (Appendable)$this$toString_u24lambda_u240, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)114, null);
        $this$toString_u24lambda_u240.append('\n');
        $this$toString_u24lambda_u240.append("  virtual: ");
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.plus(this.virtualDirectories, (Iterable)this.virtualFiles), (Appendable)$this$toString_u24lambda_u240, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)114, null);
        $this$toString_u24lambda_u240.append('\n');
        $this$toString_u24lambda_u240.append("}").append('\n');
        return stringBuilder.toString();
    }

    private static final boolean partition$keepPhysical(CoreLocalFileSystem $fileSystem, Function1<? super VirtualFile, Boolean> $keepVirtual, Path path) {
        VirtualFile vFile = $fileSystem.findFileByPath(((Object)path).toString());
        return vFile != null && (Boolean)$keepVirtual.invoke((Object)vFile) != false;
    }
}

