/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SeverityKt;
import com.android.tools.lint.model.LintModelSeverity;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0002J<\u0010\u001b\u001a\u00020\u00052\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0\u001dj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e`\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010#\u001a\u00020$*\u00020\"H\u0002J2\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/LintBatchAnalytics;", "", "<init>", "()V", "logSession", "", "registry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "flags", "Lcom/android/tools/lint/LintCliFlags;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "projects", "", "Lcom/android/tools/lint/detector/api/Project;", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "computeApplicationId", "", "computeAnalysisType", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "computeProjectId", "projectPath", "Ljava/io/File;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "recordSeverityOverride", "map", "Ljava/util/HashMap;", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "Lkotlin/collections/HashMap;", "id", "lintSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "toAnalyticsSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "computeIssueData", "", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nLintBatchAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintBatchAnalytics.kt\ncom/android/tools/lint/LintBatchAnalytics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class LintBatchAnalytics {
    public final void logSession(@NotNull IssueRegistry registry, @NotNull LintCliFlags flags, @NotNull LintDriver driver, @NotNull Collection<? extends Project> projects, @NotNull List<Incident> incidents) {
        AndroidStudioEvent.Builder builder;
        boolean scheduler2;
        Object clientName;
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        LintClient client = driver.getClient();
        if (LintClient.Companion.isUnitTest()) {
            return;
        }
        try {
            if (!AnalyticsSettings.getInitialized()) {
                AnalyticsSettings.initialize$default((ILogger)((ILogger)new StdLogger(StdLogger.Level.WARNING)), null, null, (int)6, null);
            }
        }
        catch (Throwable failure) {
            client.log(failure, "Could not initialize analytics", new Object[0]);
            return;
        }
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        boolean initializedUsageTracker = false;
        if (!UsageTracker.INSTANCE.getInitialized()) {
            initializedUsageTracker = true;
            ScheduledExecutorService scheduledExecutorService = JobScheduler.getScheduler();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"getScheduler(...)");
            ScheduledExecutorService scheduler2 = scheduledExecutorService;
            UsageTracker.initialize((ScheduledExecutorService)scheduler2);
            UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
            UsageTracker.setMaxJournalSize((int)1000);
            clientName = client.getClientDisplayName();
            String string = client.getClientDisplayRevision();
            if (string == null) {
                string = "unknown";
            }
            String clientVersion = string;
            UsageTracker.setVersion((String)((String)clientName + " " + clientVersion));
            if (Boolean.getBoolean("idea.is.internal") || ApplicationManager.getApplication().isInternal()) {
                UsageTracker.setIdeaIsInternal((boolean)true);
            }
        }
        boolean bl = scheduler2 = !projects.isEmpty();
        if (_Assertions.ENABLED && !scheduler2) {
            clientName = "Assertion failed";
            throw new AssertionError(clientName);
        }
        LintSession.Builder $this$logSession_u24lambda_u240 = clientName = LintSession.newBuilder();
        boolean bl2 = false;
        $this$logSession_u24lambda_u240.setAnalysisType(this.computeAnalysisType(flags));
        $this$logSession_u24lambda_u240.setProjectId(this.computeProjectId(projects));
        $this$logSession_u24lambda_u240.setLintPerformance(this.computePerformance(driver));
        $this$logSession_u24lambda_u240.setBaselineEnabled(driver.getBaseline() != null);
        $this$logSession_u24lambda_u240.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $this$logSession_u24lambda_u240.setIncludingTestSources(driver.getCheckTestSources());
        $this$logSession_u24lambda_u240.setIncludingDependencies(driver.getCheckDependencies());
        $this$logSession_u24lambda_u240.setAbortOnError(flags.isSetExitCode());
        $this$logSession_u24lambda_u240.setIgnoreWarnings(flags.isIgnoreWarnings());
        $this$logSession_u24lambda_u240.setWarningsAsErrors(flags.isWarningsAsErrors());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(incidents, flags, registry).values()) {
            $this$logSession_u24lambda_u240.addIssueIds(issueBuilder);
        }
        LintSession session = clientName.build();
        AndroidStudioEvent.Builder $this$logSession_u24lambda_u241 = builder = AndroidStudioEvent.newBuilder();
        boolean bl3 = false;
        $this$logSession_u24lambda_u241.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $this$logSession_u24lambda_u241.setLintSession(session);
        $this$logSession_u24lambda_u241.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $this$logSession_u24lambda_u241.setJvmDetails(CommonMetricsData.getJvmDetails());
        String string = this.computeApplicationId(projects);
        if (string != null) {
            String it = string;
            boolean bl4 = false;
            $this$logSession_u24lambda_u241.setRawProjectId(it);
        }
        AndroidStudioEvent.Builder event = builder;
        Intrinsics.checkNotNull((Object)event);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
        if (initializedUsageTracker) {
            UsageTracker.deinitialize();
        }
    }

    private final String computeApplicationId(Collection<? extends Project> projects) {
        for (Project project : projects) {
            if (!project.isAndroidProject() || project.isLibrary()) continue;
            String string = project.getApplicationId();
            if (string == null) continue;
            return string;
        }
        for (Project project : projects) {
            if (!project.isAndroidProject()) continue;
            String string = project.getApplicationId();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private final LintSession.AnalysisType computeAnalysisType(LintCliFlags flags) {
        return flags.isFatalOnly() ? LintSession.AnalysisType.VITAL : LintSession.AnalysisType.BUILD;
    }

    private final String computeProjectId(Collection<? extends Project> projects) {
        Project project = (Project)CollectionsKt.firstOrNull((Iterable)projects);
        return this.computeProjectId(project != null ? project.getDir() : null);
    }

    private final String computeProjectId(File projectPath) {
        if (projectPath == null) {
            return null;
        }
        String string = Anonymizer.anonymize((String)projectPath.getAbsolutePath());
        if (string == null) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    private final LintPerformance computePerformance(LintDriver driver) {
        LintPerformance.Builder builder;
        LintPerformance.Builder $this$computePerformance_u24lambda_u240 = builder = LintPerformance.newBuilder();
        boolean bl = false;
        $this$computePerformance_u24lambda_u240.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $this$computePerformance_u24lambda_u240.setFileCount((long)driver.getFileCount());
        $this$computePerformance_u24lambda_u240.setModuleCount((long)driver.getModuleCount());
        $this$computePerformance_u24lambda_u240.setJavaSourceCount((long)driver.getJavaFileCount());
        $this$computePerformance_u24lambda_u240.setKotlinSourceCount((long)driver.getKotlinFileCount());
        $this$computePerformance_u24lambda_u240.setResourceFileCount((long)driver.getResourceFileCount());
        $this$computePerformance_u24lambda_u240.setTestSourceCount((long)driver.getTestSourceCount());
        $this$computePerformance_u24lambda_u240.setInitializeTimeMs(driver.getInitializeTimeMs());
        $this$computePerformance_u24lambda_u240.setRegisterCustomDetectorsTimeMs(driver.getRegisterCustomDetectorsTimeMs());
        $this$computePerformance_u24lambda_u240.setComputeDetectorsTimeMs(driver.getComputeDetectorsTimeMs());
        $this$computePerformance_u24lambda_u240.setCheckProjectTimeMs(driver.getCheckProjectTimeMs());
        $this$computePerformance_u24lambda_u240.setExtraPhasesTimeMs(driver.getExtraPhasesTimeMs());
        $this$computePerformance_u24lambda_u240.setReportBaselineIssuesTimeMs(driver.getReportBaselineIssuesTimeMs());
        $this$computePerformance_u24lambda_u240.setDisposeProjectsTimeMs(driver.getDisposeProjectsTimeMs());
        $this$computePerformance_u24lambda_u240.setReportGenerationTimeMs(driver.getReportGenerationTimeMs());
        LintPerformance lintPerformance = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)lintPerformance, (String)"build(...)");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map, String id, Severity lintSeverity) {
        LintIssueId.Builder builder;
        LintIssueId.Builder builder2 = map.get(id);
        if (builder2 != null) {
            return;
        }
        LintIssueId.Builder $this$recordSeverityOverride_u24lambda_u240 = builder = LintIssueId.newBuilder();
        boolean bl = false;
        ((Map)map).put(id, $this$recordSeverityOverride_u24lambda_u240);
        $this$recordSeverityOverride_u24lambda_u240.setIssueId(id);
        $this$recordSeverityOverride_u24lambda_u240.setCount(0L);
        $this$recordSeverityOverride_u24lambda_u240.setSeverity(this.toAnalyticsSeverity(lintSeverity));
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(Severity $this$toAnalyticsSeverity) {
        LintIssueId.LintSeverity lintSeverity;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toAnalyticsSeverity.ordinal()]) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<Incident> incidents, LintCliFlags flags, IssueRegistry registry) {
        LinkedHashMap map = new LinkedHashMap(registry.getIssues().size());
        for (Incident incident : incidents) {
            Issue issue = incident.getIssue();
            String id = issue.getId();
            LintIssueId.Builder builder = (LintIssueId.Builder)map.get(id);
            if (builder == null) {
                LintIssueId.Builder builder2;
                LintBatchAnalytics $this$computeIssueData_u24lambda_u240 = this;
                boolean bl = false;
                LintIssueId.Builder $this$computeIssueData_u24lambda_u240_u240 = builder2 = LintIssueId.newBuilder();
                boolean bl2 = false;
                ((Map)map).put(id, $this$computeIssueData_u24lambda_u240_u240);
                $this$computeIssueData_u24lambda_u240_u240.setIssueId(issue.getId());
                $this$computeIssueData_u24lambda_u240_u240.setSeverity(incident.getSeverity() == issue.getDefaultSeverity() ? LintIssueId.LintSeverity.DEFAULT_SEVERITY : $this$computeIssueData_u24lambda_u240.toAnalyticsSeverity(incident.getSeverity()));
                builder = builder2;
            }
            LintIssueId.Builder issueBuilder = builder;
            issueBuilder.setCount(issueBuilder.getCount() + 1L);
        }
        for (Map.Entry entry : flags.getSeverityOverrides().entrySet()) {
            String id = (String)entry.getKey();
            LintModelSeverity severity = (LintModelSeverity)entry.getValue();
            HashMap hashMap = map;
            Intrinsics.checkNotNull((Object)id);
            Intrinsics.checkNotNull((Object)severity);
            this.recordSeverityOverride(hashMap, id, SeverityKt.getSeverity((LintModelSeverity)severity, (Issue)registry.getIssue(id)));
        }
        for (String string : flags.getSuppressedIds()) {
            HashMap hashMap = map;
            Intrinsics.checkNotNull((Object)string);
            this.recordSeverityOverride(hashMap, string, Severity.IGNORE);
        }
        for (String string : flags.getEnabledIds()) {
            HashMap hashMap = map;
            Intrinsics.checkNotNull((Object)string);
            Issue issue = registry.getIssue(string);
            if (issue == null || (issue = issue.getDefaultSeverity()) == null) {
                issue = Severity.WARNING;
            }
            this.recordSeverityOverride(hashMap, string, (Severity)issue);
        }
        return map;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.INFORMATIONAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.IGNORE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

