/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\"\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"stripComments", "", "source", "extension", "stripLineComments", "", "stripJavaLikeComments", "stripXmlComments", "lint-cli"})
public final class CommentUtilsKt {
    @NotNull
    public static final String stripComments(@NotNull String source, @NotNull String extension, boolean stripLineComments) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        switch (extension) {
            case ".gradle": 
            case ".kt": 
            case ".java": 
            case ".kts": {
                string = CommentUtilsKt.stripJavaLikeComments(source, extension, stripLineComments);
                break;
            }
            case ".xml": {
                string = CommentUtilsKt.stripXmlComments(source);
                break;
            }
            default: {
                string = source;
            }
        }
        return string;
    }

    public static /* synthetic */ String stripComments$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return CommentUtilsKt.stripComments(string, string2, bl);
    }

    private static final String stripJavaLikeComments(String source, String extension, boolean stripLineComments) {
        StringBuilder sb = new StringBuilder(source.length());
        int state = 0;
        int INIT = 0;
        int INIT_SLASH = 1;
        int LINE_COMMENT = 2;
        int BLOCK_COMMENT = 3;
        int BLOCK_COMMENT_ASTERISK = 4;
        int BLOCK_COMMENT_SLASH = 5;
        int IN_STRING = 6;
        int IN_STRING_ESCAPE = 7;
        int IN_CHAR = 8;
        int AFTER_CHAR = 9;
        int blockCommentDepth = 0;
        int n = source.length();
        block17: for (int i = 0; i < n; ++i) {
            char c = source.charAt(i);
            int n2 = state;
            if (n2 == 0) {
                switch (c) {
                    case '/': {
                        state = INIT_SLASH;
                        Object object = Unit.INSTANCE;
                        break;
                    }
                    case '\"': {
                        state = IN_STRING;
                        Object object = sb.append(c);
                        break;
                    }
                    case '\'': {
                        state = IN_CHAR;
                        Object object = sb.append(c);
                        break;
                    }
                    default: {
                        Object object = sb.append(c);
                    }
                }
                continue;
            }
            if (n2 == INIT_SLASH) {
                if (c == '*') {
                    ++blockCommentDepth;
                    state = BLOCK_COMMENT;
                    continue;
                }
                if (c == '/' && stripLineComments) {
                    state = LINE_COMMENT;
                    continue;
                }
                state = INIT;
                sb.append('/');
                sb.append(c);
                continue;
            }
            if (n2 == LINE_COMMENT) {
                if (c != '\n') continue;
                state = INIT;
                for (int i2 = sb.length() - 1; i2 >= 0; --i2) {
                    char ch = sb.charAt(i2);
                    if (ch == '\n') {
                        sb.setLength(i2 + 1);
                        continue block17;
                    }
                    if (CharsKt.isWhitespace((char)ch)) continue;
                    sb.setLength(i2 + 1);
                    sb.append('\n');
                    continue block17;
                }
                continue;
            }
            if (n2 == BLOCK_COMMENT) {
                switch (c) {
                    case '*': {
                        state = BLOCK_COMMENT_ASTERISK;
                        break;
                    }
                    case '/': {
                        state = BLOCK_COMMENT_SLASH;
                    }
                }
                continue;
            }
            if (n2 == BLOCK_COMMENT_ASTERISK) {
                int n3;
                switch (c) {
                    case '/': {
                        if (--blockCommentDepth == 0) {
                            n3 = INIT;
                            break;
                        }
                        n3 = BLOCK_COMMENT;
                        break;
                    }
                    case '*': {
                        n3 = BLOCK_COMMENT_ASTERISK;
                        break;
                    }
                    default: {
                        n3 = BLOCK_COMMENT;
                    }
                }
                state = n3;
                continue;
            }
            if (n2 == BLOCK_COMMENT_SLASH) {
                if (c == '*' && (Intrinsics.areEqual((Object)extension, (Object)".kt") || Intrinsics.areEqual((Object)extension, (Object)".kts"))) {
                    ++blockCommentDepth;
                }
                if (c == '/') continue;
                state = BLOCK_COMMENT;
                continue;
            }
            if (n2 == IN_STRING) {
                switch (c) {
                    case '\\': {
                        state = IN_STRING_ESCAPE;
                        break;
                    }
                    case '\"': {
                        state = INIT;
                    }
                }
                sb.append(c);
                continue;
            }
            if (n2 == IN_STRING_ESCAPE) {
                sb.append(c);
                state = IN_STRING;
                continue;
            }
            if (n2 == IN_CHAR) {
                if (c != '\\') {
                    state = AFTER_CHAR;
                }
                sb.append(c);
                continue;
            }
            if (n2 != AFTER_CHAR) continue;
            sb.append(c);
            if (c != '\'') continue;
            state = INIT;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String stripJavaLikeComments$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return CommentUtilsKt.stripJavaLikeComments(string, string2, bl);
    }

    @NotNull
    public static final String stripXmlComments(@NotNull String source) {
        int commentEnd;
        int commentStart;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        block0: while (i < source.length() && (commentStart = StringsKt.indexOf$default((CharSequence)source, (String)"<!--", (int)i, (boolean)false, (int)4, null)) != -1 && (commentEnd = StringsKt.indexOf$default((CharSequence)source, (String)"-->", (int)(i + 4), (boolean)false, (int)4, null)) != -1) {
            boolean foundLineStart = false;
            while (commentStart > 0) {
                char ch = source.charAt(commentStart - 1);
                if (ch == '\n') {
                    foundLineStart = true;
                    break;
                }
                if (!CharsKt.isWhitespace((char)ch)) break;
                --commentStart;
            }
            String string = source.substring(i, commentStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            sb.append(string);
            i = commentEnd + 3;
            if (!foundLineStart) continue;
            for (int j = i; j < source.length(); ++j) {
                char ch = source.charAt(j);
                if (ch == '\n') {
                    i = j + 1;
                    continue block0;
                }
                if (!CharsKt.isWhitespace((char)ch)) continue block0;
            }
        }
        String string = source.substring(i, source.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        sb.append(string);
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

