/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidLocationsSingleton;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.ApkAnalyzerImpl;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionDescriptor;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.internal.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkAnalyzerCli {
    private static final String TOOLSDIR = "com.android.sdklib.toolsdir";
    private static final String FLAG_FILES_ONLY = "files-only";
    private static final String FLAG_TYPE = "type";
    private static final String FLAG_PACKAGE = "package";
    private static final String FLAG_NAME = "name";
    private static final String FLAG_CONFIG = "config";
    private static final String FLAG_FILES = "files";
    private static final String FLAG_PROGUARD_USAGES = "proguard-usages";
    private static final String FLAG_PROGUARD_MAPPINGS = "proguard-mappings";
    private static final String FLAG_PROGUARD_SEEDS = "proguard-seeds";
    private static final String FLAG_PROGUARD_FOLDER = "proguard-folder";
    private static final String FLAG_INPUT_FILE = "input-file";
    private static final String FLAG_SHOW_DEFINED_ONLY = "defined-only";
    private static final String FLAG_SHOW_REMOVED = "show-removed";
    private static final String FLAG_CLASS = "class";
    private static final String FLAG_METHOD = "method";
    private static final String FLAG_REFERENCES_TO = "references-to";
    private static final String FLAG_NOT_REQUIRED = "not-required";
    private static final String FLAG_PATCH_SIZE = "patch-size";
    private static final String FLAG_FILE_PATH = "file";
    private static final String FLAG_DIFF_ONLY = "different-only";
    private static final String FLAG_RAW_SIZE = "raw-size";
    private static final String FLAG_DOWNLOAD_SIZE = "download-size";
    private static final String FLAG_HUMAN_READABLE = "human-readable";
    private static final String APKANALYZER = "apkanalyzer";
    private static final String SUBJECT_APK = "apk";
    private static final String SUBJECT_FILES = "files";
    private static final String SUBJECT_MANIFEST = "manifest";
    private static final String SUBJECT_DEX = "dex";
    private static final String SUBJECT_RESOURCES = "resources";
    private static final String ACTION_SUMMARY = "summary";
    private static final String ACTION_RAW_SIZE = "file-size";
    private static final String ACTION_DOWNLOAD_SIZE = "download-size";
    private static final String ACTION_LIST = "list";
    private static final String ACTION_CAT = "cat";
    private static final String ACTION_PRINT = "print";
    private static final String ACTION_APPLICATION_ID = "application-id";
    private static final String ACTION_VERSION_NAME = "version-name";
    private static final String ACTION_VERSION_CODE = "version-code";
    private static final String ACTION_MIN_SDK = "min-sdk";
    private static final String ACTION_TARGET_SDK = "target-sdk";
    private static final String ACTION_PERMISSIONS = "permissions";
    private static final String ACTION_DEBUGGABLE = "debuggable";
    private static final String ACTION_REFERENCES = "references";
    private static final String ACTION_REFERENCE_TREE = "reference-tree";
    private static final String ACTION_PACKAGES = "packages";
    private static final String ACTION_CODE = "code";
    private static final String ACTION_XML = "xml";
    private static final String ACTION_CONFIGS = "configs";
    private static final String ACTION_VALUE = "value";
    private static final String ACTION_FEATURES = "features";
    private static final String ACTION_COMPARE = "compare";
    private static final String ACTION_NAMES = "names";
    private final PrintStream out;
    private final PrintStream err;
    private final ApkAnalyzerImpl impl;

    public ApkAnalyzerCli(@NotNull PrintStream out, @NotNull PrintStream err, ApkAnalyzerImpl impl) {
        this.out = out;
        this.err = err;
        this.impl = impl;
    }

    public static void main(String[] args) {
        ApkAnalyzerCli instance = new ApkAnalyzerCli(System.out, System.err, new ApkAnalyzerImpl(System.out, ApkAnalyzerCli.getAaptInvokerFromSdk(null)));
        instance.run(args);
    }

    @VisibleForTesting
    void run(String ... args) {
        OptionParser verbParser = new OptionParser();
        verbParser.posixlyCorrect(true);
        verbParser.allowsUnrecognizedOptions();
        OptionSpecBuilder humanReadableSpec = verbParser.accepts(FLAG_HUMAN_READABLE, "Print sizes in human readable format");
        NonOptionArgumentSpec verbSpec = verbParser.nonOptions().ofType(String.class);
        verbParser.formatHelpWith((joptsimple.HelpFormatter)new HelpFormatter());
        OptionSet parsed = verbParser.parse(args);
        List list = parsed.valuesOf((OptionSpec)verbSpec);
        if (list.isEmpty()) {
            this.printArgsList(null);
        } else if (list.size() == 1) {
            this.printArgsList((String)list.get(0));
        } else {
            List<Action> actions = Action.findActions((String)list.get(0), (String)list.get(1));
            if (actions.isEmpty()) {
                actions = Action.findActions((String)list.get(0), null);
                if (actions.isEmpty()) {
                    this.printArgsList(null);
                } else {
                    this.printArgsList((String)list.get(0));
                }
            } else {
                this.impl.setHumanReadableFlag(parsed.has((OptionSpec)humanReadableSpec));
                try {
                    actions.get(0).execute(this.out, this.err, this.impl, Arrays.copyOfRange(args, parsed.has((OptionSpec)humanReadableSpec) ? 3 : 2, args.length));
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof OptionException) {
                        this.err.println();
                        this.err.println("ERROR: " + e.getCause().getMessage());
                    } else {
                        this.err.println();
                        this.err.println("ERROR: " + e.getMessage());
                    }
                    this.exit(1);
                }
                return;
            }
        }
        try {
            this.err.println("Usage:" + System.lineSeparator() + APKANALYZER + " [global options] <subject> <verb> [options] <apk> [<apk2>]" + System.lineSeparator());
            verbParser.printHelpOn((OutputStream)this.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void exit(int code) {
        System.exit(code);
    }

    private void printArgsList(@Nullable String subject) {
        if (subject == null) {
            String subjects = Arrays.stream(Action.values()).map(action -> action.getSubject()).distinct().collect(Collectors.joining(", "));
            this.err.println("Subject must be one of: " + subjects);
            this.err.println();
            Rows rows = new Rows(120, 2);
            for (Action action2 : Action.values()) {
                rows.add(action2.getSubject() + " " + action2.getVerb(), action2.getDescription());
            }
            rows.fitToWidth();
            this.err.println(rows.render());
        } else {
            List<Action> actions = Action.findActions(subject, null);
            String verbs = actions.stream().map(action -> action.getVerb()).collect(Collectors.joining(", "));
            this.err.println("Verb must be one of: " + verbs);
            this.err.println();
            for (Action action3 : actions) {
                this.err.println("==============================");
                this.err.println(action3.getSubject() + " " + action3.getVerb() + ":");
                this.err.println(action3.getDescription());
                this.err.println();
                try {
                    action3.getParser().printHelpOn((OutputStream)this.err);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                this.err.println();
            }
        }
    }

    public static AaptInvoker getAaptInvokerFromSdk(@Nullable String osSdkFolder) {
        if (osSdkFolder == null) {
            String toolsDirProp = System.getProperty(TOOLSDIR);
            if (toolsDirProp == null) {
                toolsDirProp = System.getenv(TOOLSDIR);
            }
            if (toolsDirProp != null) {
                File tools;
                if (!toolsDirProp.isEmpty()) {
                    try {
                        tools = new File(toolsDirProp).getCanonicalFile();
                        osSdkFolder = ApkAnalyzerCli.findSdkRoot(tools);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (osSdkFolder == null) {
                    try {
                        tools = new File(".").getCanonicalFile().getParentFile();
                        osSdkFolder = ApkAnalyzerCli.findSdkRoot(tools);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (osSdkFolder == null) {
                String cmdName = APKANALYZER + (System.getProperty("os.name").startsWith("Windows") ? ".bat" : "");
                throw new IllegalStateException(String.format("The tools directory property is not set, please make sure you are executing %1$s. Got %2$s", cmdName, toolsDirProp));
            }
        }
        AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)AndroidLocationsSingleton.INSTANCE, (Path)Paths.get(osSdkFolder, new String[0]));
        return new AaptInvoker(sdkHandler, (ILogger)new NullLogger());
    }

    @Nullable
    private static String findSdkRoot(@Nullable File toolDir) {
        if (toolDir == null) {
            return null;
        }
        File toolRoot = toolDir.getParentFile();
        if (toolRoot != null && toolRoot.getName().equals("cmdline-tools")) {
            return toolRoot.getParent();
        }
        return null;
    }

    private static final class HelpFormatter
    extends BuiltinHelpFormatter {
        public HelpFormatter() {
            super(120, 2);
        }

        protected boolean shouldShowNonOptionArgumentDisplay(OptionDescriptor nonOptionDescriptor) {
            return false;
        }
    }

    static enum Action {
        APK_SUMMARY("apk", "summary", "Prints the application Id, version code and version name."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.apkSummary(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        APK_RAW_SIZE("apk", "file-size", "Prints the file size of the APK."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.apkRawSize(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        APK_DOWNLOAD_SIZE("apk", "download-size", "Prints an estimate of the download size of the APK."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionSet opts = Action.parseOrPrintHelp(this.getParser(), err, args);
                impl.apkDownloadSize(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        APK_FEATURES("apk", "features", "Prints features used by the APK."){
            @Nullable
            public OptionSpecBuilder notRequiredSpec;
            @Nullable
            private OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.notRequiredSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_NOT_REQUIRED, "Include features marked as not required");
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.apkFeatures(((File)opts.valueOf(this.getFileSpec())).toPath(), opts.has((OptionSpec)this.notRequiredSpec));
            }
        }
        ,
        APK_COMPARE("apk", "compare", "Compares the sizes of two APKs."){
            @Nullable
            private OptionSpecBuilder diffOnlySpec;
            @Nullable
            private OptionSpecBuilder filesOnlySpec;
            @Nullable
            private OptionSpecBuilder patchSpec;
            @Nullable
            private OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.patchSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PATCH_SIZE, "Show an estimate of the file-by-file patch instead of raw difference.");
                    this.filesOnlySpec = this.parser.accepts(ApkAnalyzerCli.FLAG_FILES_ONLY, "Don't print directory entries in output.");
                    this.diffOnlySpec = this.parser.accepts(ApkAnalyzerCli.FLAG_DIFF_ONLY, "Only print directories/files with differences.");
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                List files = opts.valuesOf(this.getFileSpec());
                if (files.size() < 2) {
                    throw new RuntimeException("This method requires two APK paths - old_apk new_apk");
                }
                impl.apkCompare(((File)files.get(0)).toPath(), ((File)files.get(1)).toPath(), opts.has((OptionSpec)this.patchSpec), opts.has((OptionSpec)this.filesOnlySpec), opts.has((OptionSpec)this.diffOnlySpec));
            }
        }
        ,
        FILES_LIST("files", "list", "Lists all files in the zip."){
            @Nullable
            private OptionSpecBuilder rawSizeSpec;
            @Nullable
            private OptionSpecBuilder downloadSizeSpec;
            @Nullable
            private OptionSpecBuilder filesOnlySpec;
            @Nullable
            private OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.rawSizeSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_RAW_SIZE, "Show raw sizes of files.");
                    this.downloadSizeSpec = this.parser.accepts("download-size", "Show estimated download sizes of files.");
                    this.filesOnlySpec = this.parser.accepts(ApkAnalyzerCli.FLAG_FILES_ONLY, "Don't include directory entries in output.");
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.filesList(((File)opts.valueOf(this.getFileSpec())).toPath(), opts.has((OptionSpec)this.rawSizeSpec), opts.has((OptionSpec)this.downloadSizeSpec), opts.has((OptionSpec)this.filesOnlySpec));
            }
        }
        ,
        FILES_CAT("files", "cat", "Prints the given file contents to stdout"){
            @Nullable
            private ArgumentAcceptingOptionSpec<String> filePathSpec;
            @Nullable
            private OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.filePathSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_FILE_PATH, "File path within the APK.").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                assert (this.filePathSpec != null);
                impl.filesCat(((File)opts.valueOf(this.getFileSpec())).toPath(), (String)opts.valueOf(this.filePathSpec));
            }
        }
        ,
        MANIFEST_PRINT("manifest", "print", "Prints the manifest in XML format"){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestPrint(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_APPLICATION_ID("manifest", "application-id", "Prints the application id."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestAppId(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_VERSION_NAME("manifest", "version-name", "Prints the version name."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestVersionName(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_VERSION_CODE("manifest", "version-code", "Prints the version code."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestVersionCode(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_MIN_SDK("manifest", "min-sdk", "Prints the minimum sdk."){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestMinSdk(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_TARGET_SDK("manifest", "target-sdk", "Prints the target sdk"){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestTargetSdk(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_PERMISSIONS("manifest", "permissions", "Prints a list of used permissions"){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestPermissions(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        MANIFEST_DEBUGGABLE("manifest", "debuggable", "Prints if the app is debuggable"){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.manifestDebuggable(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        DEX_LIST("dex", "list", "Prints a list of dex files in the APK"){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.dexList(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        DEX_REFERENCES("dex", "references", "Prints number of references in dex files"){
            @Nullable
            private OptionParser parser;
            @Nullable
            ArgumentAcceptingOptionSpec<String> filesSpec;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.filesSpec = this.parser.accepts("files", "Dex file names to include. Default: all dex files.").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                assert (this.filesSpec != null);
                impl.dexReferences(((File)opts.valueOf(this.getFileSpec())).toPath(), opts.valuesOf(this.filesSpec));
            }
        }
        ,
        DEX_PACKAGES("dex", "packages", "Prints the class tree from DEX.\nP,C,M,F: indicates packages, classes methods, fields\nx,k,r,d: indicates removed, kept, referenced and defined nodes"){
            public ArgumentAcceptingOptionSpec<String> filesSpec;
            public OptionSpecBuilder showRemovedSpec;
            public OptionSpecBuilder definedOnlySpec;
            public ArgumentAcceptingOptionSpec<File> pgUsagesSpec;
            public ArgumentAcceptingOptionSpec<File> pgSeedsSpec;
            public ArgumentAcceptingOptionSpec<File> pgMappingSpec;
            public ArgumentAcceptingOptionSpec<File> pgFolderSpec;
            @Nullable
            OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.pgFolderSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_FOLDER, "The Proguard output folder to search for mappings.").withRequiredArg().ofType(File.class);
                    this.pgMappingSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_MAPPINGS, "The Proguard mappings file.").withRequiredArg().ofType(File.class);
                    this.pgSeedsSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_SEEDS, "The Proguard seeds file.").withRequiredArg().ofType(File.class);
                    this.pgUsagesSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_USAGES, "The Proguard usages file.").withRequiredArg().ofType(File.class);
                    this.definedOnlySpec = this.parser.accepts(ApkAnalyzerCli.FLAG_SHOW_DEFINED_ONLY, "Only include classes defined in the APK in the output.");
                    this.showRemovedSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_SHOW_REMOVED, "Show classes and members that were removed by Proguard.");
                    this.filesSpec = this.parser.accepts("files", "Dex file names to include. Default: all dex files.").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.dexPackages(((File)opts.valueOf(this.getFileSpec())).toPath(), opts.has(this.pgFolderSpec) ? ((File)opts.valueOf(this.pgFolderSpec)).toPath() : null, opts.has(this.pgMappingSpec) ? ((File)opts.valueOf(this.pgMappingSpec)).toPath() : null, opts.has(this.pgSeedsSpec) ? ((File)opts.valueOf(this.pgSeedsSpec)).toPath() : null, opts.has(this.pgUsagesSpec) ? ((File)opts.valueOf(this.pgUsagesSpec)).toPath() : null, opts.has((OptionSpec)this.definedOnlySpec), opts.has((OptionSpec)this.showRemovedSpec), opts.valuesOf(this.filesSpec));
            }
        }
        ,
        DEX_CODE("dex", "code", "Prints the bytecode of a class or method in smali format"){
            public ArgumentAcceptingOptionSpec<File> pgMappingSpec;
            public ArgumentAcceptingOptionSpec<File> pgFolderSpec;
            public ArgumentAcceptingOptionSpec<String> classSpec;
            public ArgumentAcceptingOptionSpec<String> methodSpec;
            @Nullable
            public OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.classSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_CLASS, "Fully qualified class name to decompile.").withRequiredArg().ofType(String.class).required();
                    this.methodSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_METHOD, "Method to decompile. Format: name(params)returnType, e.g. someMethod(Ljava/lang/String;I)V").withRequiredArg().ofType(String.class);
                    this.pgFolderSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_FOLDER, "The Proguard output folder to search for mappings.").withRequiredArg().ofType(File.class);
                    this.pgMappingSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_MAPPINGS, "The Proguard mappings file.").withRequiredArg().ofType(File.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.dexCode(((File)opts.valueOf(this.getFileSpec())).toPath(), (String)opts.valueOf(this.classSpec), (String)opts.valueOf(this.methodSpec), opts.has(this.pgFolderSpec) ? ((File)opts.valueOf(this.pgFolderSpec)).toPath() : null, opts.has(this.pgMappingSpec) ? ((File)opts.valueOf(this.pgMappingSpec)).toPath() : null);
            }
        }
        ,
        DEX_REFERENCE_TREE("dex", "reference-tree", "Prints a reference tree to a given or a list of classes/methods/fields."){
            @Nullable
            private OptionParser parser;
            @Nullable
            ArgumentAcceptingOptionSpec<String> filesSpec;
            public ArgumentAcceptingOptionSpec<String> referencesOfSpec;
            public ArgumentAcceptingOptionSpec<File> inputFileSpec;
            public ArgumentAcceptingOptionSpec<File> pgUsagesSpec;
            public ArgumentAcceptingOptionSpec<File> pgSeedsSpec;
            public ArgumentAcceptingOptionSpec<File> pgMappingSpec;
            public ArgumentAcceptingOptionSpec<File> pgFolderSpec;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.filesSpec = this.parser.accepts("files", "Dex file names to include. Default: all dex files.").withRequiredArg().ofType(String.class);
                    this.referencesOfSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_REFERENCES_TO, "Class/constructor/method/field descriptor. Format:\n  Class: class_name.\n  Constructor: class_name constructor_name\n  Method: class_name return_type method_name\n  Field: class_name field_type filed_name\nThe descriptor can be copied from the output of\n ./apkanalyzer dex packages\n").withRequiredArg().ofType(String.class);
                    this.inputFileSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_INPUT_FILE, "The file with a class, method or field to query in each line.").withRequiredArg().ofType(File.class);
                    this.pgFolderSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_FOLDER, "The Proguard output folder to search for mappings.").withRequiredArg().ofType(File.class);
                    this.pgMappingSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_MAPPINGS, "The Proguard mappings file.").withRequiredArg().ofType(File.class);
                    this.pgSeedsSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_SEEDS, "The Proguard seeds file.").withRequiredArg().ofType(File.class);
                    this.pgUsagesSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PROGUARD_USAGES, "The Proguard usages file.").withRequiredArg().ofType(File.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                if (!opts.has(this.inputFileSpec) && !opts.has(this.referencesOfSpec)) {
                    throw new RuntimeException("Either references-to or input-file shall be specified.");
                }
                impl.dexReferenceTree(((File)opts.valueOf(this.getFileSpec())).toPath(), opts.has(this.pgFolderSpec) ? ((File)opts.valueOf(this.pgFolderSpec)).toPath() : null, opts.has(this.pgMappingSpec) ? ((File)opts.valueOf(this.pgMappingSpec)).toPath() : null, opts.has(this.pgSeedsSpec) ? ((File)opts.valueOf(this.pgSeedsSpec)).toPath() : null, opts.has(this.pgUsagesSpec) ? ((File)opts.valueOf(this.pgUsagesSpec)).toPath() : null, opts.has(this.inputFileSpec) ? ((File)opts.valueOf(this.inputFileSpec)).toPath() : null, opts.has(this.referencesOfSpec) ? (String)opts.valueOf(this.referencesOfSpec) : null, opts.valuesOf(this.filesSpec));
            }
        }
        ,
        RESOURCES_PACKAGES("resources", "packages", "Prints a list of packages in resources table"){

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.resPackages(((File)opts.valueOf(this.getFileSpec())).toPath());
            }
        }
        ,
        RESOURCES_CONFIGS("resources", "configs", "Prints a list of configurations for a type"){
            public ArgumentAcceptingOptionSpec<String> packageSpec;
            public ArgumentAcceptingOptionSpec<String> typeSpec;
            @Nullable
            public OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.typeSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_TYPE, "The resource type, e.g. string").withRequiredArg().ofType(String.class).required();
                    this.packageSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PACKAGE, "The resource table package name").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.resConfigs(((File)opts.valueOf(this.getFileSpec())).toPath(), (String)opts.valueOf(this.typeSpec), (String)opts.valueOf(this.packageSpec));
            }
        }
        ,
        RESOURCES_VALUE("resources", "value", "Prints the given resource's value"){
            private ArgumentAcceptingOptionSpec<String> packageSpec;
            private ArgumentAcceptingOptionSpec<String> nameSpec;
            private ArgumentAcceptingOptionSpec<String> configSpec;
            private ArgumentAcceptingOptionSpec<String> typeSpec;
            @Nullable
            public OptionParser parser;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.typeSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_TYPE, "The resource type, e.g. string").withRequiredArg().ofType(String.class).required();
                    this.configSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_CONFIG, "The resource configuration").withRequiredArg().ofType(String.class).required();
                    this.nameSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_NAME, "The resource name").withRequiredArg().ofType(String.class).required();
                    this.packageSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PACKAGE, "The resource table package name").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                impl.resValue(((File)opts.valueOf(this.getFileSpec())).toPath(), (String)opts.valueOf(this.typeSpec), (String)opts.valueOf(this.configSpec), (String)opts.valueOf(this.nameSpec), (String)opts.valueOf(this.packageSpec));
            }
        }
        ,
        RESOURCES_NAMES("resources", "names", "Prints a list of resource names for a type"){
            @Nullable
            public OptionParser parser;
            @Nullable
            private ArgumentAcceptingOptionSpec<String> packageSpec;
            @Nullable
            private ArgumentAcceptingOptionSpec<String> configSpec;
            @Nullable
            private ArgumentAcceptingOptionSpec<String> typeSpec;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.typeSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_TYPE, "The resource type, e.g. string").withRequiredArg().ofType(String.class).required();
                    this.configSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_CONFIG, "The resource configuration").withRequiredArg().ofType(String.class).required();
                    this.packageSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_PACKAGE, "The resource table package name").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                assert (this.typeSpec != null);
                assert (this.configSpec != null);
                assert (this.packageSpec != null);
                impl.resNames(((File)opts.valueOf(this.getFileSpec())).toPath(), (String)opts.valueOf(this.typeSpec), (String)opts.valueOf(this.configSpec), (String)opts.valueOf(this.packageSpec));
            }
        }
        ,
        RESOURCES_XML("resources", "xml", "Prints the human readable form of a binary XML"){
            @Nullable
            public OptionParser parser;
            @Nullable
            private ArgumentAcceptingOptionSpec<String> filePathSpec;

            @Override
            @NotNull
            public OptionParser getParser() {
                if (this.parser == null) {
                    this.parser = super.getParser();
                    this.filePathSpec = this.parser.accepts(ApkAnalyzerCli.FLAG_FILE_PATH, "File path within the APK.").withRequiredArg().ofType(String.class);
                }
                return this.parser;
            }

            @Override
            public void execute(PrintStream out, PrintStream err, @NotNull ApkAnalyzerImpl impl, String ... args) {
                OptionParser parser = this.getParser();
                OptionSet opts = Action.parseOrPrintHelp(parser, err, args);
                assert (this.filePathSpec != null);
                impl.resXml(((File)opts.valueOf(this.getFileSpec())).toPath(), (String)opts.valueOf(this.filePathSpec));
            }
        };

        private final String description;
        private final String verb;
        private final String subject;
        private OptionParser parser;
        private NonOptionArgumentSpec<File> fileSpec;

        private Action(String subject, String verb, String description) {
            this.subject = subject;
            this.verb = verb;
            this.description = description;
        }

        private void initParser() {
            this.parser = new OptionParser();
            this.parser.formatHelpWith((joptsimple.HelpFormatter)new HelpFormatter());
            this.fileSpec = this.parser.nonOptions(ApkAnalyzerCli.SUBJECT_APK).describedAs("APK file path").ofType(File.class);
        }

        @NotNull
        public OptionParser getParser() {
            if (this.parser == null) {
                this.initParser();
            }
            return this.parser;
        }

        @NotNull
        public NonOptionArgumentSpec<File> getFileSpec() {
            if (this.parser == null) {
                this.initParser();
            }
            return this.fileSpec;
        }

        public abstract void execute(PrintStream var1, PrintStream var2, @NotNull ApkAnalyzerImpl var3, String ... var4);

        @NotNull
        public String getVerb() {
            return this.verb;
        }

        @NotNull
        public String getSubject() {
            return this.subject;
        }

        @NotNull
        public static List<Action> findActions(@NotNull String subject, @Nullable String verb) {
            ArrayList<Action> actions = new ArrayList<Action>();
            for (Action action : Action.values()) {
                if (!subject.equals(action.subject) || verb != null && !verb.equals(action.verb)) continue;
                actions.add(action);
            }
            return actions;
        }

        public String getDescription() {
            return this.description;
        }

        private static OptionSet parseOrPrintHelp(@NotNull OptionParser parser, @NotNull PrintStream err, String ... args) {
            try {
                OptionSet opts = parser.parse(args);
                List files = opts.nonOptionArguments();
                if (files.isEmpty()) {
                    try {
                        parser.printHelpOn((OutputStream)err);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    throw new RuntimeException("You must specify an apk file.");
                }
                return opts;
            }
            catch (OptionException e) {
                try {
                    parser.printHelpOn((OutputStream)err);
                }
                catch (IOException e1) {
                    throw new UncheckedIOException(e1);
                }
                throw new RuntimeException(e);
            }
        }
    }
}

