/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public final class ProcessorConfigProfileImpl
implements ProcessorConfigProfile {
    private String myName = "";
    private boolean myEnabled = false;
    private boolean myObtainProcessorsFromClasspath = true;
    private String myProcessorPath = "";
    private boolean myUseProcessorModulePath = false;
    private final Set<String> myProcessors = new LinkedHashSet<String>(1);
    private final Map<String, String> myProcessorOptions = new HashMap<String, String>(1);
    private String myGeneratedProductionDirectoryName = "generated";
    private String myGeneratedTestsDirectoryName = "generated_tests";
    private boolean myOutputRelativeToContentRoot = false;
    private boolean myIsProcOnly = false;
    private final Set<String> myModuleNames = new HashSet<String>(1);

    public ProcessorConfigProfileImpl(String name) {
        this.myName = name;
    }

    public ProcessorConfigProfileImpl(ProcessorConfigProfile profile) {
        this.initFrom(profile);
    }

    @Override
    @ApiStatus.Internal
    public void initFrom(ProcessorConfigProfile other) {
        this.myName = other.getName();
        this.myEnabled = other.isEnabled();
        this.myIsProcOnly = other.isProcOnly();
        this.myObtainProcessorsFromClasspath = other.isObtainProcessorsFromClasspath();
        this.myProcessorPath = other.getProcessorPath();
        this.myUseProcessorModulePath = other.isUseProcessorModulePath();
        this.myProcessors.clear();
        this.myProcessors.addAll(other.getProcessors());
        this.myProcessorOptions.clear();
        this.myProcessorOptions.putAll(other.getProcessorOptions());
        this.myGeneratedProductionDirectoryName = other.getGeneratedSourcesDirectoryName(false);
        this.myGeneratedTestsDirectoryName = other.getGeneratedSourcesDirectoryName(true);
        this.myOutputRelativeToContentRoot = other.isOutputRelativeToContentRoot();
        this.myModuleNames.clear();
        this.myModuleNames.addAll(other.getModuleNames());
    }

    @Override
    @ApiStatus.Internal
    public String getName() {
        return this.myName;
    }

    @Override
    @ApiStatus.Internal
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @ApiStatus.Internal
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    @ApiStatus.Internal
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public String getProcessorPath() {
        String string = this.myProcessorPath;
        if (string == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @ApiStatus.Internal
    public void setProcessorPath(@Nullable String processorPath) {
        this.myProcessorPath = processorPath != null ? processorPath : "";
    }

    @Override
    @ApiStatus.Internal
    public void setUseProcessorModulePath(boolean useModulePath) {
        this.myUseProcessorModulePath = useModulePath;
    }

    @Override
    @ApiStatus.Internal
    public boolean isUseProcessorModulePath() {
        return this.myUseProcessorModulePath;
    }

    @Override
    @ApiStatus.Internal
    public boolean isObtainProcessorsFromClasspath() {
        return this.myObtainProcessorsFromClasspath;
    }

    @Override
    @ApiStatus.Internal
    public void setObtainProcessorsFromClasspath(boolean value) {
        this.myObtainProcessorsFromClasspath = value;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public String getGeneratedSourcesDirectoryName(boolean forTests) {
        String string = forTests ? this.myGeneratedTestsDirectoryName : this.myGeneratedProductionDirectoryName;
        if (string == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @ApiStatus.Internal
    public void setGeneratedSourcesDirectoryName(@Nullable String name, boolean forTests) {
        if (forTests) {
            this.myGeneratedTestsDirectoryName = name != null ? name.trim() : "generated_tests";
        } else {
            this.myGeneratedProductionDirectoryName = name != null ? name.trim() : "generated";
        }
    }

    @Override
    @ApiStatus.Internal
    public boolean isOutputRelativeToContentRoot() {
        return this.myOutputRelativeToContentRoot;
    }

    @Override
    @ApiStatus.Internal
    public void setOutputRelativeToContentRoot(boolean relativeToContent) {
        this.myOutputRelativeToContentRoot = relativeToContent;
    }

    @Override
    @ApiStatus.Internal
    public boolean isProcOnly() {
        return this.myIsProcOnly;
    }

    @Override
    @ApiStatus.Internal
    public void setProcOnly(boolean value) {
        this.myIsProcOnly = value;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Set<String> getModuleNames() {
        Set<String> set = this.myModuleNames;
        if (set == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @ApiStatus.Internal
    public boolean addModuleName(String name) {
        return this.myModuleNames.add(name);
    }

    @Override
    @ApiStatus.Internal
    public boolean addModuleNames(Collection<String> names) {
        return this.myModuleNames.addAll(names);
    }

    @Override
    @ApiStatus.Internal
    public boolean removeModuleName(String name) {
        return this.myModuleNames.remove(name);
    }

    @Override
    @ApiStatus.Internal
    public boolean removeModuleNames(Collection<String> names) {
        return this.myModuleNames.removeAll(names);
    }

    @Override
    @ApiStatus.Internal
    public void clearModuleNames() {
        this.myModuleNames.clear();
    }

    @Override
    @ApiStatus.Internal
    public void clearProcessors() {
        this.myProcessors.clear();
    }

    @Override
    @ApiStatus.Internal
    public boolean addProcessor(String processor) {
        return this.myProcessors.add(processor);
    }

    @Override
    @ApiStatus.Internal
    public boolean removeProcessor(String processor) {
        return this.myProcessors.remove(processor);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Set<String> getProcessors() {
        Set<String> set = Collections.unmodifiableSet(this.myProcessors);
        if (set == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public Map<String, String> getProcessorOptions() {
        Map<String, String> map2 = Collections.unmodifiableMap(this.myProcessorOptions);
        if (map2 == null) {
            ProcessorConfigProfileImpl.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @Override
    @ApiStatus.Internal
    public String setOption(String key, String value) {
        return this.myProcessorOptions.put(key, value);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public String getOption(String key) {
        return this.myProcessorOptions.get(key);
    }

    @Override
    @ApiStatus.Internal
    public void clearProcessorOptions() {
        this.myProcessorOptions.clear();
    }

    @ApiStatus.Internal
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorConfigProfileImpl profile = (ProcessorConfigProfileImpl)o;
        if (this.myEnabled != profile.myEnabled) {
            return false;
        }
        if (this.myIsProcOnly != profile.myIsProcOnly) {
            return false;
        }
        if (this.myObtainProcessorsFromClasspath != profile.myObtainProcessorsFromClasspath) {
            return false;
        }
        if (this.myGeneratedProductionDirectoryName != null ? !this.myGeneratedProductionDirectoryName.equals(profile.myGeneratedProductionDirectoryName) : profile.myGeneratedProductionDirectoryName != null) {
            return false;
        }
        if (this.myGeneratedTestsDirectoryName != null ? !this.myGeneratedTestsDirectoryName.equals(profile.myGeneratedTestsDirectoryName) : profile.myGeneratedTestsDirectoryName != null) {
            return false;
        }
        if (this.myOutputRelativeToContentRoot != profile.myOutputRelativeToContentRoot) {
            return false;
        }
        if (this.myUseProcessorModulePath != profile.myUseProcessorModulePath) {
            return false;
        }
        if (!this.myModuleNames.equals(profile.myModuleNames)) {
            return false;
        }
        if (!this.myProcessorOptions.equals(profile.myProcessorOptions)) {
            return false;
        }
        if (this.myProcessorPath != null ? !this.myProcessorPath.equals(profile.myProcessorPath) : profile.myProcessorPath != null) {
            return false;
        }
        if (!this.myProcessors.equals(profile.myProcessors)) {
            return false;
        }
        return this.myName.equals(profile.myName);
    }

    @ApiStatus.Internal
    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myEnabled ? 1 : 0);
        result = 31 * result + (this.myIsProcOnly ? 1 : 0);
        result = 31 * result + (this.myObtainProcessorsFromClasspath ? 1 : 0);
        result = 31 * result + (this.myProcessorPath != null ? this.myProcessorPath.hashCode() : 0);
        result = 31 * result + this.myProcessors.hashCode();
        result = 31 * result + this.myProcessorOptions.hashCode();
        result = 31 * result + (this.myGeneratedProductionDirectoryName != null ? this.myGeneratedProductionDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myGeneratedTestsDirectoryName != null ? this.myGeneratedTestsDirectoryName.hashCode() : 0);
        result = 31 * result + (this.myOutputRelativeToContentRoot ? 1 : 0);
        result = 31 * result + (this.myUseProcessorModulePath ? 1 : 0);
        result = 31 * result + this.myModuleNames.hashCode();
        return result;
    }

    @ApiStatus.Internal
    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/model/java/impl/compiler/ProcessorConfigProfileImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesDirectoryName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorOptions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

