/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import one.util.streamex.Internals;

abstract class RangeBasedSpliterator<T, S extends RangeBasedSpliterator<T, ?>>
extends Internals.CloneableSpliterator<T, S> {
    int cur;
    int limit;

    public RangeBasedSpliterator(int fromInclusive, int toExclusive) {
        this.cur = fromInclusive;
        this.limit = toExclusive;
    }

    @Override
    public long estimateSize() {
        return this.limit - this.cur;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    public S trySplit() {
        int size = this.limit - this.cur;
        if (size >= 2) {
            RangeBasedSpliterator clone = (RangeBasedSpliterator)this.doClone();
            clone.limit = this.cur += size / 2;
            return (S)clone;
        }
        return null;
    }

    static final class ZipDouble
    extends RangeBasedSpliterator<Double, ZipDouble>
    implements Spliterator.OfDouble {
        private final DoubleBinaryOperator mapper;
        private final double[] arr1;
        private final double[] arr2;

        public ZipDouble(int fromInclusive, int toExclusive, DoubleBinaryOperator mapper, double[] arr1, double[] arr2) {
            super(fromInclusive, toExclusive);
            this.mapper = mapper;
            this.arr1 = arr1;
            this.arr2 = arr2;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.mapper.applyAsDouble(this.arr1[this.cur], this.arr2[this.cur]));
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action2) {
            int l = this.limit;
            for (int c = this.cur; c < l; ++c) {
                action2.accept(this.mapper.applyAsDouble(this.arr1[c], this.arr2[c]));
            }
            this.cur = this.limit;
        }
    }

    static final class OfFloat
    extends RangeBasedSpliterator<Double, OfFloat>
    implements Spliterator.OfDouble {
        private final float[] array;

        public OfFloat(int fromInclusive, int toExclusive, float[] array) {
            super(fromInclusive, toExclusive);
            this.array = array;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.array[this.cur]);
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action2) {
            int l = this.limit;
            int c = this.cur;
            while (c < l) {
                action2.accept(this.array[c++]);
            }
            this.cur = this.limit;
        }
    }

    static final class ZipLong
    extends RangeBasedSpliterator<Long, ZipLong>
    implements Spliterator.OfLong {
        private final LongBinaryOperator mapper;
        private final long[] arr1;
        private final long[] arr2;

        public ZipLong(int fromInclusive, int toExclusive, LongBinaryOperator mapper, long[] arr1, long[] arr2) {
            super(fromInclusive, toExclusive);
            this.mapper = mapper;
            this.arr1 = arr1;
            this.arr2 = arr2;
        }

        @Override
        public boolean tryAdvance(LongConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.mapper.applyAsLong(this.arr1[this.cur], this.arr2[this.cur]));
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer action2) {
            int l = this.limit;
            for (int c = this.cur; c < l; ++c) {
                action2.accept(this.mapper.applyAsLong(this.arr1[c], this.arr2[c]));
            }
            this.cur = this.limit;
        }
    }

    static final class OfShort
    extends RangeBasedSpliterator<Integer, OfShort>
    implements Spliterator.OfInt {
        private final short[] array;

        public OfShort(int fromInclusive, int toExclusive, short[] array) {
            super(fromInclusive, toExclusive);
            this.array = array;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.array[this.cur]);
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            int l = this.limit;
            int c = this.cur;
            while (c < l) {
                action2.accept(this.array[c++]);
            }
            this.cur = this.limit;
        }
    }

    static final class OfChar
    extends RangeBasedSpliterator<Integer, OfChar>
    implements Spliterator.OfInt {
        private final char[] array;

        public OfChar(int fromInclusive, int toExclusive, char[] array) {
            super(fromInclusive, toExclusive);
            this.array = array;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.array[this.cur]);
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            int l = this.limit;
            int c = this.cur;
            while (c < l) {
                action2.accept(this.array[c++]);
            }
            this.cur = this.limit;
        }
    }

    static final class OfByte
    extends RangeBasedSpliterator<Integer, OfByte>
    implements Spliterator.OfInt {
        private final byte[] array;

        public OfByte(int fromInclusive, int toExclusive, byte[] array) {
            super(fromInclusive, toExclusive);
            this.array = array;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.array[this.cur]);
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            int l = this.limit;
            int c = this.cur;
            while (c < l) {
                action2.accept(this.array[c++]);
            }
            this.cur = this.limit;
        }
    }

    static final class ZipInt
    extends RangeBasedSpliterator<Integer, ZipInt>
    implements Spliterator.OfInt {
        private final IntBinaryOperator mapper;
        private final int[] arr1;
        private final int[] arr2;

        public ZipInt(int fromInclusive, int toExclusive, IntBinaryOperator mapper, int[] arr1, int[] arr2) {
            super(fromInclusive, toExclusive);
            this.mapper = mapper;
            this.arr1 = arr1;
            this.arr2 = arr2;
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            if (this.cur < this.limit) {
                action2.accept(this.mapper.applyAsInt(this.arr1[this.cur], this.arr2[this.cur]));
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            int l = this.limit;
            for (int c = this.cur; c < l; ++c) {
                action2.accept(this.mapper.applyAsInt(this.arr1[c], this.arr2[c]));
            }
            this.cur = this.limit;
        }
    }

    static final class ZipRef<U, V, T>
    extends RangeBasedSpliterator<T, ZipRef<U, V, T>> {
        private final List<U> l1;
        private final List<V> l2;
        private final BiFunction<? super U, ? super V, ? extends T> mapper;

        public ZipRef(int fromInclusive, int toExclusive, BiFunction<? super U, ? super V, ? extends T> mapper, List<U> l1, List<V> l2) {
            super(fromInclusive, toExclusive);
            this.l1 = l1;
            this.l2 = l2;
            this.mapper = mapper;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action2) {
            if (this.cur < this.limit) {
                action2.accept(this.mapper.apply(this.l1.get(this.cur), this.l2.get(this.cur)));
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action2) {
            int l = this.limit;
            for (int c = this.cur; c < l; ++c) {
                action2.accept(this.mapper.apply(this.l1.get(c), this.l2.get(c)));
            }
            this.cur = this.limit;
        }
    }

    static final class OfSubLists<T>
    extends RangeBasedSpliterator<List<T>, OfSubLists<T>> {
        private final List<T> source;
        private final int length;
        private final int shift;
        private final int listSize;

        public OfSubLists(List<T> source, int length, int shift) {
            super(0, Math.max(0, source.size() - Math.max(length - shift, 0) - 1) / shift + 1);
            this.source = source;
            this.listSize = source.size();
            this.shift = shift;
            this.length = length;
        }

        @Override
        public boolean tryAdvance(Consumer<? super List<T>> action2) {
            if (this.cur < this.limit) {
                int start = this.cur * this.shift;
                int stop = this.listSize - this.length > start ? start + this.length : this.listSize;
                action2.accept(this.source.subList(start, stop));
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super List<T>> action2) {
            int l = this.limit;
            int ll = this.length;
            int sf = this.shift;
            int ls = this.listSize;
            int start = this.cur * sf;
            for (int c = this.cur; c < l; ++c) {
                int stop = ls - ll > start ? start + ll : ls;
                action2.accept(this.source.subList(start, stop));
                start += sf;
            }
            this.cur = this.limit;
        }
    }

    static final class AsEntry<T>
    extends RangeBasedSpliterator<Map.Entry<Integer, T>, AsEntry<T>> {
        private final List<T> list;

        public AsEntry(List<T> list) {
            super(0, list.size());
            this.list = list;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<Integer, T>> action2) {
            if (this.cur < this.limit) {
                action2.accept(new Internals.ObjIntBox<T>(this.list.get(this.cur), this.cur));
                ++this.cur;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<Integer, T>> action2) {
            int l = this.limit;
            List<T> list = this.list;
            for (int c = this.cur; c < l; ++c) {
                action2.accept(new Internals.ObjIntBox<T>(list.get(c), c));
            }
            this.cur = this.limit;
        }
    }
}

