/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtilKmp;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.ImmutableText;
import com.intellij.util.text.UnsyncCharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharArrayUtil {
    private CharArrayUtil() {
    }

    public static void getChars(@NotNull CharSequence src, char @NotNull [] dst, int dstOffset) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(0);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(1);
        }
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, char @NotNull [] dst, int dstOffset, int len) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(2);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(3);
        }
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, char @NotNull [] dst, int srcOffset, int dstOffset, int len) {
        if (src == null) {
            CharArrayUtil.$$$reportNull$$$0(4);
        }
        if (dst == null) {
            CharArrayUtil.$$$reportNull$$$0(5);
        }
        CharArrayUtilKmp.getChars(src, dst, srcOffset, dstOffset, len);
    }

    public static char @Nullable [] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        return CharArrayUtilKmp.fromSequenceWithoutCopying(seq);
    }

    public static char @NotNull [] fromSequence(@NotNull CharSequence seq) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(6);
        }
        char[] cArray = CharArrayUtilKmp.fromSequence(seq);
        if (cArray == null) {
            CharArrayUtil.$$$reportNull$$$0(7);
        }
        return cArray;
    }

    public static char @NotNull [] fromSequence(@NotNull CharSequence seq, int start, int end) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(8);
        }
        char[] cArray = CharArrayUtilKmp.fromSequence(seq, start, end);
        if (cArray == null) {
            CharArrayUtil.$$$reportNull$$$0(9);
        }
        return cArray;
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(10);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(11);
        }
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(12);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(13);
        }
        return CharArrayUtilKmp.shiftForward(buffer, chars, startOffset, endOffset);
    }

    public static int shiftForwardCarefully(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(14);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(15);
        }
        if (offset + 1 >= buffer.length()) {
            return offset;
        }
        if (!CharArrayUtil.isSuitable(chars, buffer.charAt(offset))) {
            return offset;
        }
        ++offset;
        while (offset < buffer.length()) {
            char c = buffer.charAt(offset);
            if (!CharArrayUtil.isSuitable(chars, c)) {
                return offset - 1;
            }
            ++offset;
        }
        return offset - 1;
    }

    private static boolean isSuitable(@NotNull String chars, char c) {
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(16);
        }
        for (int i = 0; i < chars.length(); ++i) {
            if (c != chars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static int shiftForward(char @NotNull [] buffer, int offset, @NotNull String chars) {
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(17);
        }
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(18);
        }
        return CharArrayUtil.shiftForward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackward(char @NotNull [] buffer, int offset, @NotNull String chars) {
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(19);
        }
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(20);
        }
        return CharArrayUtil.shiftBackward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(21);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(22);
        }
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(23);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(24);
        }
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    public static int shiftForwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(25);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(26);
        }
        return CharArrayUtilKmp.shiftForwardUntil(buffer, offset, chars);
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(27);
        }
        if (chars == null) {
            CharArrayUtil.$$$reportNull$$$0(28);
        }
        return CharArrayUtilKmp.shiftBackwardUntil(buffer, offset, chars);
    }

    public static boolean regionMatches(char @NotNull [] buffer, int start, int end, @NotNull CharSequence s) {
        int len;
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(29);
        }
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(30);
        }
        if (start + (len = s.length()) > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (buffer[start + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int start, int end, @NotNull CharSequence s) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(31);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(32);
        }
        return CharArrayUtilKmp.regionMatches(buffer, start, end, s);
    }

    private static void assertRegionIndicesInRange(int s1Length, int start1, int end1, int s2Length, int start2, int end2) {
        if (start1 < 0 || start1 > end1 || end1 > s1Length || start2 < 0 || start2 > end2 || end2 > s2Length) {
            throw new IllegalArgumentException("Indices out of bounds: (" + start1 + ", " + end1 + ") of CharSequence length " + s1Length + " vs (" + start2 + ", " + end2 + ") of CharSequence length " + s2Length);
        }
    }

    public static boolean regionMatches(@NotNull CharSequence s1, int start1, int end1, @NotNull CharSequence s2, int start2, int end2) {
        if (s1 == null) {
            CharArrayUtil.$$$reportNull$$$0(33);
        }
        if (s2 == null) {
            CharArrayUtil.$$$reportNull$$$0(34);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        CharArrayUtil.assertRegionIndicesInRange(s1.length(), start1, end1, s2.length(), start2, end2);
        int i = start1;
        int j = start2;
        while (i < end1) {
            if (s1.charAt(i) != s2.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence s1, int start1, int end1, @NotNull CharSequence s2, int start2, int end2, boolean caseSensitive) {
        if (s1 == null) {
            CharArrayUtil.$$$reportNull$$$0(35);
        }
        if (s2 == null) {
            CharArrayUtil.$$$reportNull$$$0(36);
        }
        if (caseSensitive) {
            return CharArrayUtil.regionMatches(s1, start1, end1, s2, start2, end2);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        CharArrayUtil.assertRegionIndicesInRange(s1.length(), start1, end1, s2.length(), start2, end2);
        int i = start1;
        int j = start2;
        while (i < end1) {
            if (!StringUtilRt.charsEqualIgnoreCase(s1.charAt(i), s2.charAt(j))) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int offset, @NotNull CharSequence s) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(37);
        }
        if (s == null) {
            CharArrayUtil.$$$reportNull$$$0(38);
        }
        return CharArrayUtilKmp.regionMatches(buffer, offset, s);
    }

    public static boolean equals(char @NotNull [] buffer1, int start1, int end1, char @NotNull [] buffer2, int start2, int end2) {
        if (buffer1 == null) {
            CharArrayUtil.$$$reportNull$$$0(39);
        }
        if (buffer2 == null) {
            CharArrayUtil.$$$reportNull$$$0(40);
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i = start1; i < end1; ++i) {
            if (buffer1[i] == buffer2[i - start1 + start2]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(char @NotNull [] buffer, @NotNull String pattern, int fromIndex) {
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(41);
        }
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(42);
        }
        char[] chars = pattern.toCharArray();
        int limit = buffer.length - chars.length + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(43);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(44);
        }
        return CharArrayUtil.indexOf(buffer, pattern, fromIndex, buffer.length());
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(45);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(46);
        }
        int patternLength = pattern.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int limit = toIndex - patternLength + 1;
        block0: for (int i = fromIndex; i < limit; ++i) {
            for (int j = 0; j < patternLength; ++j) {
                if (pattern.charAt(j) != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOf(char @NotNull [] buffer, char symbol, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(47);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (buffer[i] != symbol) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char @NotNull [] buffer, char symbol, int fromIndex, int toIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(48);
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = toIndex - 1; i >= fromIndex; --i) {
            if (buffer[i] != symbol) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull CharSequence buffer, @NotNull String pattern, int maxIndex) {
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(49);
        }
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(50);
        }
        char[] chars = pattern.toCharArray();
        int end = buffer.length() - chars.length;
        if (maxIndex > end) {
            maxIndex = end;
        }
        block0: for (int i = maxIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer.charAt(i + j)) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char @NotNull [] buffer, @NotNull String pattern, int maxIndex) {
        char[] chars;
        int end;
        if (pattern == null) {
            CharArrayUtil.$$$reportNull$$$0(51);
        }
        if (buffer == null) {
            CharArrayUtil.$$$reportNull$$$0(52);
        }
        if (maxIndex > (end = buffer.length - (chars = pattern.toCharArray()).length)) {
            maxIndex = end;
        }
        block0: for (int i = maxIndex; i >= 0; --i) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static boolean containsOnlyWhiteSpaces(@Nullable CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    public static TextRange @NotNull [] getIndents(@NotNull CharSequence charsSequence, int shift) {
        if (charsSequence == null) {
            CharArrayUtil.$$$reportNull$$$0(53);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int whitespaceEnd = -1;
        int lastTextFound = 0;
        for (int i = charsSequence.length() - 1; i >= 0; --i) {
            char charAt = charsSequence.charAt(i);
            boolean isWhitespace = Character.isWhitespace(charAt);
            if (charAt == '\n') {
                result.add(new TextRange(i, (whitespaceEnd >= 0 ? whitespaceEnd : i) + 1).shiftRight(shift));
                whitespaceEnd = -1;
                continue;
            }
            if (whitespaceEnd >= 0) {
                if (isWhitespace) continue;
                lastTextFound = result.size();
                whitespaceEnd = -1;
                continue;
            }
            if (isWhitespace) {
                whitespaceEnd = i;
                continue;
            }
            lastTextFound = result.size();
        }
        if (whitespaceEnd > 0) {
            result.add(new TextRange(0, whitespaceEnd + 1).shiftRight(shift));
        }
        result = lastTextFound >= result.size() ? result : result.subList(0, lastTextFound);
        TextRange[] textRangeArray = result.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            CharArrayUtil.$$$reportNull$$$0(54);
        }
        return textRangeArray;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        if (seq == null) {
            CharArrayUtil.$$$reportNull$$$0(55);
        }
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        return CharArrayUtilKmp.containLineBreaks(seq, fromOffset, endOffset);
    }

    public static boolean isEmptyOrSpaces(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            CharArrayUtil.$$$reportNull$$$0(56);
        }
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Reader readerFromCharSequence(@NotNull CharSequence text) {
        char[] chars;
        if (text == null) {
            CharArrayUtil.$$$reportNull$$$0(57);
        }
        return (chars = CharArrayUtil.fromSequenceWithoutCopying(text)) == null ? new CharSequenceReader(text) : new UnsyncCharArrayReader(chars, 0, text.length());
    }

    @NotNull
    public static ImmutableCharSequence createImmutableCharSequence(@NotNull CharSequence sequence) {
        if (sequence == null) {
            CharArrayUtil.$$$reportNull$$$0(58);
        }
        ImmutableText immutableText = ImmutableText.valueOf((Object)sequence);
        if (immutableText == null) {
            CharArrayUtil.$$$reportNull$$$0(59);
        }
        return immutableText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 54: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 54: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 6: 
            case 8: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 7: 
            case 9: 
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/CharArrayUtil";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 29: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer1";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer2";
                break;
            }
            case 41: 
            case 44: 
            case 46: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsSequence";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/CharArrayUtil";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSequence";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndents";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createImmutableCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromSequence";
                break;
            }
            case 7: 
            case 9: 
            case 54: 
            case 59: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "shiftForward";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shiftForwardCarefully";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shiftBackward";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shiftForwardUntil";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shiftBackwardUntil";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "regionMatches";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getIndents";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "containLineBreaks";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyOrSpaces";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "readerFromCharSequence";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createImmutableCharSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 54: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

