/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class CachedValuesManager {
    private static final ConcurrentMap<String, Key<CachedValue<?>>> globalKeyForProvider = new ConcurrentHashMap();
    private final ConcurrentMap<String, Key<CachedValue<?>>> keyForProvider = new ConcurrentHashMap();

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            CachedValuesManager.$$$reportNull$$$0(0);
        }
        return project.getService(CachedValuesManager.class);
    }

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull UserDataHolder var1, @NotNull CachedValueProvider<T> var2, boolean var3);

    @NotNull
    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    @NotNull
    protected abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull UserDataHolder var1, @NotNull ParameterizedCachedValueProvider<T, P> var2, boolean var3);

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(1);
        }
        CachedValue<T> cachedValue = this.createCachedValue(provider, false);
        if (cachedValue == null) {
            CachedValuesManager.$$$reportNull$$$0(2);
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T getParameterizedCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue<T, P> value;
        if (dataHolder == null) {
            CachedValuesManager.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(5);
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            if (value == null) {
                this.trackKeyHolder(dataHolder, key);
                value = this.createParameterizedCachedValue(dataHolder, provider, trackValue);
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            UserDataHolder userDataHolder = dataHolder;
            synchronized (userDataHolder) {
                value = dataHolder.getUserData(key);
                if (value == null) {
                    this.trackKeyHolder(dataHolder, key);
                    value = this.createParameterizedCachedValue(dataHolder, provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue(parameter);
    }

    @ApiStatus.Internal
    protected abstract void trackKeyHolder(@NotNull UserDataHolder var1, @NotNull Key<?> var2);

    public abstract <T> T getCachedValue(@NotNull UserDataHolder var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull CachedValueProvider<T> provider) {
        if (dataHolder == null) {
            CachedValuesManager.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(7);
        }
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider.getClass()), provider, false);
    }

    public static <T> T getCachedValue(@NotNull PsiElement context, @NotNull CachedValueProvider<T> provider) {
        if (context == null) {
            CachedValuesManager.$$$reportNull$$$0(8);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(9);
        }
        return CachedValuesManager.getCachedValue(context, CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider), provider);
    }

    public static <E extends PsiElement, T> T getProjectPsiDependentCache(@NotNull E context, @NotNull Function<? super E, ? extends T> provider) {
        Key<CachedValue<T>> key;
        ParameterizedCachedValue value;
        if (context == null) {
            CachedValuesManager.$$$reportNull$$$0(10);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(11);
        }
        if ((value = (ParameterizedCachedValue)((Object)context.getUserData(key = CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider)))) != null) {
            return value.getValue(context);
        }
        CachedValuesManager manager = CachedValuesManager.getManager(context.getProject());
        return manager.getParameterizedCachedValue(context, key, new PsiDependentHandlerProvider(provider), false, context);
    }

    public static <T> T getCachedValue(@NotNull PsiElement context, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider) {
        ParameterizedCachedValue value;
        if (context == null) {
            CachedValuesManager.$$$reportNull$$$0(12);
        }
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            CachedValuesManager.$$$reportNull$$$0(14);
        }
        if ((value = (ParameterizedCachedValue)((Object)context.getUserData(key))) != null) {
            return value.getValue(context);
        }
        CachedValuesManager manager = CachedValuesManager.getManager(context.getProject());
        return manager.getParameterizedCachedValue(context, key, new NonPhysicalPsiHandlerProvider(provider), false, context);
    }

    @NotNull
    public <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            CachedValuesManager.$$$reportNull$$$0(15);
        }
        return CachedValuesManager.getKeyForClass(providerClass, this.keyForProvider);
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass, ConcurrentMap<String, Key<CachedValue<?>>> keyForProvider) {
        String name;
        Key key;
        if (providerClass == null) {
            CachedValuesManager.$$$reportNull$$$0(16);
        }
        if ((key = (Key)keyForProvider.get(name = providerClass.getName())) == null) {
            key = ConcurrencyUtil.cacheOrGet(keyForProvider, name, Key.create(name));
        }
        Key key2 = key;
        if (key2 == null) {
            CachedValuesManager.$$$reportNull$$$0(17);
        }
        return key2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/CachedValuesManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/CachedValuesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 2: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedCachedValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPsiDependentCache";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PsiDependentHandlerProvider<T>
    implements ParameterizedCachedValueProvider<T, PsiElement> {
        @NotNull
        private final Function<PsiElement, ? extends T> delegate;

        private PsiDependentHandlerProvider(@NotNull Function<PsiElement, ? extends T> delegate) {
            if (delegate == null) {
                PsiDependentHandlerProvider.$$$reportNull$$$0(0);
            }
            this.delegate = delegate;
        }

        @Override
        public CachedValueProvider.Result<T> compute(PsiElement context) {
            PsiFile file;
            T data = this.delegate.apply(context);
            if (!context.isPhysical() && (file = context.getContainingFile()) != null) {
                CachedValueProvider.Result<T> adjusted = CachedValueProvider.Result.create(data, file, PsiModificationTracker.MODIFICATION_COUNT);
                CachedValueProfiler.onResultCreated(adjusted, null);
                return adjusted;
            }
            return CachedValueProvider.Result.createSingleDependency(data, PsiModificationTracker.MODIFICATION_COUNT);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PsiDependentHandlerProvider provider = (PsiDependentHandlerProvider)o;
            return Objects.equals(this.delegate, provider.delegate);
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/util/CachedValuesManager$PsiDependentHandlerProvider", "<init>"));
        }
    }

    private static final class NonPhysicalPsiHandlerProvider<T>
    implements ParameterizedCachedValueProvider<T, PsiElement> {
        @NotNull
        private final CachedValueProvider<T> delegate;

        private NonPhysicalPsiHandlerProvider(@NotNull CachedValueProvider<T> delegate) {
            if (delegate == null) {
                NonPhysicalPsiHandlerProvider.$$$reportNull$$$0(0);
            }
            this.delegate = delegate;
        }

        @Override
        public CachedValueProvider.Result<T> compute(PsiElement context) {
            PsiFile file;
            CachedValueProvider.Result<T> result = this.delegate.compute();
            if (result != null && !context.isPhysical() && (file = context.getContainingFile()) != null) {
                CachedValueProvider.Result<T> adjusted = CachedValueProvider.Result.create(result.getValue(), ArrayUtil.append(result.getDependencyItems(), file, ArrayUtil.OBJECT_ARRAY_FACTORY));
                CachedValueProfiler.onResultCreated(adjusted, result);
                return adjusted;
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonPhysicalPsiHandlerProvider provider = (NonPhysicalPsiHandlerProvider)o;
            return Objects.equals(this.delegate, provider.delegate);
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/psi/util/CachedValuesManager$NonPhysicalPsiHandlerProvider", "<init>"));
        }
    }
}

