/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(0);
        }
        return new ProductionScopeFilter(project);
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(1);
        }
        return new TestScopeFilter(project);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(2);
        }
        return new DirectoryScope(directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(4);
        }
        return new DirectoryScope(project, directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        HashSet<VirtualFile> dirSet;
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(5);
        }
        if (directories == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(6);
        }
        if ((dirSet = ContainerUtil.newHashSet(directories)).isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScopesCore.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        if (dirSet.size() == 1) {
            return GlobalSearchScopesCore.directoryScope(project, (VirtualFile)dirSet.iterator().next(), withSubdirectories);
        }
        return new DirectoriesScope(project, withSubdirectories ? Collections.emptySet() : dirSet, withSubdirectories ? dirSet : Collections.emptySet());
    }

    @NotNull
    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(8);
        }
        if (set == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(9);
        }
        return new FilterScopeAdapter(project, set);
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getProjectProductionFilesScopeName() {
        String string = AnalysisBundle.message("psi.search.scope.production.files", new Object[0]);
        if (string == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public static String getProjectTestFilesScopeName() {
        String string = AnalysisBundle.message("psi.search.scope.test.files", new Object[0]);
        if (string == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "directoriesScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectProductionFilesScopeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectTestFilesScopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectProductionScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "projectTestScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "directoryScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "directoriesScope";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static final class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            if (project == null) {
                ProductionScopeFilter.$$$reportNull$$$0(0);
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ProductionScopeFilter.$$$reportNull$$$0(1);
            }
            return this.myFileIndex.isInSourceContent(file) && !TestSourcesFilter.isTestSources(file, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(3);
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public @Unmodifiable Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection<UnloadedModuleDescription> collection = ModuleManager.getInstance(Objects.requireNonNull(this.getProject())).getUnloadedModuleDescriptions();
            if (collection == null) {
                ProductionScopeFilter.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = GlobalSearchScopesCore.getProjectProductionFilesScopeName();
            if (string == null) {
                ProductionScopeFilter.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class TestScopeFilter
    extends GlobalSearchScope {
        private TestScopeFilter(@NotNull Project project) {
            if (project == null) {
                TestScopeFilter.$$$reportNull$$$0(0);
            }
            super(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                TestScopeFilter.$$$reportNull$$$0(1);
            }
            return TestSourcesFilter.isTestSources(file, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(3);
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = GlobalSearchScopesCore.getProjectTestFilesScopeName();
            if (string == null) {
                TestScopeFilter.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            if (psiDirectory == null) {
                DirectoryScope.$$$reportNull$$$0(0);
            }
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        public DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project == null) {
                DirectoryScope.$$$reportNull$$$0(1);
            }
            if (directory == null) {
                DirectoryScope.$$$reportNull$$$0(2);
            }
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @NotNull
        public VirtualFile getDirectory() {
            VirtualFile virtualFile = this.myDirectory;
            if (virtualFile == null) {
                DirectoryScope.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        public boolean isWithSubdirectories() {
            return this.myWithSubdirectories;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                DirectoryScope.$$$reportNull$$$0(4);
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, file, false) : this.myDirectory.equals(file) || this.myDirectory.equals(file.getParent());
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoryScope.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @NonNls
        public String toString() {
            return "directory scope: " + String.valueOf(this.myDirectory) + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof DirectoryScope)) return false;
            DirectoryScope directoryScope = (DirectoryScope)obj;
            if (!this.myDirectory.equals(directoryScope.myDirectory)) return false;
            if (this.myWithSubdirectories != directoryScope.myWithSubdirectories) return false;
            return true;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoryScope.$$$reportNull$$$0(6);
            }
            if (this.equals(scope)) {
                DirectoryScope directoryScope = this;
                if (directoryScope == null) {
                    DirectoryScope.$$$reportNull$$$0(7);
                }
                return directoryScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.containsScope(other)) {
                    DirectoryScope directoryScope = this;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(8);
                    }
                    return directoryScope;
                }
                if (other.containsScope(this)) {
                    DirectoryScope directoryScope = other;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(9);
                    }
                    return directoryScope;
                }
                return new DirectoriesScope(Objects.requireNonNull(this.getProject()), DirectoryScope.union(!this.myWithSubdirectories, this.myDirectory, !other.myWithSubdirectories, other.myDirectory), DirectoryScope.union(this.myWithSubdirectories, this.myDirectory, other.myWithSubdirectories, other.myDirectory));
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoryScope.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }

        private boolean containsScope(DirectoryScope other) {
            return this.myWithSubdirectories ? this.contains(other.myDirectory) : this.equals(other);
        }

        private static @Unmodifiable @NotNull Set<VirtualFile> union(boolean addDir1, @NotNull VirtualFile dir1, boolean addDir2, @NotNull VirtualFile dir2) {
            if (dir1 == null) {
                DirectoryScope.$$$reportNull$$$0(11);
            }
            if (dir2 == null) {
                DirectoryScope.$$$reportNull$$$0(12);
            }
            if (addDir1 && addDir2) {
                HashSet<VirtualFile> hashSet = ContainerUtil.newHashSet(dir1, dir2);
                if (hashSet == null) {
                    DirectoryScope.$$$reportNull$$$0(13);
                }
                return hashSet;
            }
            if (addDir1) {
                Set<VirtualFile> set = Collections.singleton(dir1);
                if (set == null) {
                    DirectoryScope.$$$reportNull$$$0(14);
                }
                return set;
            }
            if (addDir2) {
                Set<VirtualFile> set = Collections.singleton(dir2);
                if (set == null) {
                    DirectoryScope.$$$reportNull$$$0(15);
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                DirectoryScope.$$$reportNull$$$0(16);
            }
            return set;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = AnalysisBundle.message("display.name.directory.0", this.myDirectory.getName());
            if (string == null) {
                DirectoryScope.$$$reportNull$$$0(17);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 7, 8, 9, 10, 13, 14, 15, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir1";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectory";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "union";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "union";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 7, 8, 9, 10, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static final class DirectoriesScope
    extends GlobalSearchScope {
        private final Set<? extends VirtualFile> myDirectories;
        private final Set<? extends VirtualFile> myDirectoriesWithSubdirectories;

        private DirectoriesScope(@NotNull Project project, @NotNull Set<? extends VirtualFile> directories, @NotNull Set<? extends VirtualFile> directoriesWithSubdirectories) {
            if (project == null) {
                DirectoriesScope.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                DirectoriesScope.$$$reportNull$$$0(1);
            }
            if (directoriesWithSubdirectories == null) {
                DirectoriesScope.$$$reportNull$$$0(2);
            }
            super(project);
            this.myDirectories = directories;
            this.myDirectoriesWithSubdirectories = directoriesWithSubdirectories;
            if (directories.size() + directoriesWithSubdirectories.size() < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: directories " + String.valueOf(directories) + ", directories with subdirectories " + String.valueOf(directoriesWithSubdirectories));
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                DirectoriesScope.$$$reportNull$$$0(3);
            }
            return this.myDirectories.contains(file) || this.myDirectories.contains(file.getParent()) || VfsUtilCore.isUnder(file, this.myDirectoriesWithSubdirectories);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoriesScope.$$$reportNull$$$0(4);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @NonNls
        public String toString() {
            return "Directories scope: directories " + String.valueOf(this.myDirectories) + ", directories with subdirectories " + String.valueOf(this.myDirectoriesWithSubdirectories);
        }

        @Override
        public int calcHashCode() {
            int result = this.myDirectories.hashCode();
            result = result * 31 + this.myDirectoriesWithSubdirectories.hashCode();
            return result;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof DirectoriesScope)) return false;
            DirectoriesScope directoriesScope = (DirectoriesScope)obj;
            if (!this.myDirectories.equals(directoriesScope.myDirectories)) return false;
            if (!this.myDirectoriesWithSubdirectories.equals(directoriesScope.myDirectoriesWithSubdirectories)) return false;
            return true;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoriesScope.$$$reportNull$$$0(5);
            }
            if (this.equals(scope)) {
                DirectoriesScope directoriesScope = this;
                if (directoriesScope == null) {
                    DirectoriesScope.$$$reportNull$$$0(6);
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.myDirectories.contains(other.myDirectory) || VfsUtilCore.isUnder(other.myDirectory, this.myDirectoriesWithSubdirectories)) {
                    DirectoriesScope directoriesScope = this;
                    if (directoriesScope == null) {
                        DirectoriesScope.$$$reportNull$$$0(7);
                    }
                    return directoriesScope;
                }
                Set<? extends VirtualFile> directories = this.myDirectories;
                Set<? extends VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (other.myWithSubdirectories) {
                    HashSet<? extends VirtualFile> copy = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    copy.add(other.myDirectory);
                    directoriesWithSubdirectories = copy;
                } else {
                    HashSet<? extends VirtualFile> copy = new HashSet<VirtualFile>(directories);
                    copy.add(other.myDirectory);
                    directories = copy;
                }
                return new DirectoriesScope(Objects.requireNonNull(this.getProject()), directories, directoriesWithSubdirectories);
            }
            if (scope instanceof DirectoriesScope) {
                HashSet<? extends VirtualFile> copy;
                DirectoriesScope other = (DirectoriesScope)scope;
                Set<? extends VirtualFile> directories = this.myDirectories;
                Set<? extends VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (!other.myDirectories.isEmpty()) {
                    copy = new HashSet<VirtualFile>(directories);
                    copy.addAll(other.myDirectories);
                    directories = copy;
                }
                if (!other.myDirectoriesWithSubdirectories.isEmpty()) {
                    copy = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    copy.addAll(other.myDirectoriesWithSubdirectories);
                    directoriesWithSubdirectories = copy;
                }
                return new DirectoriesScope(Objects.requireNonNull(this.getProject()), directories, directoriesWithSubdirectories);
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoriesScope.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.size() + this.myDirectoriesWithSubdirectories.size() == 1) {
                Set<? extends VirtualFile> dirs = this.myDirectories.size() == 1 ? this.myDirectories : this.myDirectoriesWithSubdirectories;
                VirtualFile root = Objects.requireNonNull(ContainerUtil.getFirstItem(dirs));
                String string = AnalysisBundle.message("display.name.directory.0", root.getName());
                if (string == null) {
                    DirectoriesScope.$$$reportNull$$$0(9);
                }
                return string;
            }
            Iterable<? extends VirtualFile> allDirs = ContainerUtil.concat(this.myDirectories, this.myDirectoriesWithSubdirectories);
            String string = AnalysisBundle.message("display.name.directories.0", StringUtil.join(allDirs, file -> "'" + file.getName() + "'", ", "));
            if (string == null) {
                DirectoriesScope.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoriesWithSubdirectories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;
        @NotNull
        private final GlobalSearchScope myAllScope;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            if (project == null) {
                FilterScopeAdapter.$$$reportNull$$$0(0);
            }
            if (set == null) {
                FilterScopeAdapter.$$$reportNull$$$0(1);
            }
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
            this.myAllScope = GlobalSearchScope.allScope(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FilterScopeAdapter.$$$reportNull$$$0(2);
            }
            if (!this.myAllScope.contains(file)) {
                return false;
            }
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(Objects.requireNonNull(project));
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    PackageSetBase packageSetBase = (PackageSetBase)packageSet;
                    return packageSetBase.contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, (NamedScopesHolder)holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.mySet.getPresentableName();
            if (string == null) {
                FilterScopeAdapter.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.mySet.getIcon();
            if (icon == null) {
                FilterScopeAdapter.$$$reportNull$$$0(4);
            }
            return icon;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilterScopeAdapter.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterScopeAdapter adapter = (FilterScopeAdapter)o;
            if (!this.mySet.equals(adapter.mySet)) {
                return false;
            }
            return this.myManager.equals(adapter.myManager);
        }

        @Override
        public int calcHashCode() {
            int result = super.calcHashCode();
            result = 31 * result + this.mySet.hashCode();
            result = 31 * result + this.myManager.hashCode();
            return result;
        }

        @NonNls
        public String toString() {
            return "FilterScope adapted from " + String.valueOf(this.mySet);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

