/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class RangeMarkerWindow
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance(RangeMarkerWindow.class);
    private final DocumentWindow myDocumentWindow;
    private final RangeMarkerEx myHostMarker;
    private final int myStartShift;
    private final int myEndShift;

    public RangeMarkerWindow(@NotNull DocumentWindow documentWindow, int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (documentWindow == null) {
            RangeMarkerWindow.$$$reportNull$$$0(0);
        }
        this.myDocumentWindow = documentWindow;
        TextRange hostRange = documentWindow.injectedToHost(new ProperTextRange(startOffset, endOffset));
        this.myStartShift = startOffset - Math.max(0, documentWindow.hostToInjected(hostRange.getStartOffset()));
        this.myEndShift = endOffset - Math.max(0, documentWindow.hostToInjected(hostRange.getEndOffset()));
        RangeMarker hostMarker = this.createHostRangeMarkerToTrack(hostRange, surviveOnExternalChange);
        this.myHostMarker = (RangeMarkerEx)hostMarker;
        if (documentWindow.isValid() && !this.isValid()) {
            LOG.error(String.valueOf(this) + " is invalid immediately after creation");
        }
    }

    @ApiStatus.Internal
    @NotNull
    public RangeMarker createHostRangeMarkerToTrack(@NotNull TextRange hostRange, boolean surviveOnExternalChange) {
        if (hostRange == null) {
            RangeMarkerWindow.$$$reportNull$$$0(1);
        }
        RangeMarker rangeMarker = this.myDocumentWindow.getDelegate().createRangeMarker(hostRange.getStartOffset(), hostRange.getEndOffset(), surviveOnExternalChange);
        if (rangeMarker == null) {
            RangeMarkerWindow.$$$reportNull$$$0(2);
        }
        return rangeMarker;
    }

    @Override
    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocumentWindow;
        if (documentWindow == null) {
            RangeMarkerWindow.$$$reportNull$$$0(3);
        }
        return documentWindow;
    }

    @Override
    public int getStartOffset() {
        int hostOffset = this.myHostMarker.getStartOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) + this.myStartShift;
    }

    @Override
    public int getEndOffset() {
        int hostOffset = this.myHostMarker.getEndOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset) + this.myEndShift;
    }

    @Override
    public boolean isValid() {
        int endOffset;
        if (!this.myHostMarker.isValid() || !this.myDocumentWindow.isValid()) {
            return false;
        }
        int startOffset = this.getStartOffset();
        return startOffset <= (endOffset = this.getEndOffset()) && endOffset <= this.myDocumentWindow.getTextLength();
    }

    @Override
    public void setGreedyToLeft(boolean greedy) {
        this.myHostMarker.setGreedyToLeft(greedy);
    }

    @Override
    public void setGreedyToRight(boolean greedy) {
        this.myHostMarker.setGreedyToRight(greedy);
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            RangeMarkerWindow.$$$reportNull$$$0(4);
        }
        return this.myHostMarker.getUserData(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            RangeMarkerWindow.$$$reportNull$$$0(5);
        }
        this.myHostMarker.putUserData(key, value);
    }

    @Override
    public long getId() {
        return this.myHostMarker.getId();
    }

    @NotNull
    public RangeMarkerEx getDelegate() {
        RangeMarkerEx rangeMarkerEx = this.myHostMarker;
        if (rangeMarkerEx == null) {
            RangeMarkerWindow.$$$reportNull$$$0(6);
        }
        return rangeMarkerEx;
    }

    @Override
    public boolean isGreedyToRight() {
        return this.myHostMarker.isGreedyToRight();
    }

    @Override
    public boolean isGreedyToLeft() {
        return this.myHostMarker.isGreedyToLeft();
    }

    @Override
    public void dispose() {
        this.myHostMarker.dispose();
    }

    public String toString() {
        return "RangeMarkerWindow" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + String.valueOf(this.isValid() ? Long.valueOf(this.getId()) : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRange";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/RangeMarkerWindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/RangeMarkerWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHostRangeMarkerToTrack";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHostRangeMarkerToTrack";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

