/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiMarkdownCodeBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMarkdownCodeBlockImpl
extends CompositePsiElement
implements PsiMarkdownCodeBlock {
    public PsiMarkdownCodeBlockImpl() {
        super(JavaDocElementType.DOC_MARKDOWN_CODE_BLOCK);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiMarkdownCodeBlockImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMarkdownCodeBlock(this);
            return;
        }
        super.accept(visitor);
    }

    @Override
    public String toString() {
        return "PsiMarkdownCodeBlock:";
    }

    @Override
    @Nullable
    public Language getCodeLanguage() {
        String languageInfo = this.getLanguageInfo();
        if (languageInfo == null) {
            return this.getLanguage();
        }
        return LanguageUtil.findRegisteredLanguage(languageInfo);
    }

    @Override
    @NotNull
    public String getCodeText() {
        StringBuilder builder = new StringBuilder();
        ASTNode child = this.getFirstChildNode().getTreeNext();
        if (this.hasLanguageInfo() && child != null) {
            child = child.getTreeNext();
        }
        while (child != null) {
            IElementType i = child.getElementType();
            if (i != JavaDocTokenType.DOC_CODE_FENCE && i != JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS && i != JavaDocTokenType.DOC_INLINE_CODE_FENCE) {
                builder.append(child.getText());
            }
            child = child.getTreeNext();
        }
        String string = builder.toString();
        if (string == null) {
            PsiMarkdownCodeBlockImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isInline() {
        return this.getFirstChildNode().getElementType() == JavaDocTokenType.DOC_INLINE_CODE_FENCE;
    }

    @Nullable
    private String getLanguageInfo() {
        if (!this.hasLanguageInfo()) {
            return null;
        }
        return this.getChildren()[1].getText().trim();
    }

    private boolean hasLanguageInfo() {
        if (this.isInline()) {
            return false;
        }
        PsiElement[] children2 = this.getChildren();
        if (children2.length < 2) {
            return false;
        }
        if (this.findChildByType(TokenSet.WHITE_SPACE) == null) {
            return false;
        }
        PsiElement languageInfoChild = children2[1];
        if (languageInfoChild.getNode().getElementType() != JavaDocTokenType.DOC_COMMENT_DATA) {
            return false;
        }
        return !languageInfoChild.getText().trim().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiMarkdownCodeBlockImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiMarkdownCodeBlockImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

