/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.serializers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaClassElementType;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.factories.JavaClassStubFactory;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.JavaImplicitClassUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaClassStubSerializer
implements StubSerializer<PsiClassStub<PsiClass>> {
    @NotNull
    private final IJavaElementType myType;

    public JavaClassStubSerializer(@NotNull IJavaElementType elementType) {
        if (elementType == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(0);
        }
        this.myType = elementType;
    }

    @Override
    public void serialize(@NotNull PsiClassStub<PsiClass> stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(2);
        }
        dataStream.writeShort(((PsiClassStubImpl)stub).getFlags());
        if (!stub.isAnonymous()) {
            String name = stub.getName();
            TypeInfo info = ((PsiClassStubImpl)stub).getQualifiedNameTypeInfo();
            dataStream.writeName(info.getShortTypeText().equals(name) ? null : name);
            TypeInfo.writeTYPE(dataStream, info);
            dataStream.writeName(stub.getSourceFileName());
        } else {
            dataStream.writeName(stub.getBaseClassReferenceText());
        }
    }

    @Override
    @NotNull
    public PsiClassStub<PsiClass> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(3);
        }
        short flags = dataStream.readShort();
        boolean isAnonymous = PsiClassStubImpl.isAnonymous(flags);
        boolean isEnumConst = PsiClassStubImpl.isEnumConstInitializer(flags);
        boolean isImplicit = PsiClassStubImpl.isImplicit(flags);
        JavaClassElementType type = JavaClassStubFactory.typeForClass(isAnonymous, isEnumConst, isImplicit);
        if (!isAnonymous) {
            String name = dataStream.readNameString();
            TypeInfo typeInfo = TypeInfo.readTYPE(dataStream);
            if (name == null) {
                name = typeInfo.getShortTypeText();
            }
            String sourceFileName = dataStream.readNameString();
            PsiClassStubImpl<PsiClass> classStub = new PsiClassStubImpl<PsiClass>((IJavaElementType)type, parentStub, typeInfo, name, null, flags);
            classStub.setSourceFileName(sourceFileName);
            PsiClassStubImpl<PsiClass> psiClassStubImpl = classStub;
            if (psiClassStubImpl == null) {
                JavaClassStubSerializer.$$$reportNull$$$0(4);
            }
            return psiClassStubImpl;
        }
        String baseRef = dataStream.readNameString();
        return new PsiClassStubImpl<PsiClass>((IJavaElementType)type, parentStub, TypeInfo.SimpleTypeInfo.NULL, null, baseRef, flags);
    }

    @Override
    public void indexStub(@NotNull PsiClassStub<PsiClass> stub, @NotNull IndexSink sink) {
        if (stub == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(6);
        }
        if (stub.isImplicit()) {
            Stub parent = stub.getParentStub();
            if (parent instanceof PsiJavaFileStub) {
                sink.occurrence(JavaStubIndexKeys.IMPLICIT_CLASSES, JavaImplicitClassUtil.getJvmName(((PsiJavaFile)((PsiJavaFileStub)parent).getPsi()).getName()));
            }
            return;
        }
        boolean isAnonymous = stub.isAnonymous();
        if (isAnonymous) {
            String baseRef = stub.getBaseClassReferenceText();
            if (baseRef != null) {
                sink.occurrence(JavaStubIndexKeys.ANONYMOUS_BASEREF, PsiNameHelper.getShortClassName(baseRef));
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (!(shortName == null || stub instanceof PsiClassStubImpl && ((PsiClassStubImpl)stub).isAnonymousInner())) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_FQN, fqn);
            }
        }
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string = "java." + String.valueOf(this.myType);
        if (string == null) {
            JavaClassStubSerializer.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/serializers/JavaClassStubSerializer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/serializers/JavaClassStubSerializer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

