/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.SharedPsiElementImplUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class MultiplePsiFilesPerDocumentFileViewProvider
extends AbstractFileViewProvider {
    protected final ConcurrentMap<Language, PsiFileImpl> myRoots;
    private MultiplePsiFilesPerDocumentFileViewProvider myOriginal;

    public MultiplePsiFilesPerDocumentFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myRoots = new ConcurrentHashMap<Language, PsiFileImpl>(1, 0.75f, 1);
    }

    @Override
    @NotNull
    public abstract Language getBaseLanguage();

    @Override
    @NotNull
    public @NotNull List<@NotNull PsiFile> getAllFiles() {
        ArrayList<@NotNull PsiFile> roots = new ArrayList<PsiFile>();
        for (Language language : this.getLanguages()) {
            PsiFile psi = this.getPsi(language);
            if (psi == null) continue;
            roots.add(psi);
        }
        Language baseLanguage = this.getBaseLanguage();
        PsiFile base = this.getPsi(baseLanguage);
        if (!roots.isEmpty() && roots.get(0) != base && base != null) {
            roots.remove(base);
            roots.add(0, base);
        }
        ArrayList<PsiFile> arrayList = roots;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected final void removeFile(@NotNull Language language) {
        PsiFileImpl file;
        if (language == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(3);
        }
        if ((file = (PsiFileImpl)this.myRoots.remove(language)) != null) {
            file.markInvalidated();
        }
    }

    @Override
    protected PsiFile getPsiInner(@NotNull Language target) {
        PsiFileImpl file;
        if (target == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(4);
        }
        if ((file = (PsiFileImpl)this.myRoots.get(target)) == null) {
            PsiFile originalFile;
            if (!this.shouldCreatePsi()) {
                return null;
            }
            if (target != this.getBaseLanguage() && !this.getLanguages().contains(target)) {
                return null;
            }
            file = this.createPsiFileImpl(target);
            if (file == null) {
                return null;
            }
            if (file.getLanguage() != target) {
                throw PluginException.createByClass(new IllegalStateException("Inconsistent view provider implementation: " + this + " (" + this.getClass() + "). Its createPsiFileImpl('" + target + "') returned " + file + "(" + file.getClass() + ") with unexpected getLanguage()='" + file.getLanguage() + "'"), this.getClass());
            }
            if (this.myOriginal != null && (originalFile = this.myOriginal.getPsi(target)) != null) {
                file.setOriginalFile(originalFile);
            }
            file = ConcurrencyUtil.cacheOrGet(this.myRoots, target, file);
        }
        return file;
    }

    @Nullable
    protected PsiFileImpl createPsiFileImpl(@NotNull Language target) {
        if (target == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(5);
        }
        return (PsiFileImpl)this.createFile(target);
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target) {
        if (target == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(6);
        }
        return (PsiFile)this.myRoots.get(target);
    }

    @Override
    public final @Unmodifiable @NotNull List<PsiFile> getCachedPsiFiles() {
        List<PsiFile> list = ContainerUtil.mapNotNull(this.myRoots.keySet(), this::getCachedPsi);
        if (list == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<FileASTNode> getKnownTreeRoots() {
        ArrayList<FileASTNode> files = new ArrayList<FileASTNode>(this.myRoots.size());
        for (PsiFileImpl file : this.myRoots.values()) {
            FileASTNode treeElement = file.getNodeIfLoaded();
            if (treeElement == null) continue;
            files.add(treeElement);
        }
        ArrayList<FileASTNode> arrayList = files;
        if (arrayList == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @TestOnly
    public void checkAllTreesEqual() {
        Collection roots = this.myRoots.values();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.getManager().getProject());
        documentManager.commitAllDocuments();
        for (PsiFile root : roots) {
            Document document = documentManager.getDocument(root);
            assert (document != null);
            PsiDocumentManagerBase.checkConsistency(root, document);
            assert (root.getText().equals(document.getText()));
        }
    }

    @Override
    @NotNull
    public final MultiplePsiFilesPerDocumentFileViewProvider createCopy(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(9);
        }
        MultiplePsiFilesPerDocumentFileViewProvider copy = this.cloneInner(fileCopy);
        copy.myOriginal = this.myOriginal == null ? this : this.myOriginal;
        MultiplePsiFilesPerDocumentFileViewProvider multiplePsiFilesPerDocumentFileViewProvider = copy;
        if (multiplePsiFilesPerDocumentFileViewProvider == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(10);
        }
        return multiplePsiFilesPerDocumentFileViewProvider;
    }

    @NotNull
    protected abstract MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile var1);

    @Override
    @Nullable
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            MultiplePsiFilesPerDocumentFileViewProvider.$$$reportNull$$$0(11);
        }
        PsiFile mainRoot = this.getPsi(this.getBaseLanguage());
        PsiElement ret = null;
        for (Language language : this.getLanguages()) {
            PsiFile psiRoot;
            PsiElement psiElement;
            if (!ReflectionUtil.isAssignable(lang, language.getClass()) || lang.equals(Language.class) && !this.getLanguages().contains(language) || (psiElement = MultiplePsiFilesPerDocumentFileViewProvider.findElementAt(psiRoot = this.getPsi(language), offset)) == null || psiElement instanceof OuterLanguageElement || ret != null && psiRoot == mainRoot) continue;
            ret = psiElement;
        }
        return ret;
    }

    @Override
    @Nullable
    public PsiElement findElementAt(int offset) {
        return this.findElementAt(offset, Language.class);
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset) {
        TextRange minRange = new TextRange(0, this.getContents().length());
        PsiReference ret = null;
        for (Language language : this.getLanguages()) {
            TextRange textRange;
            PsiFile psiRoot = this.getPsi(language);
            PsiReference reference = SharedPsiElementImplUtil.findReferenceAt(psiRoot, offset, language);
            if (reference == null || !minRange.contains(textRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset())) || textRange.contains(minRange) && ret != null) continue;
            minRange = textRange;
            ret = reference;
        }
        return ret;
    }

    @Override
    public void contentsSynchronized() {
        Set<Language> languages = this.getLanguages();
        Iterator iterator2 = this.myRoots.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (languages.contains(entry.getKey())) continue;
            PsiFileImpl file = (PsiFileImpl)entry.getValue();
            iterator2.remove();
            DebugUtil.performPsiModification(this.getClass().getName() + " root change", () -> file.markInvalidated());
        }
        super.contentsSynchronized();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPsiFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTreeRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFileImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

