/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyKeyImpl;
import java.io.IOException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002BA\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/psi/FilePropertyStringKey;", "T", "Lcom/intellij/psi/FilePropertyKeyImpl;", "", "name", "persistentAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "fnToRaw", "Ljava/util/function/Function;", "fnFromRaw", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/newvfs/FileAttribute;Ljava/util/function/Function;Ljava/util/function/Function;)V", "fromRaw", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "toRaw", "(Ljava/lang/Object;)Ljava/lang/String;", "readValue", "stream", "Lcom/intellij/openapi/vfs/newvfs/AttributeInputStream;", "writeValue", "", "Lcom/intellij/openapi/vfs/newvfs/AttributeOutputStream;", "newValue", "intellij.platform.analysis.impl"})
public final class FilePropertyStringKey<T>
extends FilePropertyKeyImpl<T, String> {
    @NotNull
    private final Function<T, String> fnToRaw;
    @NotNull
    private final Function<String, T> fnFromRaw;

    public FilePropertyStringKey(@NotNull String name, @NotNull FileAttribute persistentAttribute, @NotNull Function<T, String> fnToRaw, @NotNull Function<String, T> fnFromRaw) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)persistentAttribute, (String)"persistentAttribute");
        Intrinsics.checkNotNullParameter(fnToRaw, (String)"fnToRaw");
        Intrinsics.checkNotNullParameter(fnFromRaw, (String)"fnFromRaw");
        super(name, persistentAttribute);
        this.fnToRaw = fnToRaw;
        this.fnFromRaw = fnFromRaw;
    }

    @Override
    @Nullable
    protected T fromRaw(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fnFromRaw.apply(value);
    }

    @Override
    @NotNull
    protected String toRaw(T value) {
        String string = this.fnToRaw.apply(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
        return string;
    }

    @Override
    @Nullable
    protected String readValue(@NotNull AttributeInputStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return stream.readEnumeratedString();
    }

    @Override
    protected void writeValue(@NotNull AttributeOutputStream stream, @Nullable String newValue) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeEnumeratedString(newValue);
    }
}

