/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.FilePropertyIntKey;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyStringKey;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 )*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001)B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000f\u001a\u0004\u0018\u00018\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00018\u00012\b\u0010\u001a\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0004\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00018\u0001H\u0004\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010 \u001a\u00020!H$\u00a2\u0006\u0002\u0010\"J\u001f\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020#2\b\u0010\u0016\u001a\u0004\u0018\u00018\u0001H$\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/intellij/psi/FilePropertyKeyImpl;", "T", "RAW", "Lcom/intellij/psi/FilePropertyKey;", "name", "", "persistentAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/newvfs/FileAttribute;)V", "userDataKey", "Lcom/intellij/openapi/util/Key;", "", "getUserDataKey", "()Lcom/intellij/openapi/util/Key;", "getPersistentValue", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Object;", "getRaw", "setPersistentValue", "", "newValue", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)Z", "keysEqual", "k1", "k2", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "readValue", "writeValue", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;)V", "stream", "Lcom/intellij/openapi/vfs/newvfs/AttributeInputStream;", "(Lcom/intellij/openapi/vfs/newvfs/AttributeInputStream;)Ljava/lang/Object;", "Lcom/intellij/openapi/vfs/newvfs/AttributeOutputStream;", "(Lcom/intellij/openapi/vfs/newvfs/AttributeOutputStream;Ljava/lang/Object;)V", "fromRaw", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "toRaw", "Companion", "intellij.platform.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nFilePropertyKeyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePropertyKeyImpl.kt\ncom/intellij/psi/FilePropertyKeyImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public abstract class FilePropertyKeyImpl<T, RAW>
implements FilePropertyKey<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileAttribute persistentAttribute;
    @NotNull
    private final Key<Object> userDataKey;
    @NotNull
    private static final Lazy<Object> NULL_MARKER$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, FilePropertyKeyImpl::NULL_MARKER_delegate$lambda$4);
    @NotNull
    private static final Logger LOG;

    protected FilePropertyKeyImpl(@NotNull String name, @NotNull FileAttribute persistentAttribute) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)persistentAttribute, (String)"persistentAttribute");
        this.persistentAttribute = persistentAttribute;
        Key key = Key.create(name);
        Intrinsics.checkNotNullExpressionValue(key, (String)"create(...)");
        this.userDataKey = key;
    }

    @VisibleForTesting
    @NotNull
    public final Key<Object> getUserDataKey() {
        return this.userDataKey;
    }

    @Override
    @Contract(value="null -> null")
    @Nullable
    public T getPersistentValue(@Nullable VirtualFile virtualFile) {
        T t;
        RAW raw;
        if (virtualFile == null) {
            return null;
        }
        RAW RAW = raw = this.getRaw(virtualFile);
        if (RAW != null) {
            RAW it = RAW;
            boolean bl = false;
            t = this.fromRaw(it);
        } else {
            t = null;
        }
        return t;
    }

    private final RAW getRaw(VirtualFile virtualFile) {
        Object memValue = virtualFile.getUserData(this.userDataKey);
        if (memValue != null) {
            return (RAW)(memValue == FilePropertyKeyImpl.Companion.getNULL_MARKER() ? null : memValue);
        }
        RAW persisted = this.readValue(virtualFile);
        Object object = persisted;
        if (object == null) {
            object = FilePropertyKeyImpl.Companion.getNULL_MARKER();
        }
        virtualFile.replace(this.userDataKey, null, object);
        return persisted;
    }

    @Override
    public boolean setPersistentValue(@Nullable VirtualFile virtualFile, @Nullable T newValue) {
        Object rawNewValue;
        if (virtualFile == null) {
            return false;
        }
        RAW oldValue = this.getRaw(virtualFile);
        T t = newValue;
        if (t != null) {
            T it = t;
            boolean bl = false;
            v1 = this.toRaw(it);
        } else {
            v1 = rawNewValue = null;
        }
        if (this.keysEqual(oldValue, rawNewValue)) {
            return false;
        }
        this.writeValue(virtualFile, rawNewValue);
        Object object = oldValue;
        if (object == null) {
            object = FilePropertyKeyImpl.Companion.getNULL_MARKER();
        }
        if (!virtualFile.replace(this.userDataKey, object, newValue == null ? FilePropertyKeyImpl.Companion.getNULL_MARKER() : rawNewValue)) {
            // empty if block
        }
        return true;
    }

    private final boolean keysEqual(RAW k1, RAW k2) {
        return Intrinsics.areEqual(k1, k2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final RAW readValue(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!(virtualFile instanceof VirtualFileWithId)) {
            LOG.debug("Only VirtualFileWithId can have persistent attributes: " + virtualFile);
            return null;
        }
        try {
            Closeable closeable = this.persistentAttribute.readFileAttribute(virtualFile);
            Throwable throwable = null;
            try {
                AttributeInputStream stream = (AttributeInputStream)closeable;
                boolean bl = false;
                if (stream != null && stream.available() > 0) {
                    RAW RAW = this.readValue(stream);
                    return RAW;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeValue(@NotNull VirtualFile virtualFile, @Nullable RAW newValue) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!(virtualFile instanceof VirtualFileWithId)) {
            LOG.debug("Only VirtualFileWithId can have persistent attributes: " + virtualFile);
            return;
        }
        try {
            Closeable closeable = this.persistentAttribute.writeFileAttribute(virtualFile);
            Throwable throwable = null;
            try {
                AttributeOutputStream stream = (AttributeOutputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)stream);
                this.writeValue(stream, newValue);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Nullable
    protected abstract RAW readValue(@NotNull AttributeInputStream var1) throws IOException;

    protected abstract void writeValue(@NotNull AttributeOutputStream var1, @Nullable RAW var2) throws IOException;

    @Nullable
    protected abstract T fromRaw(RAW var1);

    protected abstract RAW toRaw(T var1);

    private static final Object NULL_MARKER_delegate$lambda$4() {
        return Registry.Companion.is("cache.nulls.for.pushed.properties", true) ? new Object() : null;
    }

    private static final Object getNULL_MARKER() {
        return FilePropertyKeyImpl.Companion.getNULL_MARKER();
    }

    @JvmStatic
    @NotNull
    public static final FilePropertyKey<String> createPersistentStringKey(@NotNull String name, @NotNull FileAttribute persistentAttribute) {
        return Companion.createPersistentStringKey(name, persistentAttribute);
    }

    @JvmStatic
    @NotNull
    public static final <T> FilePropertyKey<T> createPersistentStringKey(@NotNull String name, @NotNull FileAttribute persistentAttribute, @NotNull Function<T, String> fnToRaw, @NotNull Function<String, T> fnFromRaw) {
        return Companion.createPersistentStringKey(name, persistentAttribute, fnToRaw, fnFromRaw);
    }

    @JvmStatic
    @NotNull
    public static final FilePropertyKey<Integer> createPersistentIntKey(@NotNull String userDataName, @NotNull String persistentDataName, int persistentDataVersion) {
        return Companion.createPersistentIntKey(userDataName, persistentDataName, persistentDataVersion);
    }

    @JvmStatic
    @NotNull
    public static final FilePropertyKey<Boolean> createPersistentBooleanKey(@NotNull String userDataName, @NotNull String persistentDataName, int persistentDataVersion) {
        return Companion.createPersistentBooleanKey(userDataName, persistentDataName, persistentDataVersion);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Enum<T>> FilePropertyKey<T> createPersistentEnumKey(@NotNull String userDataName, @NotNull String persistentDataName, int persistentDataVersion, @NotNull Class<T> clazz) {
        return Companion.createPersistentEnumKey(userDataName, persistentDataName, persistentDataVersion, clazz);
    }

    static {
        Logger logger = Logger.getInstance(FilePropertyKeyImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007JN\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0010\"\u0004\b\u0002\u0010\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00110\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u0001H\u00150\u0017H\u0007J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001aH\u0007J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00102\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001aH\u0007JD\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00150\u0010\"\u000e\b\u0002\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150!2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00150#H\u0007R#\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u00a8\u0006$"}, d2={"Lcom/intellij/psi/FilePropertyKeyImpl$Companion;", "", "<init>", "()V", "NULL_MARKER", "Ljava/lang/Object;", "getNULL_MARKER$annotations", "getNULL_MARKER", "()Ljava/lang/Object;", "NULL_MARKER$delegate", "Lkotlin/Lazy;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$annotations", "createPersistentStringKey", "Lcom/intellij/psi/FilePropertyKey;", "", "name", "persistentAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "T", "fnToRaw", "Ljava/util/function/Function;", "fnFromRaw", "createPersistentIntKey", "", "userDataName", "persistentDataName", "persistentDataVersion", "createPersistentBooleanKey", "", "createPersistentEnumKey", "", "clazz", "Ljava/lang/Class;", "intellij.platform.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Object getNULL_MARKER() {
            Lazy lazy = NULL_MARKER$delegate;
            return lazy.getValue();
        }

        @JvmStatic
        private static /* synthetic */ void getNULL_MARKER$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOG$annotations() {
        }

        @JvmStatic
        @NotNull
        public final FilePropertyKey<String> createPersistentStringKey(@NotNull String name, @NotNull FileAttribute persistentAttribute) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)persistentAttribute, (String)"persistentAttribute");
            return this.createPersistentStringKey(name, persistentAttribute, String::toString, String::toString);
        }

        @JvmStatic
        @NotNull
        public final <T> FilePropertyKey<T> createPersistentStringKey(@NotNull String name, @NotNull FileAttribute persistentAttribute, @NotNull Function<T, String> fnToRaw, @NotNull Function<String, T> fnFromRaw) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)persistentAttribute, (String)"persistentAttribute");
            Intrinsics.checkNotNullParameter(fnToRaw, (String)"fnToRaw");
            Intrinsics.checkNotNullParameter(fnFromRaw, (String)"fnFromRaw");
            return new FilePropertyStringKey<T>(name, persistentAttribute, fnToRaw, fnFromRaw);
        }

        @JvmStatic
        @NotNull
        public final FilePropertyKey<Integer> createPersistentIntKey(@NotNull String userDataName, @NotNull String persistentDataName, int persistentDataVersion) {
            Intrinsics.checkNotNullParameter((Object)userDataName, (String)"userDataName");
            Intrinsics.checkNotNullParameter((Object)persistentDataName, (String)"persistentDataName");
            return new FilePropertyIntKey<Integer>(userDataName, new FileAttribute(persistentDataName, persistentDataVersion, true), Companion::createPersistentIntKey$lambda$0, Companion::createPersistentIntKey$lambda$1);
        }

        @JvmStatic
        @NotNull
        public final FilePropertyKey<Boolean> createPersistentBooleanKey(@NotNull String userDataName, @NotNull String persistentDataName, int persistentDataVersion) {
            Intrinsics.checkNotNullParameter((Object)userDataName, (String)"userDataName");
            Intrinsics.checkNotNullParameter((Object)persistentDataName, (String)"persistentDataName");
            return new FilePropertyIntKey<Boolean>(userDataName, new FileAttribute(persistentDataName, persistentDataVersion, true), Companion::createPersistentBooleanKey$lambda$2, Companion::createPersistentBooleanKey$lambda$3);
        }

        @JvmStatic
        @NotNull
        public final <T extends Enum<T>> FilePropertyKey<T> createPersistentEnumKey(@NotNull String userDataName, @NotNull String persistentDataName, int persistentDataVersion, @NotNull Class<T> clazz) {
            Intrinsics.checkNotNullParameter((Object)userDataName, (String)"userDataName");
            Intrinsics.checkNotNullParameter((Object)persistentDataName, (String)"persistentDataName");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return new FilePropertyIntKey<Enum>(userDataName, new FileAttribute(persistentDataName, persistentDataVersion, true), Companion::createPersistentEnumKey$lambda$4, arg_0 -> Companion.createPersistentEnumKey$lambda$5(clazz, arg_0));
        }

        private static final int createPersistentIntKey$lambda$0(Integer t) {
            Intrinsics.checkNotNull((Object)t);
            return t;
        }

        private static final Integer createPersistentIntKey$lambda$1(int t) {
            return t;
        }

        private static final int createPersistentBooleanKey$lambda$2(Boolean t) {
            return t != false ? 1 : 0;
        }

        private static final Boolean createPersistentBooleanKey$lambda$3(int t) {
            return t != 0;
        }

        private static final <T extends Enum<T>> T createPersistentEnumKey$fromRaw(Class<T> $clazz, int value) {
            if (value >= 0 && value < $clazz.getEnumConstants().length) {
                return (T)((Enum[])$clazz.getEnumConstants())[value];
            }
            return null;
        }

        private static final <T extends Enum<T>> int createPersistentEnumKey$toRaw(T value) {
            return value.ordinal();
        }

        private static final int createPersistentEnumKey$lambda$4(Enum t) {
            Intrinsics.checkNotNull((Object)t);
            return com.intellij.psi.FilePropertyKeyImpl$Companion.createPersistentEnumKey$toRaw(t);
        }

        private static final Enum createPersistentEnumKey$lambda$5(Class $clazz, int t) {
            return com.intellij.psi.FilePropertyKeyImpl$Companion.createPersistentEnumKey$fromRaw($clazz, t);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

