/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.ProjectInspectionToolRegistrar;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeManagerIprProvider;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectBasedInspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManagerKt;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManagerState;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="InspectionProjectProfileManager", storages={@Storage(value="inspectionProfiles/profiles_settings.xml", exclusive=true)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 12\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u0005:\u00011B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0007J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0012H\u0014J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"H\u0016J\u0012\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010$H\u0016J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010(\u001a\u00020$J\u0012\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010,\u001a\u00020\u0012H\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00062"}, d2={"Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "Lcom/intellij/profile/codeInspection/BaseInspectionProfileManager;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lorg/jdom/Element;", "Lcom/intellij/profile/codeInspection/ProjectBasedInspectionProfileManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManagerState;", "schemeManagerIprProvider", "Lcom/intellij/configurationStore/SchemeManagerIprProvider;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "initializeComponent", "", "dispose", "getStateModificationCount", "", "forceLoadSchemes", "schemeRemoved", "scheme", "getState", "loadState", "getScopesManager", "Lcom/intellij/packageDependencies/DependencyValidationManager;", "getProfiles", "", "projectProfile", "", "getProjectProfile", "()Ljava/lang/String;", "setRootProfile", "name", "useApplicationProfile", "setCurrentProfile", "profile", "getCurrentProfile", "getProfile", "returnRootProfileIfNamedIsAbsent", "", "fireProfileChanged", "Companion", "intellij.platform.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nProjectInspectionProfileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectInspectionProfileManager.kt\ncom/intellij/profile/codeInspection/ProjectInspectionProfileManager\n+ 2 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,276:1\n9#2,4:277\n1#3:281\n53#4:282\n*S KotlinDebug\n*F\n+ 1 ProjectInspectionProfileManager.kt\ncom/intellij/profile/codeInspection/ProjectInspectionProfileManager\n*L\n97#1:277,4\n119#1:282\n*E\n"})
public class ProjectInspectionProfileManager
extends BaseInspectionProfileManager
implements PersistentStateComponentWithModificationTracker<Element>,
ProjectBasedInspectionProfileManager,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private ProjectInspectionProfileManagerState state;
    @Nullable
    private final SchemeManagerIprProvider schemeManagerIprProvider;
    @NotNull
    private final SchemeManager<InspectionProfileImpl> schemeManager;

    public ProjectInspectionProfileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBus messageBus = project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        super(messageBus);
        this.project = project;
        this.state = new ProjectInspectionProfileManagerState();
        this.schemeManagerIprProvider = ProjectKt.isDirectoryBased((Project)this.project) ? null : new SchemeManagerIprProvider("profile", null, 2, null);
        this.schemeManager = SchemeManagerFactory.create$default((SchemeManagerFactory)SchemeManagerFactory.Companion.getInstance(this.project), (String)"inspectionProfiles", (SchemeProcessor)((SchemeProcessor)new InspectionProfileProcessor(this){
            final /* synthetic */ ProjectInspectionProfileManager this$0;
            {
                this.this$0 = $receiver;
            }

            public InspectionProfileImpl createScheme(SchemeDataHolder<? super InspectionProfileImpl> dataHolder, String name, Function1<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(attributeProvider, (String)"attributeProvider");
                InspectionProfileImpl profile = new InspectionProfileImpl(name, ProjectInspectionToolRegistrar.Companion.getInstance(this.this$0.getProject()), this.this$0, dataHolder);
                profile.setProjectLevel(true);
                return profile;
            }

            public boolean isSchemeFile(CharSequence name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return !Intrinsics.areEqual((Object)name, (Object)"profiles_settings.xml");
            }

            public boolean isSchemeDefault(InspectionProfileImpl scheme, long digest) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                return Intrinsics.areEqual((Object)scheme.getName(), (Object)"Project Default") && digest == ProjectInspectionProfileManagerKt.access$getDefaultSchemeDigest$p();
            }

            public void onSchemeDeleted(InspectionProfileImpl scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                this.this$0.schemeRemoved(scheme);
            }

            public void onSchemeAdded(InspectionProfileImpl scheme) {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                if (scheme.wasInitialized()) {
                    this.this$0.fireProfileChanged(scheme);
                }
            }

            public void onCurrentSchemeSwitched(InspectionProfileImpl oldScheme, InspectionProfileImpl newScheme, boolean processChangeSynchronously) {
                MessageBus messageBus = this.this$0.getProject().getMessageBus();
                Topic<ProfileChangeAdapter> topic = ProfileChangeAdapter.TOPIC;
                Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                messageBus.syncPublisher(topic).profileActivated(oldScheme, newScheme);
            }
        }), null, null, (Function1)Scheme_implKt.getOLD_NAME_CONVERTER(), (StreamProvider)((StreamProvider)this.schemeManagerIprProvider), null, (boolean)false, null, (int)460, null);
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        return this.schemeManager;
    }

    @Override
    public void initializeComponent() {
        Application app = ApplicationManager.getApplication();
        if (!ProjectKt.isDirectoryBased((Project)this.project) || app.isUnitTestMode()) {
            return;
        }
        String name$iv = "project inspection profile loading";
        boolean $i$f$runActivity = false;
        Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity(name$iv) : null;
        boolean bl = false;
        this.getSchemeManager().loadSchemes();
        this.getCurrentProfile().initInspectionTools(this.project);
        Unit result$iv = Unit.INSTANCE;
        Activity activity = activity$iv;
        if (activity != null) {
            activity.end();
        }
        StartupManager.getInstance(this.project).runAfterOpened(() -> ProjectInspectionProfileManager.initializeComponent$lambda$2(this));
    }

    @Override
    public void dispose() {
        Function0 cleanupInspectionProfilesRunnable = () -> ProjectInspectionProfileManager.dispose$lambda$3(this);
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            v0 = cleanupInspectionProfilesRunnable.invoke();
        } else {
            Intrinsics.checkNotNull((Object)app, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            v0 = BuildersKt.launch$default(((ComponentManagerEx)((Object)app)).getCoroutineScope(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)cleanupInspectionProfilesRunnable, null){
                int label;
                final /* synthetic */ Function0<Unit> $cleanupInspectionProfilesRunnable;
                {
                    this.$cleanupInspectionProfilesRunnable = $cleanupInspectionProfilesRunnable;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$cleanupInspectionProfilesRunnable.invoke();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    @Override
    public long getStateModificationCount() {
        SchemeManagerIprProvider schemeManagerIprProvider = this.schemeManagerIprProvider;
        return this.state.getModificationCount() + this.getSeverityRegistrar().getModificationCount() + (schemeManagerIprProvider != null ? schemeManagerIprProvider.getModificationCount() : 0L);
    }

    @TestOnly
    public final void forceLoadSchemes() {
        ProjectInspectionProfileManagerKt.access$getLOG$p().assertTrue(ApplicationManager.getApplication().isUnitTestMode());
        this.getSchemeManager().loadSchemes();
    }

    @Override
    protected void schemeRemoved(@NotNull InspectionProfileImpl scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        scheme.cleanup(this.project);
    }

    @Override
    @Nullable
    public synchronized Element getState() {
        Element result = new Element("settings");
        SchemeManagerIprProvider schemeManagerIprProvider = this.schemeManagerIprProvider;
        if (schemeManagerIprProvider != null) {
            schemeManagerIprProvider.writeState(result);
        }
        XmlSerializer.serializeObjectInto$default(this.state, result, null, 4, null);
        List<Element> list = result.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
        if (!((Collection)list).isEmpty()) {
            result.addContent(new Element("version").setAttribute("value", "1.0"));
        }
        this.getSeverityRegistrar().writeExternal(result);
        return Scheme_implKt.wrapState((Element)result, (Project)this.project);
    }

    @Override
    public synchronized void loadState(@NotNull Element state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Element data = Scheme_implKt.unwrapState((Element)state2, (Project)this.project, (SchemeManagerIprProvider)this.schemeManagerIprProvider, this.getSchemeManager());
        ProjectInspectionProfileManagerState newState = new ProjectInspectionProfileManagerState();
        Element element = data;
        if (element != null) {
            Element it = element;
            boolean bl = false;
            try {
                this.getSeverityRegistrar().readExternal(it);
            }
            catch (Throwable e) {
                ProjectInspectionProfileManagerKt.access$getLOG$p().error(e);
            }
            XmlSerializer.deserializeInto(it, newState);
        }
        this.state = newState;
        if (data != null) {
            Element element2 = data.getChild("version");
            if (!Intrinsics.areEqual((Object)(element2 != null ? element2.getAttributeValue("value") : null), (Object)"1.0")) {
                for (Element o : data.getChildren("option")) {
                    if (!Intrinsics.areEqual((Object)o.getAttributeValue("name"), (Object)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                    if (!o.getAttributeBooleanValue("value") || newState.getProjectProfile() == null) break;
                    this.getCurrentProfile().convert(data, this.project);
                    break;
                }
            }
        }
    }

    @Override
    @NotNull
    public DependencyValidationManager getScopesManager() {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyValidationManager, (String)"getInstance(...)");
        return dependencyValidationManager;
    }

    @Override
    @NotNull
    public synchronized Collection<InspectionProfileImpl> getProfiles() {
        this.getCurrentProfile();
        return this.getSchemeManager().getAllSchemes();
    }

    @Nullable
    public final String getProjectProfile() {
        return this.state.getProjectProfile();
    }

    @Override
    public synchronized void setRootProfile(@Nullable String name) {
        this.state.setUseProjectProfile(name != null);
        if (name != null) {
            this.state.setProjectProfile(name);
        }
        this.getSchemeManager().setCurrentSchemeName(name, true);
    }

    public final synchronized void useApplicationProfile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.state.setUseProjectProfile(false);
        this.state.setProjectProfile(name);
    }

    @TestOnly
    public final synchronized void setCurrentProfile(@Nullable InspectionProfileImpl profile) {
        SchemeManager.setCurrent$default(this.getSchemeManager(), (Object)profile, (boolean)false, (boolean)false, (int)6, null);
        this.state.setUseProjectProfile(profile != null);
        if (profile != null) {
            this.state.setProjectProfile(profile.getName());
        }
    }

    @Override
    @NotNull
    public synchronized InspectionProfileImpl getCurrentProfile() {
        InspectionProfileImpl currentScheme;
        block7: {
            Object object;
            block9: {
                InspectionProfileManager applicationProfileManager;
                block8: {
                    if (this.state.getUseProjectProfile()) break block7;
                    InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileManager, (String)"getInstance(...)");
                    applicationProfileManager = inspectionProfileManager;
                    object = this.state.getProjectProfile();
                    if (object == null) break block8;
                    String it = object;
                    boolean bl = false;
                    InspectionProfileImpl inspectionProfileImpl = applicationProfileManager.getProfile(it, false);
                    object = inspectionProfileImpl;
                    if (inspectionProfileImpl != null) break block9;
                }
                InspectionProfileImpl inspectionProfileImpl = applicationProfileManager.getCurrentProfile();
                object = inspectionProfileImpl;
                Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
            }
            return object;
        }
        String string = this.state.getProjectProfile();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v5 = (InspectionProfileImpl)this.getSchemeManager().findSchemeByName(it);
        } else {
            v5 = currentScheme = null;
        }
        if (currentScheme == null) {
            currentScheme = (InspectionProfileImpl)CollectionsKt.firstOrNull((List)this.getSchemeManager().getAllSchemes());
            if (currentScheme == null) {
                currentScheme = new InspectionProfileImpl("Project Default", (InspectionToolsSupplier)ProjectInspectionToolRegistrar.Companion.getInstance(this.project), this);
                currentScheme.copyFrom(InspectionProfileManager.getInstance().getCurrentProfile());
                currentScheme.setProjectLevel(true);
                currentScheme.setName("Project Default");
                this.getSchemeManager().addScheme((Object)currentScheme);
            }
            SchemeManager.setCurrent$default(this.getSchemeManager(), (Object)currentScheme, (boolean)false, (boolean)false, (int)4, null);
        }
        return currentScheme;
    }

    @Override
    @Nullable
    public synchronized InspectionProfileImpl getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InspectionProfileImpl inspectionProfileImpl = (InspectionProfileImpl)this.getSchemeManager().findSchemeByName(name);
        if (inspectionProfileImpl == null) {
            inspectionProfileImpl = InspectionProfileManager.getInstance().getProfile(name, returnRootProfileIfNamedIsAbsent);
        }
        return inspectionProfileImpl;
    }

    public final void fireProfileChanged() {
        this.fireProfileChanged(this.getCurrentProfile());
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        profile.profileChanged();
        MessageBus messageBus = this.project.getMessageBus();
        Topic<ProfileChangeAdapter> topic = ProfileChangeAdapter.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBus.syncPublisher(topic).profileChanged(profile);
    }

    private static final void initializeComponent$lambda$2$lambda$1(ProjectInspectionProfileManager this$0) {
        for (InspectionProfileImpl profile : this$0.getSchemeManager().getAllSchemes()) {
            profile.scopesChanged();
        }
    }

    private static final void initializeComponent$lambda$2(ProjectInspectionProfileManager this$0) {
        MessageBus messageBus = this$0.project.getMessageBus();
        Topic<ProfileChangeAdapter> topic = ProfileChangeAdapter.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBus.syncPublisher(topic).profilesInitialized();
        NamedScopesHolder.ScopeListener projectScopeListener = () -> ProjectInspectionProfileManager.initializeComponent$lambda$2$lambda$1(this$0);
        this$0.getScopesManager().addScopeListener(projectScopeListener, this$0.project);
        NamedScopeManager.getInstance(this$0.project).addScopeListener(projectScopeListener, this$0.project);
    }

    private static final Unit dispose$lambda$3(ProjectInspectionProfileManager this$0) {
        Unit unit;
        this$0.cleanupSchemes$intellij_platform_analysis_impl(this$0.project);
        boolean $i$f$serviceIfCreated = false;
        Application application = ApplicationManager.getApplication();
        BaseInspectionProfileManager baseInspectionProfileManager = (BaseInspectionProfileManager)(application != null ? application.getServiceIfCreated(InspectionProfileManager.class) : null);
        if (baseInspectionProfileManager != null) {
            baseInspectionProfileManager.cleanupSchemes$intellij_platform_analysis_impl(this$0.project);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @JvmStatic
    @NotNull
    public static final ProjectInspectionProfileManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/profile/codeInspection/ProjectInspectionProfileManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectInspectionProfileManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance(project);
            Intrinsics.checkNotNull((Object)inspectionProjectProfileManager, (String)"null cannot be cast to non-null type com.intellij.profile.codeInspection.ProjectInspectionProfileManager");
            return (ProjectInspectionProfileManager)inspectionProjectProfileManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

