/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.url;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.storage.impl.IntIdGenerator;
import com.intellij.platform.workspace.storage.impl.VirtualFileNameStore;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImpl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.TreeNodeProcessingResult;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0017\u0018\u0000 I2\u00020\u0001:\u0002HIB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001b\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001d\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001eJ\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\u001d\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b J\"\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\t2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020%0$J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(J\u001d\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b,J\u0018\u00101\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\u0000H\u0014J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t0\u0018J%\u00104\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00142\u000e\b\u0002\u00105\u001a\b\u0018\u00010\u000eR\u00020\u0000H\u0000\u00a2\u0006\u0002\b6J$\u00107\u001a\u00020\t2\f\u00105\u001a\b\u0018\u00010\u000eR\u00020\u00002\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u0018\u00109\u001a\u0004\u0018\u00010\t2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0002J\u0015\u0010:\u001a\u00020;2\u0006\u0010\u001b\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b<J\u001d\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b@J\u0010\u0010A\u001a\u00020;2\u0006\u0010B\u001a\u00020(H\u0002J\u0016\u0010C\u001a\b\u0018\u00010\u000eR\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0016\u0010D\u001a\b\u0018\u00010\u000eR\u00020\u00002\u0006\u0010E\u001a\u00020\u0014H\u0002J\u0016\u0010D\u001a\b\u0018\u00010\u000eR\u00020\u00002\u0006\u0010B\u001a\u00020(H\u0002J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0006\u0010G\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006J"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "isRootDirCaseSensitive", "", "<init>", "(Z)V", "idGenerator", "Lcom/intellij/platform/workspace/storage/impl/IntIdGenerator;", "emptyUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "fileNameStore", "Lcom/intellij/platform/workspace/storage/impl/VirtualFileNameStore;", "id2NodeMapping", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "rootNode", "rwLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getOrCreateFromUrl", "uri", "", "findByUrl", "fromUrlSegments", "uriSegments", "", "fromUrlSegments$intellij_platform_workspace_storage", "fromPath", "path", "getParentVirtualUrl", "vfu", "getParentVirtualUrl$intellij_platform_workspace_storage", "getSubtreeVirtualUrlsById", "getSubtreeVirtualUrlsById$intellij_platform_workspace_storage", "processChildrenRecursively", "url", "processor", "Lkotlin/Function1;", "Lcom/intellij/util/containers/TreeNodeProcessingResult;", "getUrlById", "id", "", "append", "parentVfu", "relativePath", "append$intellij_platform_workspace_storage", "virtualFileUrlImplementationClass", "Ljava/lang/Class;", "getVirtualFileUrlImplementationClass", "()Ljava/lang/Class;", "createVirtualFileUrl", "manager", "getCachedVirtualFileUrls", "add", "parentNode", "add$intellij_platform_workspace_storage", "addSegments", "segments", "findBySegments", "remove", "", "remove$intellij_platform_workspace_storage", "update", "oldPath", "newPath", "update$intellij_platform_workspace_storage", "removeNameUsage", "contentId", "findLatestFilePathNode", "findRootNode", "segment", "splitNames", "print", "FilePathNode", "Companion", "intellij.platform.workspace.storage"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVirtualFileUrlManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,363:1\n1#2:364\n1#2:379\n1563#3:365\n1634#3,3:366\n1617#3,9:369\n1869#3:378\n1870#3:380\n1626#3:381\n*S KotlinDebug\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl\n*L\n118#1:379\n59#1:365\n59#1:366,3\n118#1:369,9\n118#1:378\n118#1:380\n118#1:381\n*E\n"})
public class VirtualFileUrlManagerImpl
implements VirtualFileUrlManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IntIdGenerator idGenerator;
    @NotNull
    private final VirtualFileUrl emptyUrl;
    @NotNull
    private final VirtualFileNameStore fileNameStore;
    @NotNull
    private final Int2ObjectOpenHashMap<FilePathNode> id2NodeMapping;
    @NotNull
    private final FilePathNode rootNode;
    @NotNull
    private final ReentrantReadWriteLock rwLock;
    @NotNull
    private static final Hash.Strategy<FilePathNode> HASHING_STRATEGY = new Hash.Strategy<FilePathNode>(){

        public boolean equals(FilePathNode node1, FilePathNode node2) {
            if (node1 == node2) {
                return true;
            }
            if (node1 == null || node2 == null) {
                return false;
            }
            return node1.getContentId() == node2.getContentId();
        }

        public int hashCode(FilePathNode node) {
            FilePathNode filePathNode = node;
            return filePathNode != null ? filePathNode.getContentId() : 0;
        }
    };

    public VirtualFileUrlManagerImpl(boolean isRootDirCaseSensitive) {
        this.idGenerator = new IntIdGenerator();
        this.fileNameStore = new VirtualFileNameStore(isRootDirCaseSensitive);
        this.id2NodeMapping = new Int2ObjectOpenHashMap();
        this.rootNode = new FilePathNode(this, 0, 0, null, 4, null);
        this.rwLock = new ReentrantReadWriteLock();
        this.emptyUrl = this.createVirtualFileUrl(0, this);
    }

    public /* synthetic */ VirtualFileUrlManagerImpl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    @NotNull
    public VirtualFileUrl getOrCreateFromUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (((CharSequence)uri).length() == 0) {
            return this.emptyUrl;
        }
        return VirtualFileUrlManagerImpl.add$intellij_platform_workspace_storage$default(this, uri, null, 2, null);
    }

    @Override
    @Nullable
    public VirtualFileUrl findByUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.findBySegments(this.splitNames(uri));
    }

    @NotNull
    public final VirtualFileUrl fromUrlSegments$intellij_platform_workspace_storage(@NotNull List<String> uriSegments) {
        Intrinsics.checkNotNullParameter(uriSegments, (String)"uriSegments");
        if (uriSegments.isEmpty()) {
            return this.emptyUrl;
        }
        return this.addSegments(null, uriSegments);
    }

    @Override
    @NotNull
    public VirtualFileUrl fromPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String url = "file://" + FileUtil.toSystemIndependentName(path);
        return this.getOrCreateFromUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VirtualFileUrl getParentVirtualUrl$intellij_platform_workspace_storage(@NotNull VirtualFileUrl vfu) {
        VirtualFileUrl virtualFileUrl;
        Intrinsics.checkNotNullParameter((Object)vfu, (String)"vfu");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)vfu;
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            FilePathNode filePathNode = this.id2NodeMapping.get(((VirtualFileUrlImpl)vfu).getId());
            virtualFileUrl = filePathNode != null && (filePathNode = filePathNode.getParent()) != null ? filePathNode.getVirtualFileUrl(this) : null;
        }
        finally {
            readLock.unlock();
        }
        return virtualFileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFileUrl> getSubtreeVirtualUrlsById$intellij_platform_workspace_storage(@NotNull VirtualFileUrl vfu) {
        List list;
        Intrinsics.checkNotNullParameter((Object)vfu, (String)"vfu");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)vfu;
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.id2NodeMapping.get(((VirtualFileUrlImpl)vfu).getId()).getSubtreeNodes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FilePathNode filePathNode = (FilePathNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getVirtualFileUrl(this));
            }
            list = (List)destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processChildrenRecursively(@NotNull VirtualFileUrl url, @NotNull Function1<? super VirtualFileUrl, ? extends TreeNodeProcessingResult> processor) {
        FilePathNode filePathNode;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        VirtualFileUrlManagerImpl virtualFileUrlManagerImpl = this;
        synchronized (virtualFileUrlManagerImpl) {
            boolean bl = false;
            filePathNode = this.id2NodeMapping.get(((VirtualFileUrlImpl)url).getId());
        }
        FilePathNode node = filePathNode;
        return node.processChildrenRecursively((Function1<? super FilePathNode, ? extends TreeNodeProcessingResult>)((Function1)arg_0 -> VirtualFileUrlManagerImpl.processChildrenRecursively$lambda$5(this, processor, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getUrlById(int id) {
        if (id <= 0) {
            return "";
        }
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            IntArrayList contentIds;
            block12: {
                String string;
                block14: {
                    block13: {
                        CharSequence charSequence;
                        boolean bl = false;
                        contentIds = new IntArrayList();
                        for (FilePathNode node = this.id2NodeMapping.get(id); node != null; node = node.getParent()) {
                            contentIds.add(node.getContentId());
                        }
                        if (contentIds.size() != 1) break block12;
                        string = this.fileNameStore.getNameForId(contentIds.getInt(0));
                        if (string == null) break block13;
                        String it = string;
                        boolean bl2 = false;
                        CharSequence charSequence2 = it;
                        if (charSequence2.length() == 0) {
                            boolean bl3 = false;
                            charSequence = "/";
                        } else {
                            charSequence = charSequence2;
                        }
                        String string2 = (String)charSequence;
                        string = string2;
                        if (string2 != null) break block14;
                    }
                    string = "";
                }
                String string3 = string;
                return string3;
            }
            StringBuilder builder = new StringBuilder();
            for (int index = contentIds.size() - 1; -1 < index; --index) {
                builder.append(this.fileNameStore.getNameForId(contentIds.getInt(index)));
                if (index == 0) continue;
                builder.append("/");
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string4 = string;
            return string4;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final VirtualFileUrl append$intellij_platform_workspace_storage(@NotNull VirtualFileUrl parentVfu, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)parentVfu, (String)"parentVfu");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)parentVfu;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            FilePathNode parentNode = this.id2NodeMapping.get(((VirtualFileUrlImpl)parentVfu).getId());
            VirtualFileUrl virtualFileUrl = this.add$intellij_platform_workspace_storage(relativePath, parentNode);
            return virtualFileUrl;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @NotNull
    public Class<? extends VirtualFileUrl> getVirtualFileUrlImplementationClass() {
        return VirtualFileUrlImpl.class;
    }

    @NotNull
    protected VirtualFileUrl createVirtualFileUrl(int id, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return new VirtualFileUrlImpl(id, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFileUrl> getCachedVirtualFileUrls() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            void $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            Collection collection = this.id2NodeMapping.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VirtualFileUrl it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                FilePathNode p0 = (FilePathNode)element$iv$iv;
                boolean bl3 = false;
                if (p0.getCachedVirtualFileUrl() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    @NotNull
    public final VirtualFileUrl add$intellij_platform_workspace_storage(@NotNull String path, @Nullable FilePathNode parentNode) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<String> segments = this.splitNames(path);
        return this.addSegments(parentNode, segments);
    }

    public static /* synthetic */ VirtualFileUrl add$intellij_platform_workspace_storage$default(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, String string, FilePathNode filePathNode, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: add");
        }
        if ((n & 2) != 0) {
            filePathNode = null;
        }
        return virtualFileUrlManagerImpl.add$intellij_platform_workspace_storage(string, filePathNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VirtualFileUrl addSegments(FilePathNode parentNode, List<String> segments) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            FilePathNode filePathNode = parentNode;
            if (filePathNode == null) {
                filePathNode = this.findRootNode((String)CollectionsKt.first(segments));
            }
            FilePathNode latestNode = filePathNode;
            int latestElement = segments.size() - 1;
            int n2 = ((Collection)segments).size();
            for (int index = 0; index < n2; ++index) {
                int nameId = this.fileNameStore.generateIdForName(segments.get(index));
                if (latestNode == null) {
                    int nodeId = this.idGenerator.generateId();
                    FilePathNode newNode = new FilePathNode(this, nodeId, nameId, null, 4, null);
                    ((Map)this.id2NodeMapping).put(nodeId, newNode);
                    if (index == latestElement) {
                        this.rootNode.addChild(newNode);
                        VirtualFileUrl virtualFileUrl = newNode.getVirtualFileUrl(this);
                        return virtualFileUrl;
                    }
                    latestNode = newNode;
                    this.rootNode.addChild(newNode);
                    continue;
                }
                if (latestNode == this.findRootNode(latestNode.getContentId()) && index == 0 && latestNode.getContentId() == nameId) {
                    if (latestElement != 0) continue;
                    VirtualFileUrl virtualFileUrl = latestNode.getVirtualFileUrl(this);
                    return virtualFileUrl;
                }
                FilePathNode node = latestNode.findChild(nameId);
                if (node == null) {
                    int nodeId = this.idGenerator.generateId();
                    FilePathNode newNode = new FilePathNode(this, nodeId, nameId, latestNode);
                    ((Map)this.id2NodeMapping).put(nodeId, newNode);
                    latestNode.addChild(newNode);
                    latestNode = newNode;
                    if (index != latestElement) continue;
                    VirtualFileUrl virtualFileUrl = newNode.getVirtualFileUrl(this);
                    return virtualFileUrl;
                }
                if (index == latestElement) {
                    VirtualFileUrl virtualFileUrl = node.getVirtualFileUrl(this);
                    return virtualFileUrl;
                }
                latestNode = node;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int latestNode = 0; latestNode < n; ++latestNode) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return this.emptyUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VirtualFileUrl findBySegments(List<String> segments) {
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            FilePathNode currentNode = this.rootNode;
            for (String segment : segments) {
                FilePathNode filePathNode;
                Integer n = this.fileNameStore.getIdForName(segment);
                if (n == null) {
                    VirtualFileUrl virtualFileUrl = null;
                    return virtualFileUrl;
                }
                int nameId = n;
                if (currentNode.findChild(nameId) == null) {
                    VirtualFileUrl virtualFileUrl = null;
                    return virtualFileUrl;
                }
                currentNode = filePathNode;
            }
            VirtualFileUrl virtualFileUrl = currentNode.getCachedVirtualFileUrl();
            return virtualFileUrl;
        }
        finally {
            readLock.unlock();
        }
    }

    public final void remove$intellij_platform_workspace_storage(@NotNull String path) {
        FilePathNode parent;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilePathNode node = this.findLatestFilePathNode(path);
        if (node == null) {
            System.out.println((Object)"File not found");
            return;
        }
        if (!node.isEmpty()) {
            return;
        }
        FilePathNode currentNode = node;
        do {
            if ((parent = currentNode.getParent()) == null) {
                if (currentNode == this.findRootNode(currentNode.getContentId()) && currentNode.isEmpty()) {
                    this.removeNameUsage(currentNode.getContentId());
                    this.id2NodeMapping.remove(currentNode.getNodeId());
                    this.rootNode.removeChild(currentNode);
                }
                return;
            }
            parent.removeChild(currentNode);
            this.removeNameUsage(currentNode.getContentId());
            this.id2NodeMapping.remove(currentNode.getNodeId());
        } while ((currentNode = parent).isEmpty());
    }

    public final void update$intellij_platform_workspace_storage(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        FilePathNode latestPathNode = this.findLatestFilePathNode(oldPath);
        if (latestPathNode == null) {
            return;
        }
        this.remove$intellij_platform_workspace_storage(oldPath);
        VirtualFileUrlManagerImpl.add$intellij_platform_workspace_storage$default(this, newPath, null, 2, null);
    }

    private final void removeNameUsage(int contentId) {
        boolean bl;
        String name = this.fileNameStore.getNameForId(contentId);
        boolean bl2 = bl = name != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        this.fileNameStore.removeName(string);
    }

    private final FilePathNode findLatestFilePathNode(String path) {
        List<String> segments = this.splitNames(path);
        FilePathNode latestNode = null;
        latestNode = this.findRootNode((String)CollectionsKt.first(segments));
        int latestElement = segments.size() - 1;
        int n = ((Collection)segments).size();
        for (int index = 0; index < n; ++index) {
            Integer n2 = this.fileNameStore.getIdForName(segments.get(index));
            if (n2 == null) {
                return null;
            }
            int nameId = n2;
            if (latestNode == null) {
                return null;
            }
            if (latestNode == this.findRootNode(latestNode.getContentId()) && latestNode.getContentId() == nameId) {
                if (index != latestElement) continue;
                return latestNode;
            }
            if (latestNode.findChild(nameId) != null) {
                FilePathNode it;
                boolean bl = false;
                if (index == latestElement) {
                    return it;
                }
                latestNode = it;
                continue;
            }
            return null;
        }
        return null;
    }

    private final FilePathNode findRootNode(String segment) {
        Integer n = this.fileNameStore.getIdForName(segment);
        if (n == null) {
            return null;
        }
        int segmentId = n;
        return this.rootNode.findChild(segmentId);
    }

    private final FilePathNode findRootNode(int contentId) {
        return this.rootNode.findChild(contentId);
    }

    private final List<String> splitNames(String path) {
        char[] cArray = new char[]{'/', '\\'};
        return StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public final String print() {
        return this.rootNode.print();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TreeNodeProcessingResult processChildrenRecursively$lambda$5(VirtualFileUrlManagerImpl this$0, Function1 $processor, FilePathNode it) {
        VirtualFileUrl virtualFileUrl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VirtualFileUrlManagerImpl virtualFileUrlManagerImpl = this$0;
        synchronized (virtualFileUrlManagerImpl) {
            boolean bl = false;
            virtualFileUrl = it.getVirtualFileUrl(this$0);
        }
        VirtualFileUrl childUrl = virtualFileUrl;
        return (TreeNodeProcessingResult)((Object)$processor.invoke((Object)childUrl));
    }

    public VirtualFileUrlManagerImpl() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$Companion;", "", "<init>", "()V", "HASHING_STRATEGY", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "getHASHING_STRATEGY", "()Lit/unimi/dsi/fastutil/Hash$Strategy;", "intellij.platform.workspace.storage"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash.Strategy<FilePathNode> getHASHING_STRATEGY() {
            return HASHING_STRATEGY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0012\u001a\b\u0018\u00010\u0000R\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u0015J$\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u00152\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0000R\u00020\u00060\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u00060\u0000R\u00020\u0006\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0012\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060\u0000R\u00020\u0006J\u0012\u0010 \u001a\u00020\u001e2\n\u0010!\u001a\u00060\u0000R\u00020\u0006J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0006J\b\u0010$\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010%\u001a\u00020\u0019J\b\u0010&\u001a\u00020\u001eH\u0002J\u0006\u0010'\u001a\u00020(J$\u0010'\u001a\u00020\u001e2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0018\u00010\u0000R\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\b\u0012\u00060\u0000R\u00020\u0006\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "", "nodeId", "", "contentId", "parent", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;IILcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;)V", "getNodeId", "()I", "getContentId", "getParent", "()Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode;", "virtualFileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "children", "Lit/unimi/dsi/fastutil/objects/ObjectOpenCustomHashSet;", "findChild", "nameId", "getSubtreeNodes", "", "subtreeNodes", "", "processChildrenRecursively", "", "processor", "Lkotlin/Function1;", "Lcom/intellij/util/containers/TreeNodeProcessingResult;", "addChild", "", "newNode", "removeChild", "node", "getVirtualFileUrl", "virtualFileUrlManager", "getCachedVirtualFileUrl", "isEmpty", "createChildrenList", "print", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "prefix", "childrenPrefix", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nVirtualFileUrlManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n1869#2,2:364\n1869#2,2:367\n1#3:366\n*S KotlinDebug\n*F\n+ 1 VirtualFileUrlManagerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl$FilePathNode\n*L\n273#1:364,2\n282#1:367,2\n*E\n"})
    public final class FilePathNode {
        private final int nodeId;
        private final int contentId;
        @Nullable
        private final FilePathNode parent;
        @Nullable
        private VirtualFileUrl virtualFileUrl;
        @Nullable
        private ObjectOpenCustomHashSet<FilePathNode> children;
        final /* synthetic */ VirtualFileUrlManagerImpl this$0;

        public FilePathNode(VirtualFileUrlManagerImpl this$0, int nodeId, @Nullable int contentId, FilePathNode parent) {
            this.this$0 = this$0;
            this.nodeId = nodeId;
            this.contentId = contentId;
            this.parent = parent;
        }

        public /* synthetic */ FilePathNode(VirtualFileUrlManagerImpl virtualFileUrlManagerImpl, int n, int n2, FilePathNode filePathNode, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                filePathNode = null;
            }
            this(virtualFileUrlManagerImpl, n, n2, filePathNode);
        }

        public final int getNodeId() {
            return this.nodeId;
        }

        public final int getContentId() {
            return this.contentId;
        }

        @Nullable
        public final FilePathNode getParent() {
            return this.parent;
        }

        @Nullable
        public final FilePathNode findChild(int nameId) {
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            return objectOpenCustomHashSet != null ? objectOpenCustomHashSet.get(new FilePathNode(this.this$0, 0, nameId, null, 4, null)) : null;
        }

        @NotNull
        public final List<FilePathNode> getSubtreeNodes() {
            return this.getSubtreeNodes(new ArrayList());
        }

        private final List<FilePathNode> getSubtreeNodes(List<FilePathNode> subtreeNodes) {
            block1: {
                ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                if (objectOpenCustomHashSet == null) break block1;
                Iterable $this$forEach$iv = objectOpenCustomHashSet;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FilePathNode it = (FilePathNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    subtreeNodes.add(it);
                    it.getSubtreeNodes(subtreeNodes);
                }
            }
            return subtreeNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean processChildrenRecursively(@NotNull Function1<? super FilePathNode, ? extends TreeNodeProcessingResult> processor) {
            block10: {
                Iterator childrenCopy;
                Iterator iterator2;
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                VirtualFileUrlManagerImpl virtualFileUrlManagerImpl = this.this$0;
                synchronized (virtualFileUrlManagerImpl) {
                    boolean bl = false;
                    ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                    iterator2 = objectOpenCustomHashSet != null ? objectOpenCustomHashSet.clone() : null;
                }
                Iterator iterator3 = childrenCopy = iterator2;
                if (iterator3 == null) break block10;
                Iterable $this$forEach$iv = (Iterable)((Object)iterator3);
                boolean $i$f$forEach = false;
                block9: for (Object element$iv : $this$forEach$iv) {
                    FilePathNode child = (FilePathNode)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)child);
                    switch (WhenMappings.$EnumSwitchMapping$0[((TreeNodeProcessingResult)((Object)processor.invoke((Object)child))).ordinal()]) {
                        case 1: {
                            if (child.processChildrenRecursively(processor)) continue block9;
                            return false;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            return true;
                        }
                        case 4: {
                            return false;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            return true;
        }

        public final void addChild(@NotNull FilePathNode newNode) {
            Intrinsics.checkNotNullParameter((Object)newNode, (String)"newNode");
            this.createChildrenList();
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            Intrinsics.checkNotNull(objectOpenCustomHashSet);
            objectOpenCustomHashSet.add(newNode);
        }

        public final void removeChild(@NotNull FilePathNode node) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
                if (objectOpenCustomHashSet == null) break block0;
                objectOpenCustomHashSet.remove(node);
            }
        }

        @NotNull
        public final VirtualFileUrl getVirtualFileUrl(@NotNull VirtualFileUrlManagerImpl virtualFileUrlManager) {
            VirtualFileUrl url;
            Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
            VirtualFileUrl cachedValue = this.virtualFileUrl;
            if (cachedValue != null) {
                return cachedValue;
            }
            this.virtualFileUrl = url = virtualFileUrlManager.createVirtualFileUrl(this.nodeId, virtualFileUrlManager);
            return url;
        }

        @Nullable
        public final VirtualFileUrl getCachedVirtualFileUrl() {
            return this.virtualFileUrl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            if (this.children == null) return true;
            ObjectOpenCustomHashSet<FilePathNode> objectOpenCustomHashSet = this.children;
            Intrinsics.checkNotNull(objectOpenCustomHashSet);
            if (!objectOpenCustomHashSet.isEmpty()) return false;
            return true;
        }

        private final void createChildrenList() {
            if (this.children == null) {
                this.children = new ObjectOpenCustomHashSet<FilePathNode>(Companion.getHASHING_STRATEGY());
            }
        }

        @NotNull
        public final String print() {
            StringBuilder buffer = new StringBuilder();
            this.print(buffer, "", "");
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void print(StringBuilder buffer, String prefix, String childrenPrefix) {
            Object object;
            String name = this.this$0.fileNameStore.getNameForId(this.contentId);
            if (name != null) {
                buffer.append(prefix + " " + name + "\n");
            }
            if ((object = this.children) == null || (object = ((ObjectOpenCustomHashSet)object).iterator()) == null) {
                return;
            }
            Object iterator2 = object;
            while (iterator2.hasNext()) {
                FilePathNode next = (FilePathNode)iterator2.next();
                if (name == null) {
                    next.print(buffer, childrenPrefix, childrenPrefix);
                    continue;
                }
                if (iterator2.hasNext()) {
                    next.print(buffer, childrenPrefix + " |- ", childrenPrefix + " |   ");
                    continue;
                }
                next.print(buffer, childrenPrefix + " '- ", childrenPrefix + "     ");
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TreeNodeProcessingResult.values().length];
                try {
                    nArray[TreeNodeProcessingResult.CONTINUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeNodeProcessingResult.SKIP_CHILDREN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeNodeProcessingResult.SKIP_TO_PARENT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeNodeProcessingResult.STOP.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

