/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.bridge.impl.serialization;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.UnloadedModulesNameHolder;
import com.intellij.platform.workspace.jps.bridge.JpsModuleExtensionBridge;
import com.intellij.platform.workspace.jps.bridge.impl.JpsModelBridge;
import com.intellij.platform.workspace.jps.bridge.impl.JpsProjectAdditionalData;
import com.intellij.platform.workspace.jps.bridge.impl.JpsProjectBridge;
import com.intellij.platform.workspace.jps.bridge.impl.library.sdk.JpsSdkLibraryBridge;
import com.intellij.platform.workspace.jps.bridge.impl.module.JpsModuleBridge;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.GlobalDirectJpsFileContentReader;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.JpsProcessEntityTypeResolver;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.JpsSerializationViaWorkspaceModelImpl;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.JpsSerializationViaWorkspaceModelImplKt;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.JpsUnloadedModulesNameHolder;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.ProjectDirectJpsFileContentReader;
import com.intellij.platform.workspace.jps.bridge.impl.serialization.SerializationContextImpl;
import com.intellij.platform.workspace.jps.entities.ExternalSystemModuleOptionsEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleExtensions;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.jps.serialization.impl.ApplicationLevelUrlRelativizer;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsGlobalEntitiesSerializers;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectEntitiesLoader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializers;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectUrlRelativizer;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.jps.serialization.impl.UtilsKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.serialization.EntityStorageSerializerImpl;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlManagerImpl;
import com.intellij.platform.workspace.storage.url.UrlRelativizer;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.JpsComponentLoader;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsGlobalSettingsLoading;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectConfigurationLoading;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsSerializationViaWorkspaceModel;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.service.JpsServiceManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001'\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016JX\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\r\u0010&\u001a\u00020'H\u0002\u00a2\u0006\u0002\u0010(J0\u0010)\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010,\u001a\u00020\u00182\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0002J6\u0010\u000e\u001a\u0002002\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J*\u00101\u001a\u0002022\u0006\u00103\u001a\u0002002\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#2\b\u00104\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u00105\u001a\u0002022\u0006\u00103\u001a\u000206H\u0002J\u0010\u00105\u001a\u0002022\u0006\u00107\u001a\u000208H\u0002R\u0014\u0010\u0019\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u00109\u001a\u00020\u0007*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lcom/intellij/platform/workspace/jps/bridge/impl/serialization/JpsSerializationViaWorkspaceModelImpl;", "Lorg/jetbrains/jps/model/serialization/impl/JpsSerializationViaWorkspaceModel;", "<init>", "()V", "loadModel", "Lorg/jetbrains/jps/model/JpsModel;", "projectPath", "Ljava/nio/file/Path;", "workspaceStorageCachePath", "externalConfigurationDirectory", "optionsPath", "globalWorkspaceStoragePath", "loadUnloadedModules", "", "loadProject", "Lcom/intellij/platform/workspace/jps/bridge/impl/JpsModelBridge;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "pathVariables", "", "", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "globalStorage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "useRelativePathsInCache", "getUseRelativePathsInCache", "()Z", "loadFromCacheFile", "cachePath", "urlRelativizer", "Lcom/intellij/platform/workspace/storage/url/UrlRelativizer;", "loadAdditionalData", "Lcom/intellij/platform/workspace/jps/bridge/impl/JpsProjectAdditionalData;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "componentLoader", "Lorg/jetbrains/jps/model/serialization/JpsComponentLoader;", "createErrorReporter", "com/intellij/platform/workspace/jps/bridge/impl/serialization/JpsSerializationViaWorkspaceModelImpl$createErrorReporter$1", "()Lcom/intellij/platform/workspace/jps/bridge/impl/serialization/JpsSerializationViaWorkspaceModelImpl$createErrorReporter$1;", "loadProjectStorage", "fileContentReader", "Lcom/intellij/platform/workspace/jps/bridge/impl/serialization/ProjectDirectJpsFileContentReader;", "loadGlobalStorage", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "macroExpander", "Lorg/jetbrains/jps/model/serialization/JpsMacroExpander;", "Lorg/jetbrains/jps/model/JpsProject;", "loadOtherProjectComponents", "", "project", "externalStoragePath", "loadOtherModuleComponents", "Lcom/intellij/platform/workspace/jps/bridge/impl/JpsProjectBridge;", "module", "Lcom/intellij/platform/workspace/jps/bridge/impl/module/JpsModuleBridge;", "workspaceFile", "getWorkspaceFile", "(Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;)Ljava/nio/file/Path;", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsSerializationViaWorkspaceModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsSerializationViaWorkspaceModelImpl.kt\ncom/intellij/platform/workspace/jps/bridge/impl/serialization/JpsSerializationViaWorkspaceModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,250:1\n1#2:251\n11228#3:252\n11563#3,3:253\n1869#4,2:256\n1869#4,2:260\n216#5,2:258\n*S KotlinDebug\n*F\n+ 1 JpsSerializationViaWorkspaceModelImpl.kt\ncom/intellij/platform/workspace/jps/bridge/impl/serialization/JpsSerializationViaWorkspaceModelImpl\n*L\n163#1:252\n163#1:253,3\n205#1:256,2\n232#1:260,2\n221#1:258,2\n*E\n"})
public final class JpsSerializationViaWorkspaceModelImpl
implements JpsSerializationViaWorkspaceModel {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull Path projectPath, @Nullable Path workspaceStorageCachePath, @Nullable Path externalConfigurationDirectory, @Nullable Path optionsPath, @Nullable Path globalWorkspaceStoragePath, boolean loadUnloadedModules) {
        EntityStorage globalStorageFromCache;
        EntityStorage entityStorage;
        EntityStorage entityStorage2;
        Object object;
        createErrorReporter.1 errorReporter;
        VirtualFileUrlManagerImpl virtualFileUrlManager;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
                virtualFileUrlManager = new VirtualFileUrlManagerImpl(false, 1, null);
                errorReporter = this.createErrorReporter();
                object = optionsPath;
                if (object == null) break block7;
                Path it = object;
                boolean bl = false;
                Map<String, String> map2 = JpsGlobalSettingsLoading.computeAllPathVariables(it);
                object = map2;
                if (map2 != null) break block8;
            }
            object = MapsKt.emptyMap();
        }
        Map<String, String> pathVariables = object;
        JpsMacroExpander globalMacroExpander = new JpsMacroExpander(pathVariables);
        Path path = globalWorkspaceStoragePath;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            ApplicationLevelUrlRelativizer urlRelativizer = this.getUseRelativePathsInCache() ? new ApplicationLevelUrlRelativizer(false) : null;
            entityStorage2 = this.loadFromCacheFile(globalWorkspaceStoragePath, virtualFileUrlManager, urlRelativizer);
        } else {
            entityStorage2 = null;
        }
        if ((entityStorage = (globalStorageFromCache = entityStorage2)) == null) {
            entityStorage = this.loadGlobalStorage(optionsPath, virtualFileUrlManager, errorReporter, globalMacroExpander);
        }
        EntityStorage globalStorage = entityStorage;
        JpsModelBridge model = this.loadProject(projectPath, workspaceStorageCachePath, externalConfigurationDirectory, virtualFileUrlManager, pathVariables, errorReporter, globalStorage, loadUnloadedModules);
        if (optionsPath != null) {
            JpsGlobalExtensionSerializer[] jpsGlobalExtensionSerializerArray = new JpsGlobalExtensionSerializer[]{JpsGlobalLoader.FILE_TYPES_SERIALIZER};
            JpsGlobalLoader globalLoader = new JpsGlobalLoader(globalMacroExpander, model.getGlobal(), jpsGlobalExtensionSerializerArray);
            globalLoader.load(optionsPath);
        }
        return model;
    }

    private final JpsModelBridge loadProject(Path projectPath, Path workspaceStorageCachePath, Path externalConfigurationDirectory, VirtualFileUrlManager virtualFileUrlManager, Map<String, String> pathVariables, ErrorReporter errorReporter, EntityStorage globalStorage, boolean loadUnloadedModules) {
        EntityStorage storageFromCache;
        EntityStorage entityStorage;
        EntityStorage entityStorage2;
        JpsProjectConfigLocation configLocation = UtilsKt.toConfigLocation(projectPath, virtualFileUrlManager);
        ProjectDirectJpsFileContentReader contentReader = new ProjectDirectJpsFileContentReader(UtilsKt.toPath(configLocation.getBaseDirectoryUrl()), externalConfigurationDirectory, pathVariables);
        Path path = workspaceStorageCachePath;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            JpsProjectUrlRelativizer urlRelativizer = this.getUseRelativePathsInCache() ? new JpsProjectUrlRelativizer(PathsKt.getInvariantSeparatorsPathString((Path)UtilsKt.toPath(configLocation.getBaseDirectoryUrl())), false) : null;
            entityStorage2 = this.loadFromCacheFile(workspaceStorageCachePath, virtualFileUrlManager, urlRelativizer);
        } else {
            entityStorage2 = null;
        }
        if ((entityStorage = (storageFromCache = entityStorage2)) == null) {
            entityStorage = this.loadProjectStorage(virtualFileUrlManager, errorReporter, configLocation, contentReader, loadUnloadedModules);
        }
        EntityStorage projectStorage = entityStorage;
        JpsProjectAdditionalData additionalData = this.loadAdditionalData(configLocation, contentReader.getProjectComponentLoader());
        JpsModelBridge model = new JpsModelBridge(projectStorage, globalStorage, additionalData);
        this.loadOtherProjectComponents(model.getProject(), contentReader.getProjectComponentLoader(), configLocation, externalConfigurationDirectory);
        this.loadOtherModuleComponents(model.getProject());
        return model;
    }

    private final boolean getUseRelativePathsInCache() {
        return SystemProperties.getBooleanProperty("jps.workspace.storage.relative.paths.in.cache", false);
    }

    private final EntityStorage loadFromCacheFile(Path cachePath, VirtualFileUrlManager virtualFileUrlManager, UrlRelativizer urlRelativizer) {
        String ijBuildVersion = "243.SNAPSHOT";
        EntityStorageSerializerImpl serializer2 = new EntityStorageSerializerImpl(new JpsProcessEntityTypeResolver(), virtualFileUrlManager, urlRelativizer, ijBuildVersion);
        Object object = serializer2.deserializeCache-IoAF18A(cachePath);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            JpsSerializationViaWorkspaceModelImplKt.access$getLogger$p().warn("Failed to load cache from " + cachePath, it);
        }
        MutableEntityStorage storage = (MutableEntityStorage)(Result.isFailure-impl((Object)object) ? null : object);
        if (storage != null) {
            JpsSerializationViaWorkspaceModelImplKt.access$getLogger$p().info("Loaded from cache: " + cachePath);
        }
        return storage;
    }

    private final JpsProjectAdditionalData loadAdditionalData(JpsProjectConfigLocation configLocation, JpsComponentLoader componentLoader) {
        SdkId sdkId;
        Element element;
        String string;
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            string = JpsProjectConfigurationLoading.getDirectoryBaseProjectName(UtilsKt.toPath(((JpsProjectConfigLocation.DirectoryBased)configLocation).getProjectDir()), UtilsKt.toPath(((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder()));
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            string = FileUtil.getNameWithoutExtension(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile().getFileName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String projectName = string2;
        jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            element = componentLoader.loadRootElement(UtilsKt.toPath(((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder()).resolve("misc.xml"));
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            element = componentLoader.loadRootElement(UtilsKt.toPath(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Element projectRootComponentFileElement = element;
        Pair<String, String> pair = JpsProjectConfigurationLoading.readProjectSdkTypeAndName(projectRootComponentFileElement);
        if (pair != null) {
            Pair<String, String> it = pair;
            boolean bl = false;
            Object b = it.second;
            Intrinsics.checkNotNullExpressionValue(b, (String)"second");
            String string3 = (String)b;
            Object a = it.first;
            Intrinsics.checkNotNullExpressionValue(a, (String)"first");
            sdkId = new SdkId(string3, (String)a);
        } else {
            sdkId = null;
        }
        SdkId projectSdkId = sdkId;
        JpsProjectAdditionalData additionalData = new JpsProjectAdditionalData(projectName, projectSdkId);
        return additionalData;
    }

    private final createErrorReporter.1 createErrorReporter() {
        return new ErrorReporter(){

            public void reportError(String message, VirtualFileUrl file) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                throw new CannotLoadJpsModelException(UtilsKt.toPath(file).toFile(), message, null);
            }
        };
    }

    private final EntityStorage loadProjectStorage(VirtualFileUrlManager virtualFileUrlManager, ErrorReporter errorReporter, JpsProjectConfigLocation configLocation, ProjectDirectJpsFileContentReader fileContentReader, boolean loadUnloadedModules) {
        UnloadedModulesNameHolder unloadedModulesNameHolder;
        Path path = fileContentReader.getExternalConfigurationDirectory();
        if (path == null) {
            path = UtilsKt.toPath(configLocation.getBaseDirectoryUrl()).resolve("fake_external_build_system");
        }
        Path externalStoragePath = path;
        SerializationContextImpl context = new SerializationContextImpl(virtualFileUrlManager, fileContentReader);
        Intrinsics.checkNotNull((Object)externalStoragePath);
        JpsProjectSerializers serializers = JpsProjectEntitiesLoader.INSTANCE.createProjectSerializers(configLocation, externalStoragePath, context);
        MutableEntityStorage mainStorage = MutableEntityStorage.Companion.create();
        MutableEntityStorage orphanageStorage = MutableEntityStorage.Companion.create();
        MutableEntityStorage unloadedStorage = MutableEntityStorage.Companion.create();
        if (loadUnloadedModules) {
            unloadedModulesNameHolder = UnloadedModulesNameHolder.DUMMY;
        } else {
            Set<String> set = JpsProjectConfigurationLoading.readNamesOfUnloadedModules(this.getWorkspaceFile(configLocation), fileContentReader.getProjectComponentLoader());
            Intrinsics.checkNotNullExpressionValue(set, (String)"readNamesOfUnloadedModules(...)");
            unloadedModulesNameHolder = new JpsUnloadedModulesNameHolder(set);
        }
        UnloadedModulesNameHolder unloadedModuleNames = unloadedModulesNameHolder;
        BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends EntitySource>>, Object>(serializers, context, mainStorage, orphanageStorage, unloadedStorage, unloadedModuleNames, errorReporter, null){
            int label;
            final /* synthetic */ JpsProjectSerializers $serializers;
            final /* synthetic */ SerializationContextImpl $context;
            final /* synthetic */ MutableEntityStorage $mainStorage;
            final /* synthetic */ MutableEntityStorage $orphanageStorage;
            final /* synthetic */ MutableEntityStorage $unloadedStorage;
            final /* synthetic */ UnloadedModulesNameHolder $unloadedModuleNames;
            final /* synthetic */ ErrorReporter $errorReporter;
            {
                this.$serializers = $serializers;
                this.$context = $context;
                this.$mainStorage = $mainStorage;
                this.$orphanageStorage = $orphanageStorage;
                this.$unloadedStorage = $unloadedStorage;
                this.$unloadedModuleNames = $unloadedModuleNames;
                this.$errorReporter = $errorReporter;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        JpsFileContentReader jpsFileContentReader = this.$context.getFileContentReader();
                        UnloadedModulesNameHolder unloadedModulesNameHolder = this.$unloadedModuleNames;
                        Intrinsics.checkNotNull((Object)unloadedModulesNameHolder);
                        this.label = 1;
                        Object object2 = this.$serializers.loadAll(jpsFileContentReader, this.$mainStorage, this.$orphanageStorage, this.$unloadedStorage, unloadedModulesNameHolder, this.$errorReporter, (Continuation<? super List<? extends EntitySource>>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends EntitySource>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
        return mainStorage;
    }

    /*
     * WARNING - void declaration
     */
    private final EntityStorage loadGlobalStorage(Path optionsPath, VirtualFileUrlManagerImpl virtualFileUrlManager, ErrorReporter errorReporter, JpsMacroExpander macroExpander) {
        void $this$mapTo$iv$iv;
        MutableEntityStorage globalStorage = MutableEntityStorage.Companion.create();
        if (optionsPath == null) {
            return globalStorage;
        }
        GlobalDirectJpsFileContentReader reader = new GlobalDirectJpsFileContentReader(macroExpander);
        JpsLibraryRootTypeSerializer[] $this$map$iv = JpsSdkLibraryBridge.Companion.getSerializers$intellij_platform_workspace_jps();
        boolean $i$f$map = false;
        JpsLibraryRootTypeSerializer[] jpsLibraryRootTypeSerializerArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_19 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTypeId());
        }
        List rootsTypes = (List)destination$iv$iv;
        List<JpsFileEntityTypeSerializer<WorkspaceEntity>> serializers = JpsGlobalEntitiesSerializers.INSTANCE.createApplicationSerializers(virtualFileUrlManager, rootsTypes, optionsPath);
        for (JpsFileEntityTypeSerializer<WorkspaceEntity> serializer2 : serializers) {
            LoadingResult<Map<Class<WorkspaceEntity>, Collection<WorkspaceEntity.Builder<WorkspaceEntity>>>> loaded = serializer2.loadEntities(reader, errorReporter, virtualFileUrlManager);
            serializer2.checkAndAddToBuilder(globalStorage, globalStorage, loaded.getData());
            Throwable throwable = loaded.getException();
            if (throwable == null) continue;
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        return globalStorage;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull Path projectPath, @Nullable Path externalConfigurationDirectory, @NotNull Map<String, String> pathVariables, boolean loadUnloadedModules) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter(pathVariables, (String)"pathVariables");
        JpsModelBridge model = this.loadProject(projectPath, null, externalConfigurationDirectory, new VirtualFileUrlManagerImpl(false, 1, null), pathVariables, this.createErrorReporter(), MutableEntityStorage.Companion.create(), loadUnloadedModules);
        return model.getProject();
    }

    private final void loadOtherProjectComponents(JpsProject project, JpsComponentLoader componentLoader, JpsProjectConfigLocation configLocation, Path externalStoragePath) {
        JpsProjectConfigurationLoading.setupSerializationExtension(project, UtilsKt.toPath(configLocation.getBaseDirectoryUrl()));
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            Path dotIdea = UtilsKt.toPath(((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder());
            Path defaultConfigFile = dotIdea.resolve("misc.xml");
            for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
                for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                    componentLoader.loadComponents(dotIdea, defaultConfigFile, jpsProjectExtensionSerializer, (JpsElement)project);
                }
            }
            JpsProjectConfigurationLoading.loadArtifactsFromDirectory(project, componentLoader, dotIdea, externalStoragePath);
            JpsProjectConfigurationLoading.loadRunConfigurationsFromDirectory(project, componentLoader, dotIdea, this.getWorkspaceFile(configLocation));
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            Path iprFile = UtilsKt.toPath(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile());
            Element iprRoot = componentLoader.loadRootElement(iprFile);
            Element iwsRoot = componentLoader.loadRootElement(this.getWorkspaceFile(configLocation));
            JpsProjectConfigurationLoading.loadProjectExtensionsFromIpr(project, iprRoot, iwsRoot);
            JpsProjectConfigurationLoading.loadArtifactsFromIpr(project, iprRoot);
            JpsProjectConfigurationLoading.loadRunConfigurationsFromIpr(project, iprRoot, iwsRoot);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void loadOtherModuleComponents(JpsProjectBridge project) {
        Iterable $this$forEach$iv = project.getModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsModuleBridge module = (JpsModuleBridge)element$iv;
            boolean bl = false;
            this.loadOtherModuleComponents(module);
        }
    }

    private final void loadOtherModuleComponents(JpsModuleBridge module) {
        ModuleEntity moduleEntity = module.getEntity();
        EntitySource entitySource = moduleEntity.getEntitySource();
        if (entitySource instanceof JpsProjectFileEntitySource.FileInDirectory) {
            module.getContainer().setChild(JpsModuleSerializationDataExtensionImpl.ROLE, (JpsElement)new JpsModuleSerializationDataExtensionImpl(UtilsKt.toPath(((JpsProjectFileEntitySource.FileInDirectory)entitySource).getDirectory())));
        }
        for (JpsModelSerializerExtension serializerExtension : JpsModelSerializerExtension.getExtensions()) {
            Element rootElement = new Element("module");
            Object object = ModuleExtensions.getCustomImlData(moduleEntity);
            if (object != null && (object = object.getCustomModuleOptions()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    rootElement.setAttribute(key, value);
                }
            }
            if (ModuleExtensions.getExModuleOptions(moduleEntity) != null) {
                ExternalSystemModuleOptionsEntity externalSystemOptions;
                boolean bl = false;
                if (externalSystemOptions.getExternalSystem() != null) {
                    String it;
                    boolean bl2 = false;
                    rootElement.setAttribute("external.system.id", it);
                    rootElement.setAttribute("ExternalSystem", it);
                }
            }
            serializerExtension.loadModuleOptions(module, rootElement);
        }
        Iterable<JpsModuleExtensionBridge> iterable = JpsServiceManager.getInstance().getExtensions(JpsModuleExtensionBridge.class);
        Intrinsics.checkNotNullExpressionValue(iterable, (String)"getExtensions(...)");
        Iterable<JpsModuleExtensionBridge> $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator<JpsModuleExtensionBridge> iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            JpsModuleExtensionBridge element$iv;
            JpsModuleExtensionBridge extensionBridge = element$iv = iterator3.next();
            boolean bl = false;
            extensionBridge.loadModuleExtensions(moduleEntity, module);
        }
    }

    private final Path getWorkspaceFile(JpsProjectConfigLocation $this$workspaceFile) {
        Path path;
        JpsProjectConfigLocation jpsProjectConfigLocation = $this$workspaceFile;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            Path path2 = UtilsKt.toPath(((JpsProjectConfigLocation.DirectoryBased)$this$workspaceFile).getIdeaFolder()).resolve("workspace.xml");
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            Path path3 = UtilsKt.toPath(((JpsProjectConfigLocation.FileBased)$this$workspaceFile).getIprFileParent());
            String string = ((JpsProjectConfigLocation.FileBased)$this$workspaceFile).getIprFile().getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            Path path4 = path3.resolve(StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null) + ".iws");
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path;
    }
}

