/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.coroutines.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u0016\u0017\u0018B\u0017\b\u0004\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH%\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH%\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream;", "T", "Ljava/io/OutputStream;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "<init>", "(Lkotlinx/coroutines/channels/SendChannel;)V", "fromByte", "b", "", "(B)Ljava/lang/Object;", "range", "", "offset", "", "nextOffset", "([BII)Ljava/lang/Object;", "write", "", "off", "len", "close", "Companion", "ForByteArray", "ForByteBuffer", "Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream$ForByteArray;", "Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream$ForByteBuffer;", "intellij.platform.util.coroutines"})
@ApiStatus.Experimental
public abstract class ChannelOutputStream<T>
extends OutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SendChannel<T> channel;

    private ChannelOutputStream(SendChannel<? super T> channel) {
        this.channel = channel;
    }

    @ApiStatus.Internal
    protected abstract T fromByte(byte var1);

    @ApiStatus.Internal
    protected abstract T range(@NotNull byte[] var1, int var2, int var3);

    @Override
    public void write(int b) {
        Object result = ChannelsKt.trySendBlocking(this.channel, this.fromByte((byte)b));
        if (ChannelResult.isClosed-impl(result)) {
            throw new IOException("Unable to write, channel is closed");
        }
        if (ChannelResult.isFailure-impl(result)) {
            throw new IOException("Unable to write to channel", ChannelResult.exceptionOrNull-impl(result));
        }
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int offset = off;
        while (offset < off + len) {
            int nextOffset = Math.min(offset + 1024, off + len);
            Object result = ChannelsKt.trySendBlocking(this.channel, this.range(b, offset, nextOffset));
            if (ChannelResult.isClosed-impl(result)) {
                throw new IOException("Unable to write, channel is closed");
            }
            if (ChannelResult.isFailure-impl(result)) {
                throw new IOException("Unable to write to channel", ChannelResult.exceptionOrNull-impl(result));
            }
            offset = nextOffset;
        }
    }

    @Override
    public void close() {
        SendChannel.DefaultImpls.close$default(this.channel, null, 1, null);
        super.close();
    }

    public /* synthetic */ ChannelOutputStream(SendChannel channel, DefaultConstructorMarker $constructor_marker) {
        this(channel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream$Companion;", "", "<init>", "()V", "forArrays", "Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream;", "", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "forByteBuffers", "Ljava/nio/ByteBuffer;", "intellij.platform.util.coroutines"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChannelOutputStream<byte[]> forArrays(@NotNull SendChannel<? super byte[]> channel) {
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            return new ForByteArray(channel);
        }

        @NotNull
        public final ChannelOutputStream<ByteBuffer> forByteBuffers(@NotNull SendChannel<? super ByteBuffer> channel) {
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            return new ForByteBuffer(channel);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream$ForByteArray;", "Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream;", "", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "<init>", "(Lkotlinx/coroutines/channels/SendChannel;)V", "fromByte", "b", "", "range", "offset", "", "nextOffset", "intellij.platform.util.coroutines"})
    private static final class ForByteArray
    extends ChannelOutputStream<byte[]> {
        public ForByteArray(@NotNull SendChannel<? super byte[]> channel) {
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            super(channel, null);
        }

        @Override
        @NotNull
        protected byte[] fromByte(byte b) {
            byte[] byArray = new byte[]{b};
            return byArray;
        }

        @Override
        @NotNull
        protected byte[] range(@NotNull byte[] b, int offset, int nextOffset) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return ArraysKt.copyOfRange((byte[])b, (int)offset, (int)nextOffset);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream$ForByteBuffer;", "Lcom/intellij/platform/util/coroutines/channel/ChannelOutputStream;", "Ljava/nio/ByteBuffer;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "<init>", "(Lkotlinx/coroutines/channels/SendChannel;)V", "fromByte", "b", "", "range", "", "offset", "", "nextOffset", "intellij.platform.util.coroutines"})
    private static final class ForByteBuffer
    extends ChannelOutputStream<ByteBuffer> {
        public ForByteBuffer(@NotNull SendChannel<? super ByteBuffer> channel) {
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            super(channel, null);
        }

        @Override
        @NotNull
        protected ByteBuffer fromByte(byte b) {
            byte[] byArray = new byte[]{b};
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            return byteBuffer;
        }

        @Override
        @NotNull
        protected ByteBuffer range(@NotNull byte[] b, int offset, int nextOffset) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            ByteBuffer byteBuffer = ByteBuffer.wrap(b, offset, nextOffset);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            return byteBuffer;
        }
    }
}

