/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.platform.diagnostic.telemetry.AggregatedMetricExporterKt;
import com.intellij.platform.diagnostic.telemetry.MetricsExporterEntry;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/AggregatedMetricExporter;", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "<init>", "()V", "metricsExporters", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/platform/diagnostic/telemetry/MetricsExporterEntry;", "addMetricsExporters", "", "metrics", "", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "instrumentType", "Lio/opentelemetry/sdk/metrics/InstrumentType;", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "flush", "shutdown", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
public final class AggregatedMetricExporter
implements MetricExporter {
    @NotNull
    private final CopyOnWriteArrayList<MetricsExporterEntry> metricsExporters = new CopyOnWriteArrayList();

    public final void addMetricsExporters(@NotNull List<MetricsExporterEntry> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.metricsExporters.addAll((Collection<MetricsExporterEntry>)metrics);
    }

    @Override
    @NotNull
    public AggregationTemporality getAggregationTemporality(@NotNull InstrumentType instrumentType) {
        Intrinsics.checkNotNullParameter((Object)((Object)instrumentType), (String)"instrumentType");
        return AggregationTemporality.DELTA;
    }

    @Override
    @NotNull
    public CompletableResultCode export(@NotNull Collection<MetricData> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        if (this.metricsExporters.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
            return completableResultCode;
        }
        List results = new ArrayList();
        Iterator<MetricsExporterEntry> iterator2 = this.metricsExporters.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<MetricsExporterEntry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MetricsExporterEntry entry = iterator3.next();
            for (MetricExporter exporter : entry.getMetrics()) {
                try {
                    CompletableResultCode completableResultCode = exporter.export(metrics);
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"export(...)");
                    results.add(completableResultCode);
                }
                catch (Throwable e) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofFailure(...)");
                    results.add(completableResultCode);
                    AggregatedMetricExporterKt.access$getLOG().info("Exporter " + exporter.getClass().getName() + " failed to export with: " + e.getMessage());
                }
            }
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll(results);
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofAll(...)");
        return completableResultCode;
    }

    @Override
    @NotNull
    public CompletableResultCode flush() {
        List results = new ArrayList();
        Iterator<MetricsExporterEntry> iterator2 = this.metricsExporters.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<MetricsExporterEntry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MetricsExporterEntry metricsExporterEntry = iterator3.next();
            for (MetricExporter exporter : metricsExporterEntry.getMetrics()) {
                try {
                    CompletableResultCode completableResultCode = exporter.flush();
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"flush(...)");
                    results.add(completableResultCode);
                }
                catch (Throwable e) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofFailure(...)");
                    results.add(completableResultCode);
                    AggregatedMetricExporterKt.access$getLOG().info("Exporter " + exporter.getClass().getName() + " failed to flush with: " + e.getMessage());
                }
            }
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll(results);
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofAll(...)");
        return completableResultCode;
    }

    @Override
    @NotNull
    public CompletableResultCode shutdown() {
        List results = new ArrayList();
        Iterator<MetricsExporterEntry> iterator2 = this.metricsExporters.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<MetricsExporterEntry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MetricsExporterEntry metricsExporterEntry = iterator3.next();
            for (MetricExporter exporter : metricsExporterEntry.getMetrics()) {
                try {
                    CompletableResultCode completableResultCode = exporter.shutdown();
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"shutdown(...)");
                    results.add(completableResultCode);
                }
                catch (Throwable e) {
                    CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
                    Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofFailure(...)");
                    results.add(completableResultCode);
                    AggregatedMetricExporterKt.access$getLOG().info("Exporter " + exporter.getClass().getName() + " failed to shutdown with: " + e.getMessage());
                }
            }
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll(results);
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofAll(...)");
        return completableResultCode;
    }
}

