/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DependenciesBuilder {
    private final Project myProject;
    private final AnalysisScope myScope;
    private final Map<PsiFile, Set<PsiFile>> myDependencies;
    private Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> myIllegalDependencies;
    protected int myTotalFileCount;
    protected int myFileCount;

    protected DependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            DependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DependenciesBuilder.$$$reportNull$$$0(1);
        }
        this.myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myIllegalDependencies = Collections.emptyMap();
        this.myFileCount = 0;
        this.myProject = project;
        this.myScope = scope;
        this.myTotalFileCount = scope.getFileCount();
    }

    public void setInitialFileCount(int fileCount) {
        this.myFileCount = fileCount;
    }

    public void setTotalFileCount(int totalFileCount) {
        this.myTotalFileCount = totalFileCount;
    }

    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDependencies() {
        Map<PsiFile, Set<PsiFile>> map2 = this.myDependencies;
        if (map2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        Map<PsiFile, Set<PsiFile>> map2 = this.getDependencies();
        if (map2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.myScope;
        if (analysisScope == null) {
            DependenciesBuilder.$$$reportNull$$$0(4);
        }
        return analysisScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DependenciesBuilder.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Nls
    public abstract String getRootNodeNameInUsageView();

    @Nls
    public abstract String getInitialUsagesPosition();

    public abstract boolean isBackward();

    public void analyze() {
        this.doAnalyze();
        this.myIllegalDependencies = ReadAction.compute(this::doGetIllegalDependencies);
    }

    public abstract void doAnalyze();

    public Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> getIllegalDependencies() {
        return this.myIllegalDependencies;
    }

    private Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> doGetIllegalDependencies() {
        HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>> result = new HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>>();
        DependencyValidationManager validator = DependencyValidationManager.getInstance(this.myProject);
        for (PsiFile file : this.getDirectDependencies().keySet()) {
            Set<PsiFile> deps = this.getDirectDependencies().get(file);
            HashMap<DependencyRule, HashSet<PsiFile>> illegal = null;
            for (PsiFile dependency : deps) {
                HashSet<PsiFile> illegalFilesByRule;
                DependencyRule rule = this.isBackward() ? validator.getViolatorDependencyRule(dependency, file) : validator.getViolatorDependencyRule(file, dependency);
                if (rule == null) continue;
                if (illegal == null) {
                    illegal = new HashMap<DependencyRule, HashSet<PsiFile>>();
                    result.put(file, illegal);
                }
                if ((illegalFilesByRule = (HashSet<PsiFile>)illegal.get(rule)) == null) {
                    illegalFilesByRule = new HashSet<PsiFile>();
                }
                illegalFilesByRule.add(dependency);
                illegal.put(rule, illegalFilesByRule);
            }
        }
        return result;
    }

    public List<List<PsiFile>> findPaths(PsiFile from, PsiFile to) {
        return this.findPaths(from, to, new HashSet());
    }

    private List<List<PsiFile>> findPaths(PsiFile from, PsiFile to, Set<? super PsiFile> processed2) {
        ArrayList<List<PsiFile>> result = new ArrayList<List<PsiFile>>();
        Set<PsiFile> reachable = this.getDirectDependencies().get(from);
        if (reachable != null) {
            if (reachable.contains(to)) {
                result.add(new ArrayList());
                return result;
            }
            if (processed2.add(from)) {
                for (PsiFile file : reachable) {
                    if (this.getScope().contains(file)) continue;
                    List<List<PsiFile>> paths = this.findPaths(file, to, processed2);
                    for (List<PsiFile> path : paths) {
                        path.add(0, file);
                    }
                    result.addAll(paths);
                }
            }
        }
        return result;
    }

    @NlsSafe
    String getRelativeToProjectPath(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DependenciesBuilder.$$$reportNull$$$0(6);
        }
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), this.getProject(), true, false);
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file, @NotNull DependencyProcessor processor) {
        if (file == null) {
            DependenciesBuilder.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            DependenciesBuilder.$$$reportNull$$$0(8);
        }
        DependenciesBuilder.analyzeFileDependencies(file, processor, DependencyVisitorFactory.VisitorOptions.fromSettings(file.getProject()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzeFileDependencies(@NotNull PsiFile file, @NotNull DependencyProcessor processor, @NotNull DependencyVisitorFactory.VisitorOptions options) {
        if (file == null) {
            DependenciesBuilder.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            DependenciesBuilder.$$$reportNull$$$0(10);
        }
        if (options == null) {
            DependenciesBuilder.$$$reportNull$$$0(11);
        }
        Boolean prev = file.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING);
        file.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, Boolean.TRUE);
        try {
            file.accept(DependencyVisitorFactory.createVisitor(file, processor, options));
        }
        finally {
            file.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, prev);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/DependenciesBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/DependenciesBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeToProjectPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFileDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface DependencyProcessor {
        public void process(@NotNull PsiElement var1, @NotNull PsiElement var2);
    }
}

