/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0004H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0007\u00a8\u0006\u0007"}, d2={"containsLineBreak", "", "", "isLineBreak", "", "getLineBreakCount", "", "intellij.platform.util.multiplatform"})
@JvmName(name="StringUtilKmp")
@ApiStatus.Experimental
public final class StringUtilKmp {
    @Contract(pure=true)
    public static final boolean containsLineBreak(@NotNull CharSequence $this$containsLineBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$containsLineBreak, (String)"<this>");
        int n = $this$containsLineBreak.length();
        for (int i = 0; i < n; ++i) {
            char c = $this$containsLineBreak.charAt(i);
            if (!StringUtilKmp.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static final boolean isLineBreak(char $this$isLineBreak) {
        return $this$isLineBreak == '\n' || $this$isLineBreak == '\r';
    }

    @Contract(pure=true)
    public static final int getLineBreakCount(@NotNull CharSequence $this$getLineBreakCount) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineBreakCount, (String)"<this>");
        int count2 = 0;
        block4: for (int i = 0; i < $this$getLineBreakCount.length(); ++i) {
            char c = $this$getLineBreakCount.charAt(i);
            switch (c) {
                case '\n': {
                    ++count2;
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < $this$getLineBreakCount.length() && $this$getLineBreakCount.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    ++count2;
                }
            }
        }
        return count2;
    }
}

