/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleContentScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesContentScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsTestScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.IntObjectMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ModuleScopeProviderImpl
implements ModuleScopeProvider {
    private final Module module;
    private final IntObjectMap<GlobalSearchScope> scopeCache;
    private ModuleWithDependentsTestScope moduleTestsWithDependentsScope;
    private volatile ModuleWithDependenciesContentScope moduleWithDependenciesContentScope;

    public ModuleScopeProviderImpl(@NotNull Module module) {
        if (module == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(0);
        }
        this.scopeCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.module = module;
    }

    @NotNull
    private GlobalSearchScope getCachedScope(@ModuleWithDependenciesScope.ScopeConstant int options) {
        GlobalSearchScope scope = this.scopeCache.get(options);
        if (scope == null) {
            scope = new ModuleWithDependenciesScope(this.module, options);
            this.scopeCache.put(options, scope);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleScope() {
        return this.getCachedScope(9);
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleScope(boolean includeTests) {
        return this.getCachedScope(1 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleWithLibrariesScope() {
        return this.getCachedScope(11);
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleWithDependenciesScope() {
        return this.getCachedScope(13);
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleContentScope() {
        return new ModuleContentScope(this.module);
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleContentWithDependenciesScope() {
        ModuleWithDependenciesContentScope scope = this.moduleWithDependenciesContentScope;
        if (scope == null) {
            this.moduleWithDependenciesContentScope = scope = new ModuleWithDependenciesContentScope(this.module);
        }
        ModuleWithDependenciesContentScope moduleWithDependenciesContentScope = scope;
        if (moduleWithDependenciesContentScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(2);
        }
        return moduleWithDependenciesContentScope;
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        return this.getCachedScope(7 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = ((ModuleWithDependentsTestScope)this.getModuleTestsWithDependentsScope()).getDelegate();
        if (globalSearchScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleTestsWithDependentsScope() {
        ModuleWithDependentsTestScope scope = this.moduleTestsWithDependentsScope;
        if (scope == null) {
            this.moduleTestsWithDependentsScope = scope = new ModuleWithDependentsTestScope(this.module);
        }
        ModuleWithDependentsTestScope moduleWithDependentsTestScope = scope;
        if (moduleWithDependentsTestScope == null) {
            ModuleScopeProviderImpl.$$$reportNull$$$0(4);
        }
        return moduleWithDependentsTestScope;
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        return this.getCachedScope(6 | (includeTests ? 8 : 0));
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleProductionSourceScope() {
        return this.getCachedScope(0);
    }

    @Override
    @NotNull
    public final GlobalSearchScope getModuleTestSourceScope() {
        return this.getCachedScope(8);
    }

    @Override
    public final void clearCache() {
        this.scopeCache.clear();
        this.moduleTestsWithDependentsScope = null;
        this.moduleWithDependenciesContentScope = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentWithDependenciesScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependentsScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestsWithDependentsScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

