/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.FileViewProviderUtil;
import com.intellij.codeInsight.multiverse.ModuleContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ExtensionsKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtilRt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.graph.Graph;
import com.intellij.workspaceModel.ide.legacyBridge.WorkspaceModelLegacyBridge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    @ApiStatus.Internal
    protected ModuleUtilCore() {
    }

    public static boolean projectContainsFile(@NotNull Project project, @NotNull VirtualFile file, boolean isLibraryElement) {
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(1);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orders) {
                if (!(orderEntry instanceof JdkOrderEntry) && !(orderEntry instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file);
    }

    @NotNull
    public static String getModuleNameInReadAction(@NotNull Module module) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(2);
        }
        String string = ReadAction.compute(module::getName);
        if (string == null) {
            ModuleUtilCore.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isModuleDisposed(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(4);
        }
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance(project);
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        Module module2 = module = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module == null ? !projectFileIndex.isInLibraryClasses(vFile) : module.isDisposed();
    }

    @Nullable
    public static Module findModuleForFile(@Nullable PsiFile containingFile) {
        VirtualFile vFile;
        if (containingFile != null && (vFile = containingFile.getVirtualFile()) != null) {
            return ModuleUtilCore.findModuleForFile(vFile, containingFile.getProject());
        }
        return null;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(6);
        }
        if (project.isDefault()) {
            return null;
        }
        return ReadAction.compute(() -> ProjectFileIndex.getInstance(project).getModuleForFile(file));
    }

    @ApiStatus.Internal
    @NotNull
    public static @Unmodifiable Set<Module> findModulesForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(8);
        }
        if (project.isDefault()) {
            Set<Module> set = Collections.emptySet();
            if (set == null) {
                ModuleUtilCore.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set set = ReadAction.compute(() -> ProjectFileIndex.getInstance(project).getModulesForFile(file, true));
        if (set == null) {
            ModuleUtilCore.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        PsiElement highestPsi;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(11);
        }
        PsiElement psiElement = highestPsi = (containingFile = element.getContainingFile()) == null ? element : containingFile;
        if (!highestPsi.isValid()) {
            return null;
        }
        Project project = highestPsi.getProject();
        if (project.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance(project);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            CodeInsightContext currentContext;
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrary(vFile)) {
                List<OrderEntry> orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return null;
                }
                if (orderEntries.size() == 1 && orderEntries.get(0) instanceof LibraryOrSdkOrderEntry) {
                    return orderEntries.get(0).getOwnerModule();
                }
                Optional<Module> module = orderEntries.stream().filter(entry -> entry instanceof LibraryOrSdkOrderEntry).map(OrderEntry::getOwnerModule).min(ModuleManager.getInstance(project).moduleDependencyComparator());
                if (module.isPresent()) {
                    return module.get();
                }
            }
            if (CodeInsightContexts.isSharedSourceSupportEnabled(project) && containingFile != null && (currentContext = CodeInsightContextManager.getInstance(project).getCodeInsightContext(containingFile.getViewProvider())) instanceof ModuleContext) {
                return ((ModuleContext)currentContext).getModule();
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            Module module;
            PsiFile file;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file = context.getContainingFile()) != null) {
                containingFile = file;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return originalFile.getUserData(KEY_MODULE);
            }
            CodeInsightContext codeInsightContext = FileViewProviderUtil.getCodeInsightContext(originalFile);
            if (codeInsightContext instanceof ModuleContext && (module = ((ModuleContext)codeInsightContext).getModule()) != null) {
                return module;
            }
            VirtualFile virtualFile = originalFile.getVirtualFile();
            if (virtualFile != null) {
                return fileIndex.getModuleForFile(virtualFile);
            }
        }
        return element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module, @NotNull Set<? super Module> modules) {
        Module[] dependencies;
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(12);
        }
        if (modules == null) {
            ModuleUtilCore.$$$reportNull$$$0(13);
        }
        if (modules.contains(module)) {
            return;
        }
        modules.add(module);
        for (Module dependency : dependencies = ModuleRootManager.getInstance(module).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules);
        }
    }

    @ApiStatus.Obsolete(since="2025.1")
    public static void collectModulesDependsOn(@NotNull Module module, @NotNull Set<? super Module> result) {
        Project project;
        WorkspaceModelLegacyBridge legacyBridge;
        ModuleEntity moduleEntity;
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(14);
        }
        if (result == null) {
            ModuleUtilCore.$$$reportNull$$$0(15);
        }
        if ((moduleEntity = (legacyBridge = (project = module.getProject()).getService(WorkspaceModelLegacyBridge.class)).findModuleEntity(module)) == null) {
            return;
        }
        Set<ModuleEntity> tmpSet = ExtensionsKt.collectTransitivelyDependentModules(moduleEntity, WorkspaceModel.getInstance(project).getCurrentSnapshot());
        ProgressManager.checkCanceled();
        for (ModuleEntity dependentModule : tmpSet) {
            Module legacyModule = legacyBridge.findLegacyModule(dependentModule);
            if (legacyModule == null) continue;
            result.add(legacyModule);
        }
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(16);
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph2 = ModuleManager.getInstance(module.getProject()).moduleGraph();
        Iterator<Module> i = graph2.getOut(module);
        while (i.hasNext()) {
            list.add(i.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            ModuleUtilCore.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module, @NotNull ModuleVisitor visitor) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(18);
        }
        if (visitor == null) {
            ModuleUtilCore.$$$reportNull$$$0(19);
        }
        if (!visitor.visit(module)) {
            return false;
        }
        List<Module> list = ModuleUtilCore.getAllDependentModules(module);
        for (Module dependentModule : list) {
            if (visitor.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(@NotNull Module module, @NotNull VirtualFile file, boolean isLibraryElement) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(20);
        }
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(21);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file);
    }

    public static boolean isModuleFile(@NotNull Module module, @NotNull VirtualFile file) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(22);
        }
        if (file == null) {
            ModuleUtilCore.$$$reportNull$$$0(23);
        }
        return VfsUtilCore.pathEqualsTo(file, module.getModuleFilePath());
    }

    public static boolean isModuleDir(@NotNull Module module, @NotNull VirtualFile dir) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(24);
        }
        if (dir == null) {
            ModuleUtilCore.$$$reportNull$$$0(25);
        }
        return VfsUtilCore.pathEqualsTo(dir, ModuleUtilCore.getModuleDirPath(module));
    }

    @NotNull
    public static String getModuleDirPath(@NotNull Module module) {
        if (module == null) {
            ModuleUtilCore.$$$reportNull$$$0(26);
        }
        String string = PathUtilRt.getParentPath(module.getModuleFilePath());
        if (string == null) {
            ModuleUtilCore.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 17, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameInReadAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findModulesForFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectContainsFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameInReadAction";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 17: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDisposed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findModulesForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForPsiElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesDependsOn";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitMeAndDependentModules";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "moduleContainsFile";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDir";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10, 17, 27 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface ModuleVisitor {
        public boolean visit(@NotNull Module var1);
    }
}

