/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
@ApiStatus.Internal
public interface SweepProcessor<T> {
    public boolean process(int var1, @NotNull T var2, boolean var3, @NotNull Collection<? extends T> var4);

    public static <T extends Segment> boolean sweep(@NotNull Generator<? extends T> generator, @NotNull SweepProcessor<T> sweepProcessor) {
        PriorityQueue<Segment> ends;
        if (generator == null) {
            SweepProcessor.$$$reportNull$$$0(0);
        }
        if (sweepProcessor == null) {
            SweepProcessor.$$$reportNull$$$0(1);
        }
        if (!generator.processAllInStartOffsetOrder(arg_0 -> SweepProcessor.lambda$sweep$0(ends = new PriorityQueue<Segment>(5, Comparator.comparingInt(Segment::getEndOffset)), generator, sweepProcessor, arg_0))) {
            return false;
        }
        while (!ends.isEmpty()) {
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (sweepProcessor.process(prevEnd, previous, false, ends)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$sweep$0(Queue ends, Generator generator, SweepProcessor sweepProcessor, Segment marker) {
        int start = marker.getStartOffset();
        while (!ends.isEmpty()) {
            Segment previous = (Segment)ends.peek();
            int previousStartOffset = previous.getStartOffset();
            if (start < previousStartOffset) {
                throw new IllegalStateException("Generator " + String.valueOf(generator) + " supplied segments in a wrong order: " + String.valueOf(previous) + " was received before " + String.valueOf(marker) + " (" + start + "<" + previousStartOffset + ")");
            }
            int prevEnd = previous.getEndOffset();
            if (prevEnd > start) break;
            if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                return false;
            }
            ends.remove();
        }
        if (!sweepProcessor.process(start, marker, true, ends)) {
            return false;
        }
        ends.offer(marker);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "generator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sweepProcessor";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/impl/SweepProcessor";
        objectArray[2] = "sweep";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface Generator<T> {
        public boolean processAllInStartOffsetOrder(@NotNull Processor<? super T> var1);
    }
}

