/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.model.psi.impl.ReferenceProviders;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class PsiSymbolReferenceServiceImpl
implements PsiSymbolReferenceService {
    private static final PsiSymbolReferenceHints EMPTY_HINTS = new PsiSymbolReferenceHints(){};
    private static final Key<ParameterizedCachedValue<Collection<? extends PsiSymbolReference>, PsiElement>> OWN_REFERENCES_KEY = Key.create("PsiSymbolReferenceService.OWN_REFERENCES");
    private static final ParameterizedCachedValueProvider<Collection<? extends PsiSymbolReference>, PsiElement> OWN_REFERENCES_PROVIDER = element -> {
        Collection<? extends @NotNull PsiSymbolReference> references = element.getOwnReferences();
        return CachedValueProvider.Result.create(references, PsiModificationTracker.MODIFICATION_COUNT);
    };

    PsiSymbolReferenceServiceImpl() {
    }

    @Override
    @NotNull
    public @NotNull Collection<? extends @NotNull PsiSymbolReference> getReferences(@NotNull PsiElement element) {
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(0);
        }
        Collection collection = this.getReferences(element, EMPTY_HINTS);
        if (collection == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    @NotNull
    public <T extends PsiSymbolReference> Collection<T> getReferences(@NotNull PsiElement host, @NotNull Class<T> referenceClass) {
        if (host == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(2);
        }
        if (referenceClass == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(3);
        }
        Collection collection = this.getReferences(host, PsiSymbolReferenceHints.referenceClassHint(referenceClass));
        if (collection == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public @NotNull List<@NotNull PsiSymbolReference> getReferences(@NotNull PsiElement element, @NotNull PsiSymbolReferenceHints hints) {
        ArrayList<PsiSymbolReference> result;
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(5);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(6);
        }
        if ((result = new ArrayList<PsiSymbolReference>(PsiSymbolReferenceServiceImpl.doGetOwnReferences(element))).isEmpty() && element instanceof PsiExternalReferenceHost) {
            result.addAll(PsiSymbolReferenceServiceImpl.doGetExternalReferences((PsiExternalReferenceHost)element, hints));
        }
        List<PsiSymbolReference> list = Collections.unmodifiableList(PsiSymbolReferenceServiceImpl.applyHints(result, hints));
        if (list == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<? extends PsiSymbolReference> getExternalReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(8);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(9);
        }
        return PsiSymbolReferenceServiceImpl.applyHints(PsiSymbolReferenceServiceImpl.doGetExternalReferences(element, hints), hints);
    }

    @NotNull
    private static Collection<? extends PsiSymbolReference> doGetOwnReferences(@NotNull PsiElement element) {
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(10);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager(element.getProject());
        Collection<? extends PsiSymbolReference> collection = cachedValuesManager.getParameterizedCachedValue(element, OWN_REFERENCES_KEY, OWN_REFERENCES_PROVIDER, false, element);
        if (collection == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    private static List<PsiSymbolReference> doGetExternalReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        if (element == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(12);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(13);
        }
        Supplier<List> supplier = () -> {
            List<PsiSymbolReferenceProviderBean> beans = ReferenceProviders.byLanguage(element.getLanguage()).byHostClass(element.getClass());
            if (beans.isEmpty()) {
                return Collections.emptyList();
            }
            Class<? extends PsiSymbolReference> requiredReferenceClass = hints.getReferenceClass();
            SmartList<? extends PsiSymbolReference> result = new SmartList<PsiSymbolReference>();
            for (PsiSymbolReferenceProviderBean bean : beans) {
                if (requiredReferenceClass != PsiSymbolReference.class && !bean.anyReferenceClass && !requiredReferenceClass.isAssignableFrom(bean.getReferenceClass())) continue;
                result.addAll(((PsiSymbolReferenceProvider)bean.getInstance()).getReferences(element, hints));
            }
            return Collections.unmodifiableList(result);
        };
        if (hints == EMPTY_HINTS) {
            List list = (List)CachedValuesManager.getCachedValue(element, () -> CachedValueProvider.Result.create((List)supplier.get(), PsiModificationTracker.MODIFICATION_COUNT));
            if (list == null) {
                PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = supplier.get();
        if (list == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static @NotNull List<@NotNull PsiSymbolReference> applyHints(@NotNull List<PsiSymbolReference> references, @NotNull PsiSymbolReferenceHints hints) {
        int offsetInElement;
        if (references == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(16);
        }
        if (hints == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(17);
        }
        if (hints == EMPTY_HINTS || references.isEmpty()) {
            List<PsiSymbolReference> list = references;
            if (list == null) {
                PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<@NotNull PsiSymbolReference> result = references;
        Class<? extends PsiSymbolReference> referenceClass = hints.getReferenceClass();
        if (referenceClass != PsiSymbolReference.class) {
            result = ContainerUtil.filterIsInstance(result, referenceClass);
        }
        if ((offsetInElement = hints.getOffsetInElement()) >= 0) {
            result = ContainerUtil.filter(result, reference -> reference.getRangeInElement().containsOffset(offsetInElement));
        }
        List<PsiSymbolReference> list = result;
        if (list == null) {
            PsiSymbolReferenceServiceImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/psi/impl/PsiSymbolReferenceServiceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceClass";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/psi/impl/PsiSymbolReferenceServiceImpl";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetOwnReferences";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetExternalReferences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "applyHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExternalReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetOwnReferences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGetExternalReferences";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyHints";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

