/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl.modcommand;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.options.LocMessage;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptControl;
import com.intellij.codeInspection.options.OptNumber;
import com.intellij.codeInspection.options.OptString;
import com.intellij.codeInspection.options.OptStringList;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.OptionControllerProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.FutureVirtualFile;
import com.intellij.modcommand.ModChooseAction;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.modcommand.ModCompositeCommand;
import com.intellij.modcommand.ModCopyToClipboard;
import com.intellij.modcommand.ModCreateFile;
import com.intellij.modcommand.ModDeleteFile;
import com.intellij.modcommand.ModDisplayMessage;
import com.intellij.modcommand.ModEditOptions;
import com.intellij.modcommand.ModHighlight;
import com.intellij.modcommand.ModMoveFile;
import com.intellij.modcommand.ModNavigate;
import com.intellij.modcommand.ModOpenUrl;
import com.intellij.modcommand.ModShowConflicts;
import com.intellij.modcommand.ModStartRename;
import com.intellij.modcommand.ModStartTemplate;
import com.intellij.modcommand.ModUpdateFileText;
import com.intellij.modcommand.ModUpdateReferences;
import com.intellij.modcommand.ModUpdateSystemOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class ModCommandBatchExecutorImpl
implements ModCommandExecutor {
    @Override
    public void executeInteractively(@NotNull ActionContext context, @NotNull ModCommand command2, @Nullable Editor editor) {
        ModCommandExecutor.BatchExecutionResult result;
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(0);
        }
        if (command2 == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(1);
        }
        if ((result = this.executeInBatch(context, command2)) == ModCommandExecutor.Result.INTERACTIVE || result == ModCommandExecutor.Result.CONFLICTS) {
            throw new UnsupportedOperationException(result.getMessage());
        }
        if (result instanceof ModCommandExecutor.Error) {
            ModCommandExecutor.Error error = (ModCommandExecutor.Error)result;
            throw new RuntimeException(error.getMessage());
        }
    }

    @Override
    @NotNull
    public ModCommandExecutor.BatchExecutionResult executeInBatch(@NotNull ActionContext context, @NotNull ModCommand command2) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(2);
        }
        if (command2 == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(3);
        }
        if (!ModCommandBatchExecutorImpl.ensureWritable(context.project(), command2)) {
            return new ModCommandExecutor.Error(AnalysisBundle.message("modcommand.executor.error.files.are.marked.as.readonly", new Object[0]));
        }
        ModCommandExecutor.BatchExecutionResult batchExecutionResult = this.doExecuteInBatch(context, command2);
        if (batchExecutionResult == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(4);
        }
        return batchExecutionResult;
    }

    private ModCommandExecutor.BatchExecutionResult doExecuteInBatch(@NotNull ActionContext context, @NotNull ModCommand command2) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(5);
        }
        if (command2 == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(6);
        }
        Project project = context.project();
        if (command2.isEmpty()) {
            return ModCommandExecutor.Result.NOTHING;
        }
        if (command2 instanceof ModUpdateFileText) {
            ModUpdateFileText upd = (ModUpdateFileText)command2;
            return this.executeUpdate(project, upd) ? ModCommandExecutor.Result.SUCCESS : ModCommandExecutor.Result.ABORT;
        }
        if (command2 instanceof ModCreateFile) {
            ModCreateFile create2 = (ModCreateFile)command2;
            String message = this.executeCreate(project, create2);
            return message == null ? ModCommandExecutor.Result.SUCCESS : new ModCommandExecutor.Error(message);
        }
        if (command2 instanceof ModDeleteFile) {
            ModDeleteFile deleteFile = (ModDeleteFile)command2;
            String message = this.executeDelete(deleteFile);
            return message == null ? ModCommandExecutor.Result.SUCCESS : new ModCommandExecutor.Error(message);
        }
        if (command2 instanceof ModMoveFile) {
            ModMoveFile moveFile = (ModMoveFile)command2;
            String message = this.executeMove(moveFile);
            return message == null ? ModCommandExecutor.Result.SUCCESS : new ModCommandExecutor.Error(message);
        }
        if (command2 instanceof ModCompositeCommand) {
            ModCommand subCommand;
            ModCompositeCommand cmp = (ModCompositeCommand)command2;
            ModCommandExecutor.BatchExecutionResult result = ModCommandExecutor.Result.NOTHING;
            Iterator<ModCommand> iterator2 = cmp.commands().iterator();
            while (iterator2.hasNext() && (result = result.compose(this.doExecuteInBatch(context, subCommand = iterator2.next()))) != ModCommandExecutor.Result.ABORT && !(result instanceof ModCommandExecutor.Error)) {
            }
            return result;
        }
        if (command2 instanceof ModChooseAction) {
            ModChooseAction chooser = (ModChooseAction)command2;
            return this.executeChooseInBatch(context, chooser);
        }
        if (command2 instanceof ModNavigate || command2 instanceof ModHighlight || command2 instanceof ModCopyToClipboard || command2 instanceof ModStartRename || command2 instanceof ModStartTemplate || command2 instanceof ModUpdateSystemOptions || command2 instanceof ModUpdateReferences || command2 instanceof ModOpenUrl) {
            return ModCommandExecutor.Result.INTERACTIVE;
        }
        if (command2 instanceof ModShowConflicts) {
            return ModCommandExecutor.Result.CONFLICTS;
        }
        if (command2 instanceof ModEditOptions) {
            ModEditOptions editOptions = (ModEditOptions)command2;
            return this.bypassEditOptions(editOptions, context);
        }
        if (command2 instanceof ModDisplayMessage) {
            ModDisplayMessage message = (ModDisplayMessage)command2;
            if (message.kind() == ModDisplayMessage.MessageKind.ERROR) {
                return new ModCommandExecutor.Error(message.messageText());
            }
            return ModCommandExecutor.Result.INTERACTIVE;
        }
        throw new IllegalArgumentException("Unknown command: " + String.valueOf(command2));
    }

    private <T extends OptionContainer> ModCommandExecutor.BatchExecutionResult bypassEditOptions(@NotNull ModEditOptions<T> options, @NotNull ActionContext context) {
        if (options == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(8);
        }
        if (!options.canUseDefaults()) {
            return ModCommandExecutor.Result.INTERACTIVE;
        }
        return this.doExecuteInBatch(context, options.nextCommand().apply(options.containerSupplier().get()));
    }

    private ModCommandExecutor.BatchExecutionResult executeChooseInBatch(@NotNull ActionContext context, ModChooseAction chooser) {
        ModCommandAction action2;
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(9);
        }
        if ((action2 = (ModCommandAction)((StreamEx)StreamEx.of(chooser.actions()).filter(act -> act.getPresentation(context) != null)).findFirst().orElse(null)) == null) {
            return ModCommandExecutor.Result.NOTHING;
        }
        String name = chooser.title();
        ModCommand next = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.nonBlocking(() -> {
            if (action2.getPresentation(context) == null) {
                return null;
            }
            return action2.perform(context);
        }).executeSynchronously(), name, true, context.project());
        if (next == null) {
            return ModCommandExecutor.Result.ABORT;
        }
        return this.executeInBatch(context, next);
    }

    @Nls
    protected String executeDelete(@NotNull ModDeleteFile file) {
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(10);
        }
        try {
            WriteAction.run(() -> file.file().delete(this));
            return null;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    @Nls
    protected String executeMove(@NotNull ModMoveFile file) {
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(11);
        }
        VirtualFile source = ModCommandBatchExecutorImpl.actualize(file.file());
        FutureVirtualFile target = file.targetFile();
        VirtualFile parent = ModCommandBatchExecutorImpl.actualize(target.getParent());
        return WriteAction.compute(() -> {
            VirtualFile origParent = source.getParent();
            if (parent != null && !parent.equals(origParent)) {
                try {
                    source.move(this, parent);
                }
                catch (IOException e) {
                    return AnalysisBundle.message("modcommand.executor.cannot.move.file", source.getPath(), parent.getPath(), e.getLocalizedMessage());
                }
            }
            if (!target.getName().equals(source.getName())) {
                try {
                    source.rename(this, target.getName());
                }
                catch (IOException e) {
                    if (origParent != null && !origParent.equals(parent)) {
                        try {
                            source.move(this, origParent);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return AnalysisBundle.message("modcommand.executor.cannot.rename.file", source.getPath(), target.getName(), e.getLocalizedMessage());
                }
            }
            return null;
        });
    }

    @Nls
    protected String executeCreate(@NotNull Project project, @NotNull ModCreateFile create2) {
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(12);
        }
        if (create2 == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(13);
        }
        FutureVirtualFile file = create2.file();
        VirtualFile parent = ModCommandBatchExecutorImpl.actualize(file.getParent());
        try {
            return WriteAction.compute(() -> {
                if (create2.content() instanceof ModCreateFile.Directory) {
                    parent.createChildDirectory(this, file.getName());
                    return null;
                }
                VirtualFile newFile = parent.createChildData(this, file.getName());
                ModCreateFile.Content patt8416$temp = create2.content();
                if (patt8416$temp instanceof ModCreateFile.Text) {
                    ModCreateFile.Text text = (ModCreateFile.Text)patt8416$temp;
                    PsiFile psiFile = PsiManager.getInstance(project).findFile(newFile);
                    if (psiFile == null) {
                        return AnalysisBundle.message("modcommand.executor.unable.to.find.the.new.file", file.getName());
                    }
                    Document document = psiFile.getViewProvider().getDocument();
                    document.setText(text.text());
                    PsiDocumentManager.getInstance(project).commitDocument(document);
                } else {
                    ModCreateFile.Content patt8894$temp = create2.content();
                    if (patt8894$temp instanceof ModCreateFile.Binary) {
                        ModCreateFile.Binary binary = (ModCreateFile.Binary)patt8894$temp;
                        newFile.setBinaryContent(binary.bytes());
                    }
                }
                return null;
            });
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    @Override
    public void executeForFileCopy(@NotNull ModCommand command2, @NotNull PsiFile file) {
        if (command2 == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(14);
        }
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(15);
        }
        for (ModCommand cmd : command2.unpack()) {
            if (cmd instanceof ModUpdateFileText) {
                ModUpdateFileText updateFileText = (ModUpdateFileText)cmd;
                if (!updateFileText.file().equals(file.getOriginalFile().getVirtualFile())) {
                    throw new UnsupportedOperationException("The command updates non-current file");
                }
                this.updateText(file.getProject(), file.getViewProvider().getDocument(), updateFileText);
                continue;
            }
            if (cmd instanceof ModNavigate || cmd instanceof ModHighlight) continue;
            throw new UnsupportedOperationException("Unexpected command: " + String.valueOf(command2));
        }
    }

    protected static boolean ensureWritable(@NotNull Project project, @NotNull ModCommand command2) {
        List<VirtualFile> files;
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(16);
        }
        if (command2 == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(17);
        }
        return (files = ContainerUtil.filter(command2.modifiedFiles(), f -> !(f instanceof LightVirtualFile))).isEmpty() || ReadonlyStatusHandler.ensureFilesWritable(project, files.toArray(VirtualFile.EMPTY_ARRAY));
    }

    protected static VirtualFile actualize(@NotNull VirtualFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(18);
        }
        if (file instanceof FutureVirtualFile) {
            FutureVirtualFile future = (FutureVirtualFile)file;
            virtualFile = ModCommandBatchExecutorImpl.actualize(future.getParent()).findChild(future.getName());
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    private void updateText(@NotNull Project project, @NotNull Document document, @NotNull ModUpdateFileText upd) throws IllegalStateException {
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(19);
        }
        if (document == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(20);
        }
        if (upd == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(21);
        }
        String oldText = upd.oldText();
        if (!document.getText().equals(oldText)) {
            throw new IllegalStateException("Old text doesn't match");
        }
        List<@NotNull ModUpdateFileText.Fragment> ranges = this.calculateRanges(upd);
        PsiDocumentManager manager = PsiDocumentManager.getInstance(project);
        ModCommandBatchExecutorImpl.applyRanges(document, ranges, upd.newText());
        manager.commitDocument(document);
    }

    protected boolean executeUpdate(@NotNull Project project, @NotNull ModUpdateFileText upd) {
        if (project == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(22);
        }
        if (upd == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(23);
        }
        VirtualFile file = upd.file();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        String oldText = upd.oldText();
        if (!document.getText().equals(oldText)) {
            return false;
        }
        List<@NotNull ModUpdateFileText.Fragment> ranges = this.calculateRanges(upd);
        return WriteAction.compute(() -> {
            ModCommandBatchExecutorImpl.applyRanges(document, ranges, upd.newText());
            PsiDocumentManager.getInstance(project).commitDocument(document);
            return true;
        });
    }

    private static void applyRanges(@NotNull Document document, List<@NotNull ModUpdateFileText.Fragment> ranges, String newText) {
        if (document == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(24);
        }
        for (ModUpdateFileText.Fragment range : ranges) {
            document.replaceString(range.offset(), range.offset() + range.oldLength(), newText.substring(range.offset(), range.offset() + range.newLength()));
        }
    }

    @NotNull
    protected @Unmodifiable @NotNull List<@NotNull ModUpdateFileText.Fragment> calculateRanges(@NotNull ModUpdateFileText upd) {
        if (upd == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(25);
        }
        List<ModUpdateFileText.Fragment> list = List.of(new ModUpdateFileText.Fragment(0, upd.oldText().length(), upd.newText().length()));
        if (list == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo getPreview(@NotNull ModCommand modCommand, @NotNull ActionContext context) {
        if (modCommand == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(27);
        }
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(28);
        }
        Project project = context.project();
        PsiFile file = context.file();
        ArrayList<IntentionPreviewInfo.CustomDiff> customDiffList = new ArrayList<IntentionPreviewInfo.CustomDiff>();
        IntentionPreviewInfo navigateInfo = IntentionPreviewInfo.EMPTY;
        ArrayList<@NlsSafe String> createdDirs = new ArrayList<String>();
        ArrayList<HtmlChunk> fsActions = new ArrayList<HtmlChunk>();
        for (ModCommand command2 : modCommand.unpack()) {
            ModNavigate navigate;
            VirtualFile vFile;
            if (command2 instanceof ModUpdateFileText) {
                ModUpdateFileText modFile = (ModUpdateFileText)command2;
                vFile = modFile.file();
                boolean currentFile = vFile.equals(file.getOriginalFile().getVirtualFile()) || vFile.equals(InjectedLanguageManager.getInstance(project).getTopLevelFile(file).getOriginalFile().getVirtualFile());
                customDiffList.add(new IntentionPreviewInfo.CustomDiff(vFile.getFileType(), currentFile ? null : this.getFileNamePresentation(project, vFile), modFile.oldText(), modFile.newText(), true));
                continue;
            }
            if (command2 instanceof ModCreateFile) {
                String string;
                ModCreateFile createFile = (ModCreateFile)command2;
                vFile = createFile.file();
                if (createFile.content() instanceof ModCreateFile.Directory) {
                    createdDirs.add(this.getFileNamePresentation(project, vFile));
                    continue;
                }
                ModCreateFile.Content content = createFile.content();
                if (content instanceof ModCreateFile.Text) {
                    ModCreateFile.Text text2 = (ModCreateFile.Text)content;
                    string = text2.text();
                } else {
                    string = AnalysisBundle.message("preview.binary.content", new Object[0]);
                }
                String content2 = string;
                customDiffList.add(new IntentionPreviewInfo.CustomDiff(vFile.getFileType(), this.getFileNamePresentation(project, vFile), "", content2, true));
                continue;
            }
            if (command2 instanceof ModNavigate && (navigate = (ModNavigate)command2).caret() != -1) {
                PsiFile target;
                VirtualFile virtualFile = navigate.file();
                if (!virtualFile.isValid() || (target = PsiManager.getInstance(project).findFile(virtualFile)) == null) continue;
                navigateInfo = IntentionPreviewInfo.navigate(target, navigate.caret());
                continue;
            }
            if (command2 instanceof ModChooseAction) {
                ModChooseAction target = (ModChooseAction)command2;
                return ModCommandBatchExecutorImpl.getChoosePreview(context, target);
            }
            if (command2 instanceof ModEditOptions) {
                ModEditOptions target = (ModEditOptions)command2;
                return this.getEditOptionsPreview(context, target);
            }
            if (command2 instanceof ModDisplayMessage) {
                ModDisplayMessage message = (ModDisplayMessage)command2;
                if (message.kind() == ModDisplayMessage.MessageKind.ERROR) {
                    return new IntentionPreviewInfo.Html(new HtmlBuilder().append(AnalysisBundle.message("preview.cannot.perform.action", new Object[0])).br().append(message.messageText()).toFragment(), IntentionPreviewInfo.InfoKind.ERROR);
                }
                if (navigateInfo != IntentionPreviewInfo.EMPTY) continue;
                navigateInfo = new IntentionPreviewInfo.Html(message.messageText());
                continue;
            }
            if (command2 instanceof ModCopyToClipboard) {
                ModCopyToClipboard copy = (ModCopyToClipboard)command2;
                navigateInfo = new IntentionPreviewInfo.Html(HtmlChunk.text(AnalysisBundle.message("preview.copy.to.clipboard", StringUtil.shortenTextWithEllipsis(copy.content(), 50, 10))));
                continue;
            }
            if (command2 instanceof ModOpenUrl) {
                ModOpenUrl openUrl = (ModOpenUrl)command2;
                navigateInfo = new IntentionPreviewInfo.Html(HtmlChunk.text(AnalysisBundle.message("preview.open.url", StringUtil.shortenTextWithEllipsis(openUrl.url(), 50, 10))));
                continue;
            }
            if (command2 instanceof ModMoveFile) {
                ModMoveFile moveFile = (ModMoveFile)command2;
                FutureVirtualFile targetFile = moveFile.targetFile();
                IntentionPreviewInfo.Html html = targetFile.getName().equals(moveFile.file().getName()) ? (IntentionPreviewInfo.Html)IntentionPreviewInfo.moveToDirectory(moveFile.file(), targetFile.getParent()) : (IntentionPreviewInfo.Html)IntentionPreviewInfo.rename(moveFile.file(), targetFile.getName());
                fsActions.add(html.content());
                continue;
            }
            if (!(command2 instanceof ModUpdateSystemOptions)) continue;
            ModUpdateSystemOptions options = (ModUpdateSystemOptions)command2;
            HtmlChunk preview = ModCommandBatchExecutorImpl.createOptionsPreview(context, options);
            navigateInfo = preview.isEmpty() ? IntentionPreviewInfo.EMPTY : new IntentionPreviewInfo.Html(preview);
        }
        customDiffList.sort(Comparator.comparing(diff -> diff.fileName() != null));
        if (customDiffList.isEmpty()) {
            HtmlBuilder builder = new HtmlBuilder();
            if (!createdDirs.isEmpty()) {
                if (createdDirs.size() == 1) {
                    builder.append(AnalysisBundle.message("preview.create.directory", createdDirs.get(0))).br();
                } else {
                    builder.append(HtmlChunk.tag("p").addText(AnalysisBundle.message("preview.create.directories", new Object[0])).children(ContainerUtil.map(createdDirs, text -> new HtmlBuilder().br().appendRaw("&bull; ").append((String)text).toFragment())));
                }
            }
            if (!fsActions.isEmpty()) {
                if (!builder.isEmpty()) {
                    builder.br();
                }
                fsActions.forEach(builder::append);
            }
            if (!builder.isEmpty()) {
                return new IntentionPreviewInfo.Html(builder.toFragment());
            }
            IntentionPreviewInfo intentionPreviewInfo = navigateInfo;
            if (intentionPreviewInfo == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(29);
            }
            return intentionPreviewInfo;
        }
        return customDiffList.size() == 1 ? (IntentionPreviewInfo)customDiffList.get(0) : new IntentionPreviewInfo.MultiFileDiff(customDiffList);
    }

    @NotNull
    private <T extends OptionContainer> IntentionPreviewInfo getEditOptionsPreview(@NotNull ActionContext context, @NotNull ModEditOptions<T> target) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(30);
        }
        if (target == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(31);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.getPreview(target.nextCommand().apply(target.containerSupplier().get()), context);
        if (intentionPreviewInfo == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(32);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    protected String getFileNamePresentation(Project project, VirtualFile file) {
        VirtualFile virtualFile;
        StringBuilder presentation = new StringBuilder(file.getName());
        while ((virtualFile = file.getParent()) instanceof FutureVirtualFile) {
            FutureVirtualFile parent = (FutureVirtualFile)virtualFile;
            presentation.insert(0, parent.getName() + "/");
            file = parent;
        }
        String string = presentation.toString();
        if (string == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static IntentionPreviewInfo getChoosePreview(@NotNull ActionContext context, @NotNull ModChooseAction target) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(34);
        }
        if (target == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(35);
        }
        IntentionPreviewInfo intentionPreviewInfo = target.actions().stream().filter(action2 -> action2.getPresentation(context) != null).findFirst().map(action2 -> action2.generatePreview(context)).orElse(IntentionPreviewInfo.EMPTY);
        if (intentionPreviewInfo == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(36);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    private static HtmlChunk createOptionsPreview(@NotNull ActionContext context, @NotNull ModUpdateSystemOptions options) {
        if (context == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(37);
        }
        if (options == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(38);
        }
        HtmlBuilder builder = new HtmlBuilder();
        for (ModUpdateSystemOptions.ModifiedOption option : options.options()) {
            builder.append(ModCommandBatchExecutorImpl.createOptionPreview(context.file(), option));
        }
        HtmlChunk htmlChunk = builder.toFragment();
        if (htmlChunk == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(39);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk createOptionPreview(@NotNull PsiFile file, @NotNull ModUpdateSystemOptions.ModifiedOption option) {
        OptionController controller;
        OptionController.OptionControlInfo controlInfo;
        if (file == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(40);
        }
        if (option == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(41);
        }
        if ((controlInfo = (controller = OptionControllerProvider.rootController(file)).findControl(option.bindId())) == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(42);
            }
            return htmlChunk;
        }
        OptControl control = controlInfo.control();
        Object newValue = option.newValue();
        if (newValue instanceof Boolean) {
            Boolean value2 = (Boolean)newValue;
            OptCheckbox optCheckBox = ObjectUtils.tryCast(control, OptCheckbox.class);
            if (optCheckBox == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(43);
                }
                return htmlChunk;
            }
            HtmlChunk label = HtmlChunk.text(optCheckBox.label().label());
            HtmlChunk.Element checkbox = HtmlChunk.tag("input").attr("type", "checkbox").attr("readonly", "true");
            if (value2.booleanValue()) {
                checkbox = checkbox.attr("checked", "true");
            }
            HtmlChunk.Element info = HtmlChunk.tag("table").child(HtmlChunk.tag("tr").children(HtmlChunk.tag("td").child(checkbox), HtmlChunk.tag("td").child(label)));
            HtmlChunk htmlChunk = new HtmlBuilder().append(value2 != false ? AnalysisBundle.message("set.option.description.check", new Object[0]) : AnalysisBundle.message("set.option.description.uncheck", new Object[0])).br().br().append(info).toFragment();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(44);
            }
            return htmlChunk;
        }
        if (newValue instanceof Integer) {
            Integer value3 = (Integer)newValue;
            OptNumber optNumber = ObjectUtils.tryCast(control, OptNumber.class);
            if (optNumber == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(45);
                }
                return htmlChunk;
            }
            LocMessage.PrefixSuffix prefixSuffix = optNumber.splitLabel().splitLabel();
            HtmlChunk info = ModCommandBatchExecutorImpl.getValueChunk(value3, prefixSuffix);
            HtmlChunk htmlChunk = new HtmlBuilder().append(AnalysisBundle.message("set.option.description.input", new Object[0])).br().br().append(info).br().toFragment();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(46);
            }
            return htmlChunk;
        }
        if (newValue instanceof String) {
            String value4 = (String)newValue;
            OptString optString = ObjectUtils.tryCast(control, OptString.class);
            if (optString == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(47);
                }
                return htmlChunk;
            }
            LocMessage.PrefixSuffix prefixSuffix = optString.splitLabel().splitLabel();
            HtmlChunk info = ModCommandBatchExecutorImpl.getValueChunk(value4, prefixSuffix);
            HtmlChunk htmlChunk = new HtmlBuilder().append(AnalysisBundle.message("set.option.description.string", new Object[0])).br().br().append(info).br().toFragment();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(48);
            }
            return htmlChunk;
        }
        if (newValue instanceof List) {
            List list = (List)newValue;
            OptStringList optList = ObjectUtils.tryCast(control, OptStringList.class);
            if (optList == null) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    ModCommandBatchExecutorImpl.$$$reportNull$$$0(49);
                }
                return htmlChunk;
            }
            List oldList = (List)option.oldValue();
            HtmlChunk htmlChunk = IntentionPreviewInfo.addListOption((List<String>)list, optList.label().label(), value -> !oldList.contains(value)).content();
            if (htmlChunk == null) {
                ModCommandBatchExecutorImpl.$$$reportNull$$$0(50);
            }
            return htmlChunk;
        }
        if (newValue == null) {
            throw new IllegalStateException("Null value is not supported");
        }
        throw new IllegalStateException("Value of type " + String.valueOf(newValue.getClass()) + " is not supported");
    }

    @NotNull
    private static HtmlChunk getValueChunk(Object value, LocMessage.PrefixSuffix prefixSuffix) {
        HtmlChunk.Element input = HtmlChunk.tag("input").attr("type", "text").attr("value", String.valueOf(value)).attr("size", value.toString().length() + 1).attr("readonly", "true");
        HtmlChunk.Element element = HtmlChunk.tag("table").child(HtmlChunk.tag("tr").children(HtmlChunk.tag("td").child(HtmlChunk.text(prefixSuffix.prefix())), HtmlChunk.tag("td").child(input), HtmlChunk.tag("td").child(HtmlChunk.text(prefixSuffix.suffix()))));
        if (element == null) {
            ModCommandBatchExecutorImpl.$$$reportNull$$$0(51);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 26, 29, 32, 33, 36, 39, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/impl/modcommand/ModCommandBatchExecutorImpl";
                break;
            }
            case 7: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "create";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upd";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modCommand";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/impl/modcommand/ModCommandBatchExecutorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInBatch";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateRanges";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreview";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditOptionsPreview";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNamePresentation";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getChoosePreview";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPreview";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionPreview";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeInteractively";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "executeInBatch";
                break;
            }
            case 4: 
            case 26: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteInBatch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bypassEditOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeChooseInBatch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeCreate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeForFileCopy";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ensureWritable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "actualize";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdate";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyRanges";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculateRanges";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPreview";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getEditOptionsPreview";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getChoosePreview";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsPreview";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createOptionPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 26, 29, 32, 33, 36, 39, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51 -> new IllegalStateException(string);
        };
    }
}

