/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import kotlin.Metadata;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/plugins/UntilBuildDeprecation;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MINIMAL_API_VERSION", "", "forceHonorUntilBuild", "", "getForceHonorUntilBuild", "()Z", "nullizeIfTargets243OrLater", "", "untilBuild", "diagnosticId", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class UntilBuildDeprecation {
    @NotNull
    public static final UntilBuildDeprecation INSTANCE = new UntilBuildDeprecation();
    private static final int MINIMAL_API_VERSION = 252;
    private static final boolean forceHonorUntilBuild = Boolean.parseBoolean(System.getProperty("idea.plugins.honor.until.build", "true"));

    private UntilBuildDeprecation() {
    }

    private final Logger getLOG() {
        return PluginManagerCore.getLogger();
    }

    public final boolean getForceHonorUntilBuild() {
        return forceHonorUntilBuild;
    }

    @Nullable
    public final String nullizeIfTargets243OrLater(@Nullable String untilBuild, @Nullable String diagnosticId) {
        if (forceHonorUntilBuild || untilBuild == null) {
            return untilBuild;
        }
        try {
            BuildNumber untilBuildNumber = BuildNumber.fromStringOrNull(untilBuild);
            if (untilBuildNumber != null && untilBuildNumber.getBaselineVersion() >= 252) {
                if (untilBuildNumber.compareTo(PluginManagerCore.getBuildNumber()) < 0) {
                    Logger logger = this.getLOG();
                    StringBuilder stringBuilder = new StringBuilder().append("Plugin ");
                    String string = diagnosticId;
                    if (string == null) {
                        string = "<no name>";
                    }
                    logger.info(stringBuilder.append(string).append(" has until-build set to ").append(untilBuild).append(". Until-build _from plugin configuration file (plugin.xml)_ for plugins targeting 252+ is ignored. Effective until-build value can be set via the Marketplace.").toString());
                }
                return null;
            }
        }
        catch (Throwable e) {
            this.getLOG().warn("failed to parse until-build number", e);
        }
        return untilBuild;
    }
}

