/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0007\u001a8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0007\u001a8\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0007\u001a8\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0007\u00a8\u0006\u0012"}, d2={"getPluginDistDirByClass", "Ljava/nio/file/Path;", "aClass", "Ljava/lang/Class;", "pluginRequiresUltimatePluginButItsDisabled", "", "plugin", "Lcom/intellij/openapi/extensions/PluginId;", "rootPlugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "pluginMap", "", "contentModuleIdMap", "", "Lcom/intellij/ide/plugins/ContentModuleDescriptor;", "pluginRequiresUltimatePlugin", "contentModuleMap", "rootDescriptor", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nPluginManagerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCoreKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1017:1\n1#2:1018\n*E\n"})
public final class PluginManagerCoreKt {
    @ApiStatus.Internal
    @Nullable
    public static final Path getPluginDistDirByClass(@NotNull Class<?> aClass) {
        Path pluginDir;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        Object object = aClass.getClassLoader();
        Object object2 = object instanceof PluginClassLoader ? (PluginClassLoader)object : null;
        Path path = object2 != null && (object2 = ((PluginClassLoader)object2).getPluginDescriptor()) != null ? object2.getPluginPath() : (pluginDir = null);
        if (pluginDir != null) {
            return pluginDir;
        }
        Path path2 = PathManager.getJarForClass(aClass);
        if (path2 == null) {
            throw new IllegalStateException(("Can't find plugin dist home for " + aClass.getSimpleName()).toString());
        }
        Path jarInsideLib = path2;
        if (StringsKt.endsWith((String)((Object)jarInsideLib.getFileName()).toString(), (String)"jar", (boolean)true)) {
            String string = PathManager.getArchivedCompliedClassesLocation();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (jarInsideLib.startsWith(it)) {
                    return null;
                }
            }
            Object it = object = jarInsideLib.getParent();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)"lib")) {
                boolean bl2 = false;
                String string2 = it + " should be lib directory";
                throw new IllegalStateException(string2.toString());
            }
            return object.getParent();
        }
        return null;
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePluginButItsDisabled(@NotNull PluginId plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.INSTANCE.buildPluginIdMap();
        Map<String, ContentModuleDescriptor> contentModuleIdMap = PluginManagerCore.getPluginSet().buildContentModuleIdMap();
        return PluginManagerCoreKt.pluginRequiresUltimatePluginButItsDisabled(plugin, idMap, contentModuleIdMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePluginButItsDisabled(@NotNull IdeaPluginDescriptorImpl rootPlugin, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<String, ContentModuleDescriptor> contentModuleIdMap) {
        Intrinsics.checkNotNullParameter((Object)rootPlugin, (String)"rootPlugin");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleIdMap, (String)"contentModuleIdMap");
        if (!PluginManagerCore.isDisabled(PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            return false;
        }
        return PluginManagerCoreKt.pluginRequiresUltimatePlugin(rootPlugin, pluginMap, contentModuleIdMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePluginButItsDisabled(@NotNull PluginId plugin, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<String, ContentModuleDescriptor> contentModuleIdMap) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleIdMap, (String)"contentModuleIdMap");
        if (!PluginManagerCore.isDisabled(PluginManagerCore.ULTIMATE_PLUGIN_ID)) {
            return false;
        }
        return PluginManagerCoreKt.pluginRequiresUltimatePlugin(plugin, pluginMap, contentModuleIdMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePlugin(@NotNull PluginId plugin, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<String, ContentModuleDescriptor> contentModuleMap) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleMap, (String)"contentModuleMap");
        IdeaPluginDescriptorImpl rootDescriptor = pluginMap.get(plugin);
        if (rootDescriptor == null) {
            return false;
        }
        return PluginManagerCoreKt.pluginRequiresUltimatePlugin(rootDescriptor, pluginMap, contentModuleMap);
    }

    @ApiStatus.Internal
    public static final boolean pluginRequiresUltimatePlugin(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, ? extends IdeaPluginDescriptorImpl> pluginMap, @NotNull Map<String, ContentModuleDescriptor> contentModuleMap) {
        Intrinsics.checkNotNullParameter((Object)rootDescriptor, (String)"rootDescriptor");
        Intrinsics.checkNotNullParameter(pluginMap, (String)"pluginMap");
        Intrinsics.checkNotNullParameter(contentModuleMap, (String)"contentModuleMap");
        return !PluginManagerCore.INSTANCE.processAllNonOptionalDependencies(rootDescriptor, pluginMap, contentModuleMap, (Function1<? super IdeaPluginDescriptorImpl, ? extends FileVisitResult>)((Function1)PluginManagerCoreKt::pluginRequiresUltimatePlugin$lambda$3));
    }

    private static final FileVisitResult pluginRequiresUltimatePlugin$lambda$3(IdeaPluginDescriptorImpl descriptorImpl) {
        Intrinsics.checkNotNullParameter((Object)descriptorImpl, (String)"descriptorImpl");
        return Intrinsics.areEqual((Object)descriptorImpl.getPluginId(), (Object)PluginManagerCore.ULTIMATE_PLUGIN_ID) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }
}

