/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.openapi.extensions.PluginId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0019\u0010\u0018\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/plugins/PluginDependencyIsDisabled;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "dependencyId", "Lcom/intellij/openapi/extensions/PluginId;", "shouldNotifyUser", "", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Lcom/intellij/openapi/extensions/PluginId;Z)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getDependencyId", "()Lcom/intellij/openapi/extensions/PluginId;", "getShouldNotifyUser", "()Z", "detailedMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "()Ljava/lang/String;", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginDependencyIsDisabled
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    @NotNull
    private final PluginId dependencyId;
    private final boolean shouldNotifyUser;

    public PluginDependencyIsDisabled(@NotNull IdeaPluginDescriptor plugin, @NotNull PluginId dependencyId, boolean shouldNotifyUser) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)dependencyId, (String)"dependencyId");
        this.plugin = plugin;
        this.dependencyId = dependencyId;
        this.shouldNotifyUser = shouldNotifyUser;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final PluginId getDependencyId() {
        return this.dependencyId;
    }

    @Override
    public boolean getShouldNotifyUser() {
        return this.shouldNotifyUser;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.dependencyId};
        String string = CoreBundle.message("plugin.loading.error.long.depends.on.disabled.plugin", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getShortMessage() {
        Object[] objectArray = new Object[]{this.dependencyId};
        String string = CoreBundle.message("plugin.loading.error.short.depends.on.disabled.plugin", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.getPlugin().getName() + "' (" + this.getPlugin().getPluginId() + ") requires plugin with id=" + this.dependencyId + " to be enabled";
    }
}

