/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PathResolverKt;
import com.intellij.ide.plugins.ProductLoadingStrategy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.plugins.parser.impl.LoadPathUtil;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorBuilder;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorFromXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginDescriptorReaderContext;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumer;
import com.intellij.platform.plugins.parser.impl.PluginXmlStreamConsumerKt;
import com.intellij.platform.plugins.parser.impl.XIncludeLoader;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "classLoader", "Ljava/lang/ClassLoader;", "isRunningFromSourcesWithoutDevBuild", "", "<init>", "(Ljava/lang/ClassLoader;Z)V", "isFlat", "()Z", "loadXIncludeReference", "Lcom/intellij/platform/plugins/parser/impl/XIncludeLoader$LoadedXIncludeReference;", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "path", "", "resolveModuleFile", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorBuilder;", "readContext", "Lcom/intellij/platform/plugins/parser/impl/PluginDescriptorReaderContext;", "resolvePath", "relativePath", "getXmlReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassPathXmlPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1#2:102\n14#3:103\n61#3,5:104\n*S KotlinDebug\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n*L\n56#1:103\n67#1:104,5\n*E\n"})
public final class ClassPathXmlPathResolver
implements PathResolver {
    @NotNull
    private final ClassLoader classLoader;
    @JvmField
    public final boolean isRunningFromSourcesWithoutDevBuild;

    public ClassPathXmlPathResolver(@NotNull ClassLoader classLoader, boolean isRunningFromSourcesWithoutDevBuild) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.isRunningFromSourcesWithoutDevBuild = isRunningFromSourcesWithoutDevBuild;
    }

    @Override
    public boolean isFlat() {
        return true;
    }

    @Override
    @Nullable
    public XIncludeLoader.LoadedXIncludeReference loadXIncludeReference(@NotNull DataLoader dataLoader2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream input = null;
        if (this.classLoader instanceof UrlClassLoader) {
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                byteArrayInputStream = new ByteArrayInputStream(p0);
            } else {
                byteArrayInputStream = null;
            }
            input = byteArrayInputStream;
        } else {
            input = this.classLoader.getResourceAsStream(path);
        }
        if (input == null) {
            return null;
        }
        return new XIncludeLoader.LoadedXIncludeReference(input, dataLoader2.toString());
    }

    @Override
    @NotNull
    public PluginDescriptorBuilder resolveModuleFile(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] resource = null;
        if (this.classLoader instanceof UrlClassLoader) {
            resource = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
        } else {
            InputStream inputStream = this.classLoader.getResourceAsStream(path);
            if (inputStream != null) {
                InputStream it = inputStream;
                boolean bl = false;
                PluginDescriptorFromXmlStreamConsumer reader = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader(this, dataLoader2));
                PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)reader, it, dataLoader2.toString());
                return reader.getBuilder();
            }
            resource = null;
        }
        if (resource == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ClassPathXmlPathResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger log = logger;
            String moduleName = StringsKt.removeSuffix((String)path, (CharSequence)".xml");
            if (this.isRunningFromSourcesWithoutDevBuild && StringsKt.startsWith$default((String)path, (String)"intellij.", (boolean)false, (int)2, null) && dataLoader2.getEmptyDescriptorIfCannotResolve()) {
                PluginDescriptorBuilder it;
                log.trace("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + "). ");
                PluginDescriptorBuilder $this$resolveModuleFile_u24lambda_u241 = it = PluginDescriptorBuilder.Companion.builder();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u241.setPackage("unresolved." + moduleName);
                return it;
            }
            if (ProductLoadingStrategy.Companion.getStrategy().isOptionalProductModule(moduleName)) {
                Object $this$debug_u24default$iv = log;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if (((Logger)$this$debug_u24default$iv).isDebugEnabled()) {
                    Logger logger2 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger2.debug("Skip module '" + path + "' since its descriptor cannot be found and it's optional", e$iv);
                }
                Object $this$resolveModuleFile_u24lambda_u243 = $this$debug_u24default$iv = PluginDescriptorBuilder.Companion.builder();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u243.setPackage("unresolved." + moduleName);
                return $this$debug_u24default$iv;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + ')');
        }
        PluginDescriptorFromXmlStreamConsumer it = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader(this, dataLoader2));
        boolean bl = false;
        PluginXmlStreamConsumerKt.consume((PluginXmlStreamConsumer)it, resource, dataLoader2.toString());
        return it.getBuilder();
    }

    @Override
    @Nullable
    public PluginDescriptorBuilder resolvePath(@NotNull PluginDescriptorReaderContext readContext, @NotNull DataLoader dataLoader2, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = LoadPathUtil.toLoadPath$default(LoadPathUtil.INSTANCE, relativePath, null, 2, null);
        XMLStreamReader2 xMLStreamReader2 = this.getXmlReader(this.classLoader, path, dataLoader2);
        if (xMLStreamReader2 == null) {
            return null;
        }
        XMLStreamReader2 reader = xMLStreamReader2;
        PluginDescriptorFromXmlStreamConsumer it = new PluginDescriptorFromXmlStreamConsumer(readContext, PathResolverKt.toXIncludeLoader(this, dataLoader2));
        boolean bl = false;
        it.consume(reader);
        return it.getBuilder();
    }

    private final XMLStreamReader2 getXmlReader(ClassLoader classLoader, String path, DataLoader dataLoader2) {
        if (classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)classLoader).getResourceAsBytes(path, true);
            if (byArray == null) {
                return null;
            }
            return StaxFactory.createNonCoalescingXmlStreamReader(byArray, dataLoader2.toString());
        }
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return StaxFactory.createNonCoalescingXmlStreamReader(inputStream, dataLoader2.toString());
    }
}

