/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProblemDescriptorImpl
implements CommonProblemDescriptor {
    private static final Logger LOG = Logger.getInstance(CommonProblemDescriptorImpl.class);
    private final QuickFix<?> @NotNull [] myFixes;
    private final @InspectionMessage String myDescriptionTemplate;

    CommonProblemDescriptorImpl(@NotNull @InspectionMessage String descriptionTemplate, @NotNull QuickFix<?> @Nullable [] fixes) {
        if (descriptionTemplate == null) {
            CommonProblemDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (fixes != null && fixes.length > 0) {
            if (ArrayUtil.contains(null, fixes)) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new IllegalArgumentException("'fixes' argument must not contain null elements, for consistency and performance reasons, but got: `" + String.valueOf(Arrays.asList(fixes)) + "'");
                }
                fixes = ContainerUtil.mapNotNull(fixes, FunctionUtil.id(), ArrayUtil.newArray(ArrayUtil.getComponentType(fixes), 0));
            }
            if (!(this instanceof ProblemDescriptor)) {
                for (QuickFix<?> fix : fixes) {
                    if (!(fix instanceof LocalQuickFix)) continue;
                    LOG.error("Local quick fix expect ProblemDescriptor, but here only CommonProblemDescriptor available: " + this.getClass().getName() + "; descr: " + descriptionTemplate);
                }
            }
        }
        this.myFixes = fixes == null || fixes.length == 0 ? LocalQuickFix.EMPTY_ARRAY : fixes;
        this.myDescriptionTemplate = descriptionTemplate;
    }

    @Override
    @NotNull
    @InspectionMessage
    public String getDescriptionTemplate() {
        String string = this.myDescriptionTemplate;
        if (string == null) {
            CommonProblemDescriptorImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public @NotNull QuickFix<?> @Nullable [] getFixes() {
        return this.myFixes;
    }

    public String toString() {
        return this.myDescriptionTemplate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CommonProblemDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CommonProblemDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

