/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupArranger
implements WeighingContext {
    protected final List<LookupElement> myItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myMatchingItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myExactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myInexactPrefixItems = new ArrayList<LookupElement>();
    private final List<LookupElement> myTopPriorityItems = new ArrayList<LookupElement>();
    private final Key<PrefixMatcher> myMatcherKey = Key.create("LookupArrangerMatcher");
    @Nullable
    private volatile Predicate<LookupElement> myAdditionalMatcher;
    private volatile String myAdditionalPrefix = "";

    public void addElement(LookupElement item, LookupElementPresentation presentation) {
        this.myItems.add(item);
        this.updateCache(item);
    }

    private void updateCache(LookupElement item) {
        if (!this.prefixMatches(item)) {
            return;
        }
        this.myMatchingItems.add(item);
        if (this.isTopPriorityItem(item)) {
            this.myTopPriorityItems.add(item);
        }
        if (this.isPrefixItem(item, true)) {
            this.myExactPrefixItems.add(item);
        } else if (this.isPrefixItem(item, false)) {
            this.myInexactPrefixItems.add(item);
        }
    }

    public void registerMatcher(@NotNull LookupElement item, @NotNull PrefixMatcher matcher) {
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            LookupArranger.$$$reportNull$$$0(1);
        }
        item.putUserData(this.myMatcherKey, matcher);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public void registerAdditionalMatcher(@NotNull Predicate<LookupElement> matcher) {
        if (matcher == null) {
            LookupArranger.$$$reportNull$$$0(2);
        }
        this.myAdditionalMatcher = matcher;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @Nullable
    public Predicate<LookupElement> getAdditionalMatcher() {
        return this.myAdditionalMatcher;
    }

    @Override
    @NotNull
    public String itemPattern(@NotNull LookupElement element) {
        if (element == null) {
            LookupArranger.$$$reportNull$$$0(3);
        }
        String prefix = this.itemMatcher(element).getPrefix();
        String additionalPrefix = this.myAdditionalPrefix;
        Object object = additionalPrefix.isEmpty() ? prefix : prefix + additionalPrefix;
        if (object == null) {
            LookupArranger.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Override
    @NotNull
    public PrefixMatcher itemMatcher(@NotNull LookupElement item) {
        PrefixMatcher matcher;
        if (item == null) {
            LookupArranger.$$$reportNull$$$0(5);
        }
        if ((matcher = item.getUserData(this.myMatcherKey)) == null) {
            throw new AssertionError((Object)("Item not in lookup: item=" + String.valueOf(item) + "; lookup items=" + String.valueOf(this.myItems)));
        }
        PrefixMatcher prefixMatcher = matcher;
        if (prefixMatcher == null) {
            LookupArranger.$$$reportNull$$$0(6);
        }
        return prefixMatcher;
    }

    private boolean prefixMatches(LookupElement item) {
        PrefixMatcher matcher = this.itemMatcher(item);
        Predicate<LookupElement> additionalMatcher = this.myAdditionalMatcher;
        if (additionalMatcher != null && !additionalMatcher.test(item)) {
            return false;
        }
        if (!this.myAdditionalPrefix.isEmpty()) {
            matcher = matcher.cloneWithPrefix(matcher.getPrefix() + this.myAdditionalPrefix);
        }
        return matcher.prefixMatches(item);
    }

    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
    }

    public void prefixReplaced(@NotNull Lookup lookup, @NotNull String newPrefix) {
        if (lookup == null) {
            LookupArranger.$$$reportNull$$$0(7);
        }
        if (newPrefix == null) {
            LookupArranger.$$$reportNull$$$0(8);
        }
        ArrayList<LookupElement> itemCopy = new ArrayList<LookupElement>(this.myItems);
        this.myItems.clear();
        for (LookupElement item : itemCopy) {
            PrefixMatcher matcher;
            if (!item.isValid() || !(matcher = this.itemMatcher(item).cloneWithPrefix(newPrefix)).prefixMatches(item)) continue;
            item.putUserData(this.myMatcherKey, matcher);
            this.myItems.add(item);
        }
        this.prefixChanged(lookup);
    }

    public void prefixChanged(Lookup lookup) {
        this.myAdditionalPrefix = ((LookupElementListPresenter)((Object)lookup)).getAdditionalPrefix();
        this.rebuildItemCache();
    }

    private void rebuildItemCache() {
        this.myMatchingItems.clear();
        this.myExactPrefixItems.clear();
        this.myInexactPrefixItems.clear();
        this.myTopPriorityItems.clear();
        for (LookupElement item : this.myItems) {
            this.updateCache(item);
        }
    }

    @ApiStatus.Internal
    protected boolean isTopPriorityItem(@Nullable LookupElement item) {
        return false;
    }

    protected List<LookupElement> retainItems(Set<LookupElement> retained) {
        ArrayList<LookupElement> filtered = new ArrayList<LookupElement>();
        ArrayList<LookupElement> removed = new ArrayList<LookupElement>();
        for (LookupElement item : this.myItems) {
            (retained.contains(item) ? filtered : removed).add(item);
        }
        this.myItems.clear();
        this.myItems.addAll(filtered);
        this.rebuildItemCache();
        return removed;
    }

    public abstract Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup var1, boolean var2);

    public abstract LookupArranger createEmptyCopy();

    protected List<LookupElement> getPrefixItems(boolean exactly) {
        return Collections.unmodifiableList(exactly ? this.myExactPrefixItems : this.myInexactPrefixItems);
    }

    @ApiStatus.Internal
    protected List<LookupElement> getTopPriorityItems() {
        return Collections.unmodifiableList(this.myTopPriorityItems);
    }

    protected boolean isPrefixItem(LookupElement item, boolean exactly) {
        String pattern = this.itemPattern(item);
        for (String s : item.getAllLookupStrings()) {
            if (!s.equalsIgnoreCase(pattern) || item.isCaseSensitive() && exactly && !s.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public List<LookupElement> getMatchingItems() {
        return this.myMatchingItems;
    }

    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            LookupArranger.$$$reportNull$$$0(9);
        }
        Map<LookupElement, List<Pair<String, Object>>> map2 = Collections.emptyMap();
        if (map2 == null) {
            LookupArranger.$$$reportNull$$$0(10);
        }
        return map2;
    }

    public void prefixTruncated(@NotNull LookupEx lookup, int hideOffset) {
        if (lookup == null) {
            LookupArranger.$$$reportNull$$$0(11);
        }
        lookup.hideLookup(false);
    }

    public boolean isCompletion() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupArranger";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupArranger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "itemPattern";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "itemMatcher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerMatcher";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "itemPattern";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "itemMatcher";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prefixReplaced";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prefixTruncated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 10 -> new IllegalStateException(string);
        };
    }

    public static class DefaultArranger
    extends LookupArranger {
        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            if (lookup == null) {
                DefaultArranger.$$$reportNull$$$0(0);
            }
            LinkedHashSet<LookupElement> result = new LinkedHashSet<LookupElement>();
            result.addAll(this.getPrefixItems(true));
            result.addAll(this.getPrefixItems(false));
            List<LookupElement> items = this.getMatchingItems();
            for (LookupElement item : items) {
                if (!CompletionService.isStartMatch(item, this)) continue;
                result.add(item);
            }
            result.addAll(items);
            ArrayList list = new ArrayList(result);
            int selected = !lookup.isSelectionTouched() && onExplicitAction ? 0 : list.indexOf(lookup.getCurrentItem());
            return new Pair<List<LookupElement>, Integer>(list, Math.max(selected, 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new DefaultArranger();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/lookup/LookupArranger$DefaultArranger", "arrangeItems"));
        }
    }
}

