/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.preview;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.DeferredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface IntentionPreviewInfo {
    public static final IntentionPreviewInfo EMPTY = new IntentionPreviewInfo(){

        public String toString() {
            return "EMPTY";
        }
    };
    @ApiStatus.Internal
    public static final IntentionPreviewInfo FALLBACK_DIFF = new IntentionPreviewInfo(){

        public String toString() {
            return "FALLBACK";
        }
    };
    public static final IntentionPreviewInfo DIFF = new IntentionPreviewInfo(){

        public String toString() {
            return "DIFF";
        }
    };
    public static final IntentionPreviewInfo DIFF_NO_TRIM = new IntentionPreviewInfo(){

        public String toString() {
            return "DIFF_NO_TRIM";
        }
    };

    @NotNull
    public static IntentionPreviewInfo rename(@NotNull PsiFile file, @NotNull @NlsSafe String newName) {
        if (file == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(1);
        }
        return IntentionPreviewInfo.rename(file.getVirtualFile(), newName);
    }

    @NotNull
    public static IntentionPreviewInfo rename(@NotNull VirtualFile file, @NotNull @NlsSafe String newName) {
        if (file == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(2);
        }
        if (newName == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(3);
        }
        Icon icon = IconUtil.getIcon((VirtualFile)file, (int)0, null);
        HtmlChunk iconChunk = IntentionPreviewInfo.getIconChunk(icon, "file");
        HtmlChunk fragment = new HtmlBuilder().append(iconChunk).append(file.getName()).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(iconChunk).append(newName).toFragment();
        return new Html(fragment.wrapWith("p"));
    }

    @NotNull
    private static HtmlChunk getIconChunk(@Nullable Icon icon, @NotNull String id) {
        if (id == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(4);
        }
        if (icon instanceof DeferredIcon) {
            DeferredIcon deferred2 = (DeferredIcon)icon;
            icon = deferred2.evaluate();
        }
        HtmlChunk htmlChunk = icon == null ? HtmlChunk.empty() : new HtmlBuilder().append(HtmlChunk.icon(id, icon)).nbsp().toFragment();
        if (htmlChunk == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(5);
        }
        return htmlChunk;
    }

    @NotNull
    public static IntentionPreviewInfo moveToDirectory(@NotNull VirtualFile file, @NotNull VirtualFile directory) {
        if (file == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(6);
        }
        if (directory == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(7);
        }
        Icon fileIcon = IconUtil.getIcon((VirtualFile)file, (int)0, null);
        Icon dirIcon = IconUtil.getIcon((VirtualFile)directory, (int)0, null);
        @NlsSafe String location = VfsUtilCore.getRelativeLocation(directory, file.getParent());
        if (location == null) {
            location = directory.getPath();
        }
        HtmlBuilder builder = new HtmlBuilder().append(HtmlChunk.icon("file", fileIcon)).nbsp().append(file.getName()).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(HtmlChunk.icon("dir", dirIcon)).nbsp().append(location);
        return new Html(builder.wrapWith("p"));
    }

    @NotNull
    public static IntentionPreviewInfo movePsi(@NotNull PsiNamedElement source, @NotNull PsiNamedElement target) {
        Icon targetIcon;
        Icon sourceIcon;
        if (source == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(8);
        }
        if (target == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(9);
        }
        if ((sourceIcon = source.getIcon(0)) instanceof DeferredIcon) {
            DeferredIcon deferred2 = (DeferredIcon)sourceIcon;
            sourceIcon = deferred2.evaluate();
        }
        if ((targetIcon = target.getIcon(0)) instanceof DeferredIcon) {
            DeferredIcon deferred3 = (DeferredIcon)targetIcon;
            targetIcon = deferred3.evaluate();
        }
        HtmlChunk moveFragment = IntentionPreviewInfo.getHtmlMoveFragment(sourceIcon, targetIcon, source.getName(), target.getName());
        return new Html(moveFragment.wrapWith("p"));
    }

    @NotNull
    public static IntentionPreviewInfo moveMultiplePsi(@NotNull List<PsiNamedElement> sources, @NotNull PsiNamedElement target) {
        if (sources == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(10);
        }
        if (target == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(11);
        }
        return IntentionPreviewInfo.moveMultiplePsi(sources, target, null);
    }

    @NotNull
    public static IntentionPreviewInfo moveMultiplePsi(@NotNull List<PsiNamedElement> sources, @NotNull PsiNamedElement target, @Nullable @Nls String explicitTargetName) {
        if (sources == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(12);
        }
        if (target == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(13);
        }
        HtmlBuilder builder = new HtmlBuilder();
        Icon targetIcon = IntentionPreviewInfo.getIcon(target);
        builder.appendWithSeparators(HtmlChunk.br(), ContainerUtil.map(sources, source -> IntentionPreviewInfo.getHtmlMoveFragment(IntentionPreviewInfo.getIcon(source), targetIcon, source.getName(), explicitTargetName == null ? target.getName() : explicitTargetName)));
        return new Html(builder.wrapWith("p"));
    }

    private static Icon getIcon(@NotNull PsiNamedElement source) {
        Icon icon;
        if (source == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(14);
        }
        if ((icon = source.getIcon(0)) instanceof DeferredIcon) {
            DeferredIcon deferred2 = (DeferredIcon)icon;
            icon = deferred2.evaluate();
        }
        return icon;
    }

    @NotNull
    private static HtmlChunk getHtmlMoveFragment(@Nullable Icon sourceIcon, @Nullable Icon targetIcon, @Nullable @Nls String sourceName, @Nullable @Nls String targetName) {
        HtmlChunk htmlChunk = new HtmlBuilder().append(IntentionPreviewInfo.getIconChunk(sourceIcon, "source_" + sourceName)).append(Objects.requireNonNull(sourceName)).append(" ").append(HtmlChunk.htmlEntity("&rarr;")).append(" ").append(IntentionPreviewInfo.getIconChunk(targetIcon, "target_" + targetName)).append(Objects.requireNonNull(targetName)).toFragment();
        if (htmlChunk == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(15);
        }
        return htmlChunk;
    }

    @NotNull
    public static IntentionPreviewInfo navigate(@NotNull NavigatablePsiElement target) {
        if (target == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(16);
        }
        PsiFile file = target.getContainingFile();
        int offset = target.getTextOffset();
        return IntentionPreviewInfo.navigate(file, offset);
    }

    @NotNull
    public static Html navigate(@NotNull PsiFile file, int offset) {
        if (file == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(17);
        }
        Icon icon = file.getIcon(0);
        Document document = file.getFileDocument();
        HtmlBuilder builder = new HtmlBuilder();
        builder.append(HtmlChunk.htmlEntity("&rarr;")).append(" ");
        builder.append(IntentionPreviewInfo.getIconChunk(icon, "icon"));
        builder.append(file.getName());
        if (document.getTextLength() > offset) {
            int lineNumber = document.getLineNumber(offset);
            builder.append(AnalysisBundle.message("html.preview.navigate.line", new Object[0])).append(String.valueOf(lineNumber + 1));
        }
        return new Html(builder.wrapWith("p"));
    }

    public static IntentionPreviewInfo addListOption(@NotNull List<@NlsSafe String> updatedList, @NotNull String addedOption, @NotNull @Nls String title) {
        if (updatedList == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(18);
        }
        if (addedOption == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(19);
        }
        if (title == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(20);
        }
        return IntentionPreviewInfo.addListOption(updatedList, title, Predicate.isEqual(addedOption));
    }

    public static Html addListOption(@NotNull List<@NlsSafe String> updatedList, @NotNull @Nls String title, @NotNull Predicate<String> toSelect) {
        if (updatedList == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(21);
        }
        if (title == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(22);
        }
        if (toSelect == null) {
            IntentionPreviewInfo.$$$reportNull$$$0(23);
        }
        int maxToList = Math.min(7, updatedList.size() + 2);
        HtmlChunk.Element select = HtmlChunk.tag("select").attr("multiple", "multiple").attr("size", maxToList).children(ContainerUtil.map2Array(updatedList, HtmlChunk.class, pref -> {
            HtmlChunk.Element chunk = HtmlChunk.tag("option").addText((String)pref);
            return toSelect.test((String)pref) ? chunk.attr("selected", "selected") : chunk;
        }));
        HtmlChunk content = new HtmlBuilder().append(title).br().br().append(select).toFragment();
        return new Html(content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedOption";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconChunk";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlMoveFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIconChunk";
                break;
            }
            case 5: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveToDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "movePsi";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveMultiplePsi";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addListOption";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 15 -> new IllegalStateException(string);
        };
    }

    public static final class Html
    implements IntentionPreviewInfo {
        @NotNull
        private final HtmlChunk myContent;
        @NotNull
        private final InfoKind myInfoKind;

        public Html(@NotNull HtmlChunk content) {
            if (content == null) {
                Html.$$$reportNull$$$0(0);
            }
            this(content, InfoKind.INFORMATION);
        }

        public Html(@NotNull HtmlChunk content, @NotNull InfoKind infoKind) {
            if (content == null) {
                Html.$$$reportNull$$$0(1);
            }
            if (infoKind == null) {
                Html.$$$reportNull$$$0(2);
            }
            this.myContent = content;
            this.myInfoKind = infoKind;
        }

        public Html(@Nls @NotNull String contentHtml) {
            if (contentHtml == null) {
                Html.$$$reportNull$$$0(3);
            }
            this(HtmlChunk.raw(contentHtml));
        }

        @NotNull
        public HtmlChunk content() {
            HtmlChunk htmlChunk = this.myContent;
            if (htmlChunk == null) {
                Html.$$$reportNull$$$0(4);
            }
            return htmlChunk;
        }

        @NotNull
        public InfoKind infoKind() {
            InfoKind infoKind = this.myInfoKind;
            if (infoKind == null) {
                Html.$$$reportNull$$$0(5);
            }
            return infoKind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Html html = (Html)o;
            return this.myContent.toString().equals(html.myContent.toString()) && this.myInfoKind == html.myInfoKind;
        }

        public int hashCode() {
            return 31 * this.myContent.toString().hashCode() + this.myInfoKind.hashCode();
        }

        public String toString() {
            return "HTML [content=" + String.valueOf(this.myContent) + ", infoKind=" + String.valueOf((Object)this.myInfoKind) + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infoKind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentHtml";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$Html";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "content";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "infoKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static enum InfoKind {
        INFORMATION,
        ERROR;

    }

    public static final class CustomDiff
    implements IntentionPreviewInfo {
        @NotNull
        private final FileType myFileType;
        @NotNull
        private final String myOrigText;
        @NotNull
        private final String myModifiedText;
        @Nullable
        private final String myFileName;
        private final boolean myLineNumbers;

        public CustomDiff(@NotNull FileType type, @NotNull String origText, @NotNull String modifiedText) {
            if (type == null) {
                CustomDiff.$$$reportNull$$$0(0);
            }
            if (origText == null) {
                CustomDiff.$$$reportNull$$$0(1);
            }
            if (modifiedText == null) {
                CustomDiff.$$$reportNull$$$0(2);
            }
            this(type, null, origText, modifiedText);
        }

        public CustomDiff(@NotNull FileType type, @Nullable String name, @NotNull String origText, @NotNull String modifiedText) {
            if (type == null) {
                CustomDiff.$$$reportNull$$$0(3);
            }
            if (origText == null) {
                CustomDiff.$$$reportNull$$$0(4);
            }
            if (modifiedText == null) {
                CustomDiff.$$$reportNull$$$0(5);
            }
            this(type, name, origText, modifiedText, false);
        }

        public CustomDiff(@NotNull FileType type, @Nullable String name, @NotNull String origText, @NotNull String modifiedText, boolean lineNumbers) {
            if (type == null) {
                CustomDiff.$$$reportNull$$$0(6);
            }
            if (origText == null) {
                CustomDiff.$$$reportNull$$$0(7);
            }
            if (modifiedText == null) {
                CustomDiff.$$$reportNull$$$0(8);
            }
            this.myFileType = type;
            this.myFileName = name;
            this.myOrigText = origText;
            this.myModifiedText = modifiedText;
            this.myLineNumbers = lineNumbers;
        }

        public boolean showLineNumbers() {
            return this.myLineNumbers;
        }

        @Nullable
        public String fileName() {
            return this.myFileName;
        }

        @NotNull
        public FileType fileType() {
            FileType fileType = this.myFileType;
            if (fileType == null) {
                CustomDiff.$$$reportNull$$$0(9);
            }
            return fileType;
        }

        @NotNull
        public String originalText() {
            String string = this.myOrigText;
            if (string == null) {
                CustomDiff.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public String modifiedText() {
            String string = this.myModifiedText;
            if (string == null) {
                CustomDiff.$$$reportNull$$$0(11);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomDiff diff = (CustomDiff)o;
            return this.myLineNumbers == diff.myLineNumbers && this.myFileType.equals(diff.myFileType) && this.myOrigText.equals(diff.myOrigText) && this.myModifiedText.equals(diff.myModifiedText) && Objects.equals(this.myFileName, diff.myFileName);
        }

        public int hashCode() {
            int result = this.myFileType.hashCode();
            result = 31 * result + this.myOrigText.hashCode();
            result = 31 * result + this.myModifiedText.hashCode();
            result = 31 * result + Objects.hashCode(this.myFileName);
            result = 31 * result + Boolean.hashCode(this.myLineNumbers);
            return result;
        }

        public String toString() {
            return "CustomDiff{myFileType=" + String.valueOf(this.myFileType) + ", myOrigText='" + this.myOrigText + "', myModifiedText='" + this.myModifiedText + "', myFileName='" + this.myFileName + "', myLineNumbers=" + this.myLineNumbers + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origText";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedText";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$CustomDiff";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$CustomDiff";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "originalText";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modifiedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MultiFileDiff
    implements IntentionPreviewInfo {
        @NotNull
        private final @NotNull List<@NotNull CustomDiff> myDiffs;

        public MultiFileDiff(@NotNull @NotNull List<@NotNull CustomDiff> diffs) {
            if (diffs == null) {
                MultiFileDiff.$$$reportNull$$$0(0);
            }
            this.myDiffs = diffs;
        }

        @NotNull
        public @NotNull List<@NotNull CustomDiff> getDiffs() {
            List<CustomDiff> list = this.myDiffs;
            if (list == null) {
                MultiFileDiff.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$MultiFileDiff";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/preview/IntentionPreviewInfo$MultiFileDiff";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiffs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

