/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IntentionAction
extends FileModifier,
CommonIntentionAction,
PossiblyDumbAware {
    public static final IntentionAction[] EMPTY_ARRAY = new IntentionAction[0];

    @IntentionName
    @NotNull
    public String getText();

    public boolean isAvailable(@NotNull Project var1, Editor var2, PsiFile var3);

    public void invoke(@NotNull Project var1, Editor var2, PsiFile var3) throws IncorrectOperationException;

    @Override
    public boolean startInWriteAction();

    @NotNull
    default public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        IntentionAction copy;
        if (project == null) {
            IntentionAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            IntentionAction.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            IntentionAction.$$$reportNull$$$0(2);
        }
        if ((copy = ObjectUtils.tryCast(this.getFileModifierForPreview(psiFile), IntentionAction.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.FALLBACK_DIFF;
            if (intentionPreviewInfo == null) {
                IntentionAction.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }
        PsiElement writable = copy.getElementToMakeWritable(psiFile);
        if (writable == null || writable.getContainingFile() != psiFile) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.FALLBACK_DIFF;
            if (intentionPreviewInfo == null) {
                IntentionAction.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }
        copy.invoke(project, editor, psiFile);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            IntentionAction.$$$reportNull$$$0(5);
        }
        return intentionPreviewInfo;
    }

    @Override
    @NotNull
    default public IntentionAction asIntention() {
        IntentionAction intentionAction = this;
        if (intentionAction == null) {
            IntentionAction.$$$reportNull$$$0(6);
        }
        return intentionAction;
    }

    @Override
    @Nullable
    default public ModCommandAction asModCommandAction() {
        IntentionAction intentionAction = this;
        if (intentionAction instanceof IntentionActionDelegate) {
            IntentionActionDelegate delegate = (IntentionActionDelegate)((Object)intentionAction);
            return delegate.getDelegate().asModCommandAction();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/IntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/IntentionAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "asIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

