/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.NasueousGeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.WolfListeners;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.FileViewProviderUtil;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class WolfTheProblemSolverImpl
extends WolfTheProblemSolver
implements Disposable {
    private final Map<VirtualFile, ProblemFileInfo> myProblems;
    private final Map<VirtualFile, Set<Object>> myProblemsFromExternalSources;
    private final Collection<VirtualFile> myCheckingQueue;
    private final Project myProject;
    private final WolfListeners myWolfListeners;

    private WolfTheProblemSolverImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(1);
        }
        this.myProblems = new ConcurrentHashMap<VirtualFile, ProblemFileInfo>();
        this.myProblemsFromExternalSources = new ConcurrentHashMap<VirtualFile, Set<Object>>();
        this.myCheckingQueue = new HashSet<VirtualFile>(10);
        this.myProject = project;
        this.myWolfListeners = new WolfListeners(project, this, coroutineScope);
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemove(@NotNull VirtualFile problemFile) {
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(2);
        }
        ProblemFileInfo old = this.myProblems.remove(problemFile);
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.remove(problemFile);
        }
        if (old != null) {
            if (this.hasProblemsFromExternalSources(problemFile)) {
                this.fireProblemsChanged(problemFile);
            } else {
                this.fireProblemsDisappeared(problemFile);
            }
        }
    }

    void clearSyntaxErrorFlag(@NotNull PsiTreeChangeEvent event) {
        PsiFile psiFile;
        if (event == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(3);
        }
        if ((psiFile = event.getFile()) == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ProblemFileInfo info = this.myProblems.get(virtualFile);
        if (info != null) {
            info.hasSyntaxErrors = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckingIfVincentSolvedProblemsYet(@NotNull ProgressIndicator progress, @NotNull ProgressableTextEditorHighlightingPass pass) throws ProcessCanceledException {
        ArrayList<VirtualFile> files;
        if (progress == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(4);
        }
        if (pass == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(5);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            files = new ArrayList<VirtualFile>(this.myCheckingQueue);
        }
        long progressLimit = files.stream().filter(VirtualFile::isValid).mapToLong(VirtualFile::getLength).sum();
        pass.setProgressLimit(progressLimit);
        for (VirtualFile virtualFile : files) {
            progress.checkCanceled();
            if (virtualFile == null) break;
            if (!virtualFile.isValid() || this.orderVincentToCleanTheCar(virtualFile, progress)) {
                this.doRemove(virtualFile);
            }
            if (!virtualFile.isValid()) continue;
            pass.advanceProgress(virtualFile.getLength());
        }
    }

    private boolean orderVincentToCleanTheCar(@NotNull VirtualFile virtualFile, @NotNull ProgressIndicator progressIndicator) throws ProcessCanceledException {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(6);
        }
        if (progressIndicator == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(7);
        }
        if (!this.isToBeHighlighted(virtualFile)) {
            this.clearProblems(virtualFile);
            return true;
        }
        if (this.hasSyntaxErrors(virtualFile)) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.willBeHighlightedAnyway(virtualFile)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(virtualFile);
        if (psiFile == null) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return false;
        }
        CodeInsightContext context = FileViewProviderUtil.getCodeInsightContext(psiFile);
        AtomicReference error = new AtomicReference();
        boolean hasErrorElement = false;
        try {
            ProperTextRange visibleRange = new ProperTextRange(0, document.getTextLength());
            HighlightingSessionImpl.getOrCreateHighlightingSession(psiFile, context, (DaemonProgressIndicator)progressIndicator, visibleRange, TextRange.EMPTY_RANGE);
            NasueousGeneralHighlightingPass pass = new NasueousGeneralHighlightingPass(psiFile, document, visibleRange, error);
            pass.setContext(context);
            pass.collectInformation(progressIndicator);
            hasErrorElement = pass.hasErrorElement();
        }
        catch (ProcessCanceledException e) {
            if (error.get() != null) {
                ProblemImpl problem = new ProblemImpl(virtualFile, (HighlightInfo)error.get(), hasErrorElement);
                this.reportProblems(virtualFile, Collections.singleton(problem));
            }
            return false;
        }
        this.clearProblems(virtualFile);
        return true;
    }

    @Override
    public boolean hasSyntaxErrors(@NotNull VirtualFile file) {
        ProblemFileInfo info;
        if (file == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(8);
        }
        return (info = this.myProblems.get(file)) != null && info.hasSyntaxErrors;
    }

    private boolean willBeHighlightedAnyway(@NotNull VirtualFile file) {
        FileEditor[] selectedEditors;
        if (file == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(9);
        }
        for (FileEditor editor : selectedEditors = FileEditorManager.getInstance(this.myProject).getSelectedEditors()) {
            if (!(editor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)editor;
            Document document = textEditor.getEditor().getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance(this.myProject).getCachedPsiFile(document);
            if (psiFile == null || !Comparing.equal(file, psiFile.getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasProblemFilesBeneath(@NotNull Condition<? super VirtualFile> condition) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(10);
        }
        if (!this.myProject.isOpen()) {
            return false;
        }
        return WolfTheProblemSolverImpl.checkProblemFilesInMap(condition, this.myProblems) || WolfTheProblemSolverImpl.checkProblemFilesInMap(condition, this.myProblemsFromExternalSources);
    }

    private static boolean checkProblemFilesInMap(@NotNull Condition<? super VirtualFile> condition, @NotNull Map<? extends VirtualFile, ?> map2) {
        if (condition == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(11);
        }
        if (map2 == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(12);
        }
        if (!map2.isEmpty()) {
            for (VirtualFile virtualFile : map2.keySet()) {
                if (!virtualFile.isValid() || !condition.value(virtualFile)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasProblemFilesBeneath(@NotNull Module scope) {
        if (scope == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(13);
        }
        return this.hasProblemFilesBeneath((? super VirtualFile virtualFile) -> ModuleUtilCore.moduleContainsFile(scope, virtualFile, false));
    }

    @Override
    public void queue(@NotNull VirtualFile suspiciousFile) {
        if (suspiciousFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.isToBeHighlighted(suspiciousFile)) {
            return;
        }
        this.doQueue(suspiciousFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull VirtualFile suspiciousFile) {
        if (suspiciousFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(15);
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.add(suspiciousFile);
        }
    }

    @Override
    public boolean isProblemFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(16);
        }
        return this.hasRegularProblems(virtualFile) || this.hasProblemsFromExternalSources(virtualFile);
    }

    private boolean hasRegularProblems(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(17);
        }
        return this.myProblems.containsKey(virtualFile);
    }

    private boolean hasProblemsFromExternalSources(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(18);
        }
        return this.myProblemsFromExternalSources.containsKey(virtualFile);
    }

    boolean isToBeHighlighted(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(19);
        }
        return ReadAction.compute(() -> {
            for (Condition filter2 : FILTER_EP_NAME.getExtensionList(this.myProject)) {
                ProgressManager.checkCanceled();
                if (!filter2.value(virtualFile)) continue;
                return true;
            }
            return false;
        });
    }

    @Override
    public void weHaveGotProblems(@NotNull VirtualFile virtualFile, @NotNull List<? extends Problem> problems) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(20);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (problems.isEmpty()) {
            return;
        }
        if (this.isToBeHighlighted(virtualFile)) {
            this.weHaveGotNonIgnorableProblems(virtualFile, problems);
        }
    }

    @Override
    public void weHaveGotNonIgnorableProblems(@NotNull VirtualFile virtualFile, @NotNull List<? extends Problem> problems) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(22);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (problems.isEmpty()) {
            return;
        }
        ProblemFileInfo storedProblems = this.myProblems.computeIfAbsent(virtualFile, __ -> new ProblemFileInfo());
        boolean fireListener = storedProblems.problems.isEmpty();
        storedProblems.problems.addAll(problems);
        this.doQueue(virtualFile);
        if (fireListener) {
            if (this.hasProblemsFromExternalSources(virtualFile)) {
                this.fireProblemsChanged(virtualFile);
            } else {
                this.fireProblemsAppeared(virtualFile);
            }
        }
    }

    @RequiresBackgroundThread
    private void fireProblemsAppeared(@NotNull VirtualFile file) {
        if (file == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.assertBackgroundThread();
        this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC).problemsAppeared(file);
    }

    private void fireProblemsChanged(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(25);
        }
        this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC).problemsChanged(virtualFile);
    }

    private void fireProblemsDisappeared(@NotNull VirtualFile problemFile) {
        if (problemFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(26);
        }
        this.myProject.getMessageBus().syncPublisher(ProblemListener.TOPIC).problemsDisappeared(problemFile);
    }

    @Override
    public void clearProblems(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(27);
        }
        this.doRemove(virtualFile);
    }

    @Override
    public Problem convertToProblem(@NotNull VirtualFile virtualFile, int line, int column, String @NotNull [] message) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(28);
        }
        if (message == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(29);
        }
        if (virtualFile.isDirectory() || virtualFile.getFileType().isBinary()) {
            return null;
        }
        HighlightInfo info = ReadAction.compute(() -> {
            TextRange textRange = WolfTheProblemSolverImpl.getTextRange(virtualFile, line, column);
            String description = StringUtil.join(message, "\n");
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        });
        if (info == null) {
            return null;
        }
        return new ProblemImpl(virtualFile, info, false);
    }

    @Override
    public void reportProblems(@NotNull VirtualFile file, @NotNull Collection<? extends Problem> problems) {
        if (file == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(30);
        }
        if (problems == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (problems.isEmpty()) {
            this.clearProblems(file);
            return;
        }
        if (!this.isToBeHighlighted(file)) {
            return;
        }
        ProblemFileInfo newInfo = new ProblemFileInfo();
        for (Problem problem : problems) {
            newInfo.problems.add(problem);
            newInfo.hasSyntaxErrors |= ((ProblemImpl)problem).isSyntaxOnly();
        }
        ProblemFileInfo oldInfo = this.myProblems.put(file, newInfo);
        boolean hasProblemsBefore = oldInfo != null;
        boolean fireChanged = hasProblemsBefore && !oldInfo.equals(newInfo);
        this.doQueue(file);
        boolean bl = this.hasProblemsFromExternalSources(file);
        if (!hasProblemsBefore && !bl) {
            this.fireProblemsAppeared(file);
        } else if (fireChanged || bl) {
            this.fireProblemsChanged(file);
        }
    }

    @Override
    public void reportProblemsFromExternalSource(@NotNull VirtualFile file, @NotNull Object source) {
        if (file == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(32);
        }
        if (source == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(33);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!this.isToBeHighlighted(file)) {
            return;
        }
        Set problems = this.myProblemsFromExternalSources.computeIfAbsent(file, __ -> ConcurrentCollectionFactory.createConcurrentSet());
        boolean isNewFileForExternalSource = problems.isEmpty();
        problems.add(source);
        if (isNewFileForExternalSource && !this.hasRegularProblems(file)) {
            this.fireProblemsAppeared(file);
        } else {
            this.fireProblemsChanged(file);
        }
    }

    @Override
    public void clearProblemsFromExternalSource(@NotNull VirtualFile file, @NotNull Object source) {
        if (file == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(34);
        }
        if (source == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        AtomicBoolean isLastExternalSource = new AtomicBoolean();
        this.myProblemsFromExternalSources.compute(file, (__, problems) -> {
            if (problems == null) {
                return null;
            }
            problems.remove(source);
            boolean wasLastProblem = problems.isEmpty();
            isLastExternalSource.set(wasLastProblem);
            return wasLastProblem ? null : problems;
        });
        if (isLastExternalSource.get() && !this.hasRegularProblems(file)) {
            this.fireProblemsDisappeared(file);
        } else {
            this.fireProblemsChanged(file);
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull VirtualFile virtualFile, int line, int column) {
        if (virtualFile == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(36);
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        assert (document != null);
        int lineCount = document.getLineCount();
        if (line > lineCount) {
            line = lineCount;
        }
        line = line <= 0 ? 0 : line - 1;
        int offset = document.getLineStartOffset(line) + (column <= 0 ? 0 : column - 1);
        return new TextRange(offset, offset);
    }

    public void consumeProblemFiles(@NotNull Consumer<? super VirtualFile> consumer) {
        if (consumer == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(37);
        }
        this.myProblems.keySet().forEach(consumer);
    }

    public void consumeProblemFilesFromExternalSources(@NotNull Consumer<? super VirtualFile> consumer) {
        if (consumer == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(38);
        }
        this.myProblemsFromExternalSources.keySet().forEach(consumer);
    }

    @TestOnly
    public void waitForFilesQueuedForInvalidationAreProcessed() {
        this.myWolfListeners.waitForFilesQueuedForInvalidationAreProcessed();
    }

    @TestOnly
    @NotNull
    public static WolfTheProblemSolver createTestInstance(@NotNull Project project) {
        if (project == null) {
            WolfTheProblemSolverImpl.$$$reportNull$$$0(39);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return new WolfTheProblemSolverImpl(project, ((ComponentManagerEx)((Object)project)).getCoroutineScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 8: 
            case 9: 
            case 24: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspiciousFile";
                break;
            }
            case 21: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WolfTheProblemSolverImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRemove";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "clearSyntaxErrorFlag";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startCheckingIfVincentSolvedProblemsYet";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "orderVincentToCleanTheCar";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSyntaxErrors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "willBeHighlightedAnyway";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProblemFilesBeneath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProblemFilesInMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "queue";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "doQueue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isProblemFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRegularProblems";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProblemsFromExternalSources";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isToBeHighlighted";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "weHaveGotProblems";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "weHaveGotNonIgnorableProblems";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsAppeared";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsChanged";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "fireProblemsDisappeared";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProblems";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToProblem";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProblems";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "reportProblemsFromExternalSource";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProblemsFromExternalSource";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextRange";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeProblemFiles";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeProblemFilesFromExternalSources";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ProblemFileInfo {
        private final Collection<Problem> problems = ConcurrentCollectionFactory.createConcurrentSet();
        private volatile boolean hasSyntaxErrors;

        private ProblemFileInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemFileInfo that = (ProblemFileInfo)o;
            return this.hasSyntaxErrors == that.hasSyntaxErrors && this.problems.equals(that.problems);
        }

        public int hashCode() {
            int result = this.problems.hashCode();
            result = 31 * result + (this.hasSyntaxErrors ? 1 : 0);
            return result;
        }
    }
}

