/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class InjectedLanguageFragmentSyntaxUtil {
    InjectedLanguageFragmentSyntaxUtil() {
    }

    @Contract(pure=true)
    static List<HighlightInfo> addSyntaxInjectedFragmentInfo(@NotNull EditorColorsScheme scheme, @NotNull TextRange hostRange, TextAttributesKey @NotNull [] keys, @Nullable Object toolId) {
        LayeredTextAttributes injectedAttributes;
        if (scheme == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(0);
        }
        if (hostRange == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(1);
        }
        if (keys == null) {
            InjectedLanguageFragmentSyntaxUtil.$$$reportNull$$$0(2);
        }
        if (hostRange.isEmpty()) {
            return List.of();
        }
        HighlightInfo eraseInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(hostRange).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
        eraseInfo.toolId = toolId;
        eraseInfo.markFromInjection();
        if (toolId != null) {
            eraseInfo.setGroup(-6);
        }
        if ((injectedAttributes = LayeredTextAttributes.create((EditorColorsScheme)scheme, (TextAttributesKey[])keys)).isEmpty() || keys.length == 1 && keys[0] == HighlighterColors.TEXT) {
            return List.of(eraseInfo);
        }
        HighlightInfo injectedInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(hostRange).textAttributes((TextAttributes)injectedAttributes).createUnconditionally();
        injectedInfo.toolId = toolId;
        injectedInfo.markFromInjection();
        if (toolId != null) {
            injectedInfo.setGroup(-6);
        }
        return List.of(eraseInfo, injectedInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "hostRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "keys";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/InjectedLanguageFragmentSyntaxUtil";
        objectArray[2] = "addSyntaxInjectedFragmentInfo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

