/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class HighlightInfoB
implements HighlightInfo.Builder {
    private static final Logger LOG = Logger.getInstance(HighlightInfoB.class);
    private Boolean myNeedsUpdateOnTyping;
    private TextAttributes forcedTextAttributes;
    private TextAttributesKey forcedTextAttributesKey;
    private final HighlightInfoType type;
    private final boolean isCopy;
    private int startOffset;
    private int endOffset;
    private @NlsContexts.DetailedDescription String escapedDescription;
    private @NlsContexts.Tooltip String escapedToolTip;
    private HighlightSeverity severity;
    private Boolean isAfterEndOfLine;
    private Boolean isFileLevelAnnotation;
    private int navigationShift;
    private GutterIconRenderer gutterIconRenderer;
    private ProblemGroup problemGroup;
    private PsiElement psiElement;
    private int group;
    private final List<HighlightInfo.IntentionActionDescriptor> fixes;
    private boolean created;
    private final List<Consumer<? super QuickFixActionRegistrar>> myLazyFixes;
    private static final int UNSET_INT_VALUE = -2039480982;

    HighlightInfoB(@NotNull HighlightInfoType type, boolean isCopy) {
        if (type == null) {
            HighlightInfoB.$$$reportNull$$$0(0);
        }
        this.startOffset = -2039480982;
        this.endOffset = -2039480982;
        this.navigationShift = -2039480982;
        this.group = -2039480982;
        this.fixes = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        this.myLazyFixes = new ArrayList<Consumer<? super QuickFixActionRegistrar>>();
        this.type = type;
        this.isCopy = isCopy;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
        if (gutterIconRenderer == null) {
            HighlightInfoB.$$$reportNull$$$0(1);
        }
        this.assertNotCreated();
        this.assertNotSet(this.gutterIconRenderer, "gutterIconRenderer");
        this.gutterIconRenderer = gutterIconRenderer;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(2);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder problemGroup(@NotNull ProblemGroup problemGroup) {
        if (problemGroup == null) {
            HighlightInfoB.$$$reportNull$$$0(3);
        }
        this.assertNotCreated();
        this.assertNotSet(this.problemGroup, "problemGroup");
        this.problemGroup = problemGroup;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(4);
        }
        return highlightInfoB;
    }

    private void assertNotCreated() {
        if (this.created) {
            throw new IllegalArgumentException("Must not call this method after .create() was called");
        }
    }

    private void assertNotSet(Object field, @NotNull String fieldName) {
        if (fieldName == null) {
            HighlightInfoB.$$$reportNull$$$0(5);
        }
        if (!this.isCopy && field != null) {
            throw new IllegalArgumentException(fieldName + " already set (to " + String.valueOf(field) + ")");
        }
    }

    private void assertNotSet(int field, @NotNull String fieldName) {
        if (fieldName == null) {
            HighlightInfoB.$$$reportNull$$$0(6);
        }
        if (!this.isCopy && field != -2039480982) {
            throw new IllegalArgumentException(fieldName + " already set (to " + field + ")");
        }
    }

    @Override
    @NotNull
    public HighlightInfo.Builder inspectionToolId(@NotNull String inspectionToolId) {
        if (inspectionToolId == null) {
            HighlightInfoB.$$$reportNull$$$0(7);
        }
        this.assertNotCreated();
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(8);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder description(@NotNull String description) {
        if (description == null) {
            HighlightInfoB.$$$reportNull$$$0(9);
        }
        this.assertNotCreated();
        this.assertNotSet(this.escapedDescription, "description");
        this.escapedDescription = description;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(10);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder descriptionAndTooltip(@NotNull String description) {
        if (description == null) {
            HighlightInfoB.$$$reportNull$$$0(11);
        }
        HighlightInfo.Builder builder = this.description(description).unescapedToolTip(description);
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(12);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder textAttributes(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            HighlightInfoB.$$$reportNull$$$0(13);
        }
        this.assertNotCreated();
        this.assertNotSet(this.forcedTextAttributes, "textAttributes");
        this.forcedTextAttributes = attributes;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(14);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
        if (attributesKey == null) {
            HighlightInfoB.$$$reportNull$$$0(15);
        }
        this.assertNotCreated();
        this.assertNotSet(this.forcedTextAttributesKey, "textAttributes");
        this.forcedTextAttributesKey = attributesKey;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(16);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder unescapedToolTip(@NotNull String unescapedToolTip) {
        if (unescapedToolTip == null) {
            HighlightInfoB.$$$reportNull$$$0(17);
        }
        HighlightInfo.Builder builder = this.escapedToolTip(HighlightInfoB.htmlEscapeToolTip(unescapedToolTip));
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(18);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder escapedToolTip(@NotNull String escapedToolTip) {
        if (escapedToolTip == null) {
            HighlightInfoB.$$$reportNull$$$0(19);
        }
        this.assertNotCreated();
        this.assertNotSet(this.escapedToolTip, "tooltip");
        this.escapedToolTip = escapedToolTip;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(20);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(int start, int end) {
        this.assertNotCreated();
        this.assertNotSet(this.startOffset, "Start offset already set");
        this.assertNotSet(this.endOffset, "End offset already set");
        this.startOffset = start;
        this.endOffset = end;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(21);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull TextRange textRange) {
        if (textRange == null) {
            HighlightInfoB.$$$reportNull$$$0(22);
        }
        HighlightInfo.Builder builder = this.range(textRange.getStartOffset(), textRange.getEndOffset());
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(23);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull ASTNode node) {
        if (node == null) {
            HighlightInfoB.$$$reportNull$$$0(24);
        }
        HighlightInfo.Builder builder = this.range(node.getPsi());
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(25);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            HighlightInfoB.$$$reportNull$$$0(26);
        }
        TextRange range = psiElement.getTextRange();
        HighlightInfo.Builder builder = this.range(psiElement, range.getStartOffset(), range.getEndOffset());
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(27);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull PsiElement psiElement, @NotNull TextRange rangeInElement) {
        if (psiElement == null) {
            HighlightInfoB.$$$reportNull$$$0(28);
        }
        if (rangeInElement == null) {
            HighlightInfoB.$$$reportNull$$$0(29);
        }
        TextRange absoluteRange = rangeInElement.shiftRight(psiElement.getTextRange().getStartOffset());
        HighlightInfo.Builder builder = this.range(psiElement, absoluteRange.getStartOffset(), absoluteRange.getEndOffset());
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(30);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder range(@NotNull PsiElement element, int start, int end) {
        if (element == null) {
            HighlightInfoB.$$$reportNull$$$0(31);
        }
        this.assertNotCreated();
        this.assertNotSet(this.psiElement, "psiElement");
        this.psiElement = element;
        HighlightInfo.Builder builder = this.range(start, end);
        if (builder == null) {
            HighlightInfoB.$$$reportNull$$$0(32);
        }
        return builder;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder endOfLine() {
        this.assertNotCreated();
        this.assertNotSet(this.isAfterEndOfLine, "isAfterEndOfLine");
        this.isAfterEndOfLine = true;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(33);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder needsUpdateOnTyping(boolean update) {
        this.assertNotCreated();
        this.assertNotSet(this.myNeedsUpdateOnTyping, "needsUpdateOnTyping");
        this.myNeedsUpdateOnTyping = update;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(34);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder severity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfoB.$$$reportNull$$$0(35);
        }
        this.assertNotCreated();
        this.assertNotSet(this.severity, "severity");
        this.severity = severity;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(36);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder fileLevelAnnotation() {
        this.assertNotCreated();
        this.assertNotSet(this.isFileLevelAnnotation, "isFileLevelAnnotation");
        this.isFileLevelAnnotation = true;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(37);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder navigationShift(int navigationShift) {
        this.assertNotCreated();
        this.assertNotSet(this.navigationShift, "navigationShift");
        this.navigationShift = navigationShift;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(38);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder group(int group) {
        this.assertNotCreated();
        this.assertNotSet(this.group, "group");
        this.group = group;
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(39);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder registerFix(@NotNull IntentionAction action2, @Nullable List<? extends IntentionAction> options, @Nls @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action2 == null) {
            HighlightInfoB.$$$reportNull$$$0(40);
        }
        this.assertNotCreated();
        this.fixes.add(new HighlightInfo.IntentionActionDescriptor(action2, options, displayName, null, key, null, null, fixRange));
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(41);
        }
        return highlightInfoB;
    }

    @Override
    @NotNull
    public HighlightInfo.Builder registerLazyFixes(@NotNull Consumer<? super QuickFixActionRegistrar> quickFixComputer) {
        if (quickFixComputer == null) {
            HighlightInfoB.$$$reportNull$$$0(42);
        }
        this.assertNotCreated();
        this.myLazyFixes.add(quickFixComputer);
        HighlightInfoB highlightInfoB = this;
        if (highlightInfoB == null) {
            HighlightInfoB.$$$reportNull$$$0(43);
        }
        return highlightInfoB;
    }

    @Override
    @Nullable
    public HighlightInfo create() {
        boolean canDeduceTextAttributes;
        HighlightInfo info = this.createUnconditionally();
        boolean bl = canDeduceTextAttributes = this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtil.find(HighlightSeverity.DEFAULT_SEVERITIES, this.severity) != -1;
        if (!canDeduceTextAttributes) {
            LOG.error("Custom severity(" + String.valueOf(this.severity) + ") requires passing not-null PSI element to detect its text attributes. Please see HighlightInfo.Builder.range(PsiElement) and similar methods.");
        }
        return HighlightInfoB.isAcceptedByFilters(info, this.psiElement) ? info : null;
    }

    @Override
    @NotNull
    public HighlightInfo createUnconditionally() {
        this.assertNotCreated();
        this.created = true;
        if (this.severity == null) {
            this.severity = this.type.getSeverity(this.psiElement);
        }
        HighlightInfo info = new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine != null && this.isAfterEndOfLine != false, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation != null && this.isFileLevelAnnotation != false, HighlightInfoB.getValueOrDefault(this.navigationShift), this.problemGroup, null, (GutterMark)this.gutterIconRenderer, HighlightInfoB.getValueOrDefault(this.group), false, this.myLazyFixes);
        List<HighlightInfo.IntentionActionDescriptor> iads = ContainerUtil.map(this.fixes, fixInfo -> fixInfo.withProblemGroupAndSeverity(this.problemGroup, this.severity));
        info.registerFixes(iads, null);
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            HighlightInfoB.$$$reportNull$$$0(44);
        }
        return highlightInfo;
    }

    private static int getValueOrDefault(int field) {
        return field == -2039480982 ? 0 : field;
    }

    @NlsContexts.Tooltip
    @Nullable
    private static String htmlEscapeToolTip(@NlsContexts.Tooltip @Nullable String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(unescapedTooltip));
    }

    static boolean isAcceptedByFilters(@NotNull HighlightInfo info, @Nullable PsiElement psiElement) {
        if (info == null) {
            HighlightInfoB.$$$reportNull$$$0(45);
        }
        PsiFile psiFile = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter2 : HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensionList()) {
            if (filter2.accept(info, psiFile)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    UnfairTextRange getRangeSoFar() {
        return new UnfairTextRange(this.startOffset, this.endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 10, 12, 14, 16, 18, 20, 21, 23, 25, 27, 30, 32, 33, 34, 36, 37, 38, 39, 41, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterIconRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfoB";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolId";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescapedToolTip";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedToolTip";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixComputer";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfoB";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "gutterIconRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "problemGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectionToolId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "description";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "descriptionAndTooltip";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "textAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapedToolTip";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "escapedToolTip";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "endOfLine";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "needsUpdateOnTyping";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "severity";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLevelAnnotation";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "navigationShift";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFix";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "registerLazyFixes";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnconditionally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "gutterIconRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "problemGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertNotSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inspectionToolId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "description";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "descriptionAndTooltip";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "textAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unescapedToolTip";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "escapedToolTip";
                break;
            }
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "severity";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerLazyFixes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByFilters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 10, 12, 14, 16, 18, 20, 21, 23, 25, 27, 30, 32, 33, 34, 36, 37, 38, 39, 41, 43, 44 -> new IllegalStateException(string);
        };
    }
}

