/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.ClassicFileStatusMapState;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatus;
import com.intellij.codeInsight.daemon.impl.FileStatusMapState;
import com.intellij.codeInsight.daemon.impl.MultiverseFileStatusMapState;
import com.intellij.codeInsight.daemon.impl.WholeFileDirtyMarker;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInsight.multiverse.EditorContextManager;
import com.intellij.codeInsight.multiverse.FileViewProviderUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileStatusMap
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileStatusMap.class);
    public static final String CHANGES_NOT_ALLOWED_DURING_HIGHLIGHTING = "PSI/document/model changes are not allowed during highlighting, because it leads to the daemon unnecessary restarts. If you really do need to start write action during the highlighting, you can pass `canChangeDocument=true` to the CodeInsightTestFixtureImpl#instantiateAndRun() and accept the daemon unresponsiveness/blinking/slowdowns.";
    private final Project myProject;
    private final FileStatusMapState myDocumentToStatusMap;
    private final Key<RangeMarker> COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY;
    private volatile boolean myAllowDirt;
    static final RangeMarker WHOLE_FILE_DIRTY_MARKER = new RangeMarker(){

        @Override
        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void dispose() {
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                1.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @NonNls
        public String toString() {
            return "WHOLE_FILE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final ConcurrentMap<Thread, Integer> threads = CollectionFactory.createConcurrentWeakMap();

    @ApiStatus.Internal
    public FileStatusMap(@NotNull Project project) {
        if (project == null) {
            FileStatusMap.$$$reportNull$$$0(0);
        }
        this.COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY = Key.create("COMPOSITE_DOCUMENT_CHANGE_KEY");
        this.myAllowDirt = true;
        this.myProject = project;
        this.myDocumentToStatusMap = CodeInsightContexts.isSharedSourceSupportEnabled(project) ? new MultiverseFileStatusMapState(project) : new ClassicFileStatusMapState(project);
    }

    @Override
    public void dispose() {
        this.markAllFilesDirty("FileStatusMap dispose");
    }

    @Deprecated
    @Nullable(value="null means the file is clean")
    public static @Nullable(value="null means the file is clean") TextRange getDirtyTextRange(@NotNull Editor editor, int passId) {
        if (editor == null) {
            FileStatusMap.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        CodeInsightContext context = EditorContextManager.getEditorContext((Editor)editor, (Project)project);
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getPsiFile(document, context);
        return psiFile == null ? null : FileStatusMap.getDirtyTextRange(document, context, psiFile, passId);
    }

    @Nullable(value="null means the file is clean")
    public static @Nullable(value="null means the file is clean") TextRange getDirtyTextRange(@NotNull Document document, @NotNull PsiFile psiFile, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            FileStatusMap.$$$reportNull$$$0(3);
        }
        CodeInsightContext context = FileViewProviderUtil.getCodeInsightContext(psiFile);
        return FileStatusMap.getDirtyTextRange(document, context, psiFile, passId);
    }

    @ApiStatus.Internal
    @Nullable(value="null means the file is clean")
    public static @Nullable(value="null means the file is clean") TextRange getDirtyTextRange(@NotNull Document document, @NotNull CodeInsightContext context, @NotNull PsiFile psiFile, int passId) {
        Project project;
        FileStatusMap me;
        TextRange dirtyScope;
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(4);
        }
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            FileStatusMap.$$$reportNull$$$0(6);
        }
        if ((dirtyScope = (me = DaemonCodeAnalyzerEx.getInstanceEx(project = psiFile.getProject()).getFileStatusMap()).getFileDirtyScope(document, context, psiFile, passId)) == null) {
            return null;
        }
        TextRange documentRange = TextRange.from(0, document.getTextLength());
        return documentRange.intersection(dirtyScope);
    }

    public void setErrorFoundFlag(@NotNull Project project, @NotNull Document document, boolean errorFound) {
        if (project == null) {
            FileStatusMap.$$$reportNull$$$0(7);
        }
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(8);
        }
        this.setErrorFoundFlag(document, CodeInsightContexts.anyContext(), errorFound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void setErrorFoundFlag(@NotNull Document document, @NotNull CodeInsightContext context, boolean errorFound) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(9);
        }
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(10);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            FileStatus status = this.myDocumentToStatusMap.getOrCreateStatus(document, context);
            status.setErrorFound(errorFound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean wasErrorFound(@NotNull Document document, @NotNull CodeInsightContext context) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(11);
        }
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(12);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            FileStatus status = this.myDocumentToStatusMap.getStatusOrNull(document, context);
            return status != null && status.isErrorFound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void markAllFilesDirty(@NotNull @NonNls Object reason) {
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(13);
        }
        this.assertAllowModifications();
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            if (!this.myDocumentToStatusMap.isEmpty()) {
                FileStatusMap.log(null, "Mark all dirty: ", reason, null);
            }
            this.myDocumentToStatusMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @TestOnly
    public void assertFileStatusScopeIsNull(Document document, @NotNull CodeInsightContext context, int passId) {
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(14);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            FileStatus status = this.myDocumentToStatusMap.getStatusOrNull(document, context);
            assert (status != null && status.getDirtyScope(passId) == null) : status;
        }
    }

    private void assertAllowModifications() {
        if (!this.myAllowDirt) {
            this.myAllowDirt = true;
            throw new AssertionError((Object)CHANGES_NOT_ALLOWED_DURING_HIGHLIGHTING);
        }
    }

    public void markFileUpToDate(@NotNull Document document, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(15);
        }
        this.markFileUpToDate(document, CodeInsightContexts.anyContext(), passId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void markFileUpToDate(@NotNull Document document, @NotNull CodeInsightContext context, int passId, ProgressIndicator indicator) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(16);
        }
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(17);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            FileStatus status = this.myDocumentToStatusMap.getOrCreateStatus(document, context);
            status.setDefensivelyMarked(false);
            if (passId == 9) {
                status.setWolfPassFinished();
            } else if (status.containsDirtyScope(passId)) {
                RangeMarker wasScope = status.getDirtyScope(passId);
                if (wasScope != null && LOG.isTraceEnabled()) {
                    LOG.trace("markFileUpToDate: " + passId + " (was " + String.valueOf(wasScope) + "); indicator:" + String.valueOf(indicator));
                }
                status.setDirtyScope(passId, null);
            }
            if (status.allDirtyScopesAreNull()) {
                this.disposeDirtyDocumentRangeStorage(document);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public TextRange getFileDirtyScopeForAllPassesCombined(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(18);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            Collection<FileStatus> statuses = this.myDocumentToStatusMap.getFileStatuses(document);
            if (statuses.isEmpty()) {
                return null;
            }
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            for (FileStatus status : statuses) {
                for (RangeMarker marker : status.getAllDirtyScopes()) {
                    if (marker == null || marker == WholeFileDirtyMarker.INSTANCE || !marker.isValid()) continue;
                    TextRange markerRange = marker.getTextRange();
                    start = Math.min(start, markerRange.getStartOffset());
                    end = Math.max(end, markerRange.getEndOffset());
                }
            }
            return start == Integer.MAX_VALUE ? null : new TextRange(start, end);
        }
    }

    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, @NotNull PsiFile psiFile, int passId) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(19);
        }
        if (psiFile == null) {
            FileStatusMap.$$$reportNull$$$0(20);
        }
        CodeInsightContext context = FileViewProviderUtil.getCodeInsightContext(psiFile);
        return this.getFileDirtyScope(document, context, psiFile, passId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public TextRange getFileDirtyScope(@NotNull Document document, @NotNull CodeInsightContext context, @NotNull PsiFile psiFile, int passId) {
        RangeMarker marker;
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(21);
        }
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(22);
        }
        if (psiFile == null) {
            FileStatusMap.$$$reportNull$$$0(23);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            FileStatus status = this.myDocumentToStatusMap.getStatusOrNull(document, context);
            if (status == null) {
                marker = WholeFileDirtyMarker.INSTANCE;
            } else {
                if (status.isDefensivelyMarked()) {
                    status.markWholeFileDirty(this.myProject);
                    status.setDefensivelyMarked(false);
                }
                FileStatusMap.assertPassIsRegistered(passId, status);
                marker = status.getDirtyScope(passId);
            }
        }
        if (marker == null) {
            return null;
        }
        if (marker == WholeFileDirtyMarker.INSTANCE) {
            return psiFile.getTextRange();
        }
        return marker.isValid() ? marker.getTextRange() : new TextRange(0, document.getTextLength());
    }

    private static void assertPassIsRegistered(int passId, @NotNull FileStatus status) {
        if (status == null) {
            FileStatusMap.$$$reportNull$$$0(24);
        }
        if (!status.containsDirtyScope(passId)) {
            throw new IllegalStateException("Unknown pass " + passId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void markFileScopeDirtyDefensively(@NotNull Document document, @NotNull @NonNls Object reason) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(25);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(26);
        }
        this.assertAllowModifications();
        FileStatusMap.log(document, "Mark dirty file defensively: ", reason, null);
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            for (FileStatus status : this.myDocumentToStatusMap.getFileStatuses(document)) {
                status.setDefensivelyMarked(true);
            }
        }
    }

    @ApiStatus.Internal
    public void markWholeFileScopeDirty(@NotNull Document document, @NotNull @NonNls Object reason) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(27);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(28);
        }
        this.combineDirtyScopes(document, FileStatus.WHOLE_FILE_TEXT_RANGE, reason);
    }

    @ApiStatus.Internal
    public void markScopeDirty(@NotNull Document document, @NotNull TextRange scope, @NotNull @NonNls Object reason) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            FileStatusMap.$$$reportNull$$$0(30);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.combineDirtyScopes(document, scope, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combineDirtyScopes(@NotNull Document document, @NotNull TextRange scope, @NonNls @NotNull Object reason) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            FileStatusMap.$$$reportNull$$$0(33);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(34);
        }
        this.assertAllowModifications();
        FileStatusMap.log(document, "Mark scope dirty: ", reason, scope);
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            for (FileStatus status : this.myDocumentToStatusMap.getFileStatuses(document)) {
                if (status.isDefensivelyMarked()) {
                    status.setDefensivelyMarked(false);
                }
                status.combineScopesWith(scope, document);
            }
        }
    }

    public boolean allDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(35);
        }
        return this.allDirtyScopesAreNull(document, CodeInsightContexts.anyContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean allDirtyScopesAreNull(@NotNull Document document, @NotNull CodeInsightContext context) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(36);
        }
        if (context == null) {
            FileStatusMap.$$$reportNull$$$0(37);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            FileStatus status = this.myDocumentToStatusMap.getStatusOrNull(document, context);
            return status != null && !status.isDefensivelyMarked() && status.isWolfPassFinished() && status.allDirtyScopesAreNull();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(38);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            return this.myDocumentToStatusMap.toString(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void assertAllDirtyScopesAreNull(@NotNull Document document) {
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(39);
        }
        FileStatusMapState fileStatusMapState = this.myDocumentToStatusMap;
        synchronized (fileStatusMapState) {
            for (FileStatus status : this.myDocumentToStatusMap.getFileStatuses(document)) {
                assert (status != null && !status.isDefensivelyMarked() && status.isWolfPassFinished() && status.allDirtyScopesAreNull()) : status;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @ApiStatus.Internal
    public <E extends Exception> void runAllowingDirt(boolean allowDirt, @NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            FileStatusMap.$$$reportNull$$$0(40);
        }
        boolean old = this.myAllowDirt;
        try {
            this.myAllowDirt = allowDirt;
            runnable.run();
        }
        finally {
            this.myAllowDirt = old;
        }
    }

    private static int getThreadNum() {
        return threads.computeIfAbsent(Thread.currentThread(), thread -> threads.size());
    }

    private static void log(@Nullable Document document, @NonNls @NotNull String msg, @NonNls @NotNull Object reason, @NonNls Object additionalInfo) {
        if (msg == null) {
            FileStatusMap.$$$reportNull$$$0(41);
        }
        if (reason == null) {
            FileStatusMap.$$$reportNull$$$0(42);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(StringUtil.repeatSymbol(' ', FileStatusMap.getThreadNum() * 4) + (String)(document == null ? "" : String.valueOf(document) + "; ") + msg + String.valueOf(reason) + (String)(additionalInfo == null ? "" : "; " + String.valueOf(additionalInfo)));
        }
    }

    @ApiStatus.Internal
    public void addDocumentDirtyRange(@NotNull DocumentEvent event) {
        RangeMarker combined;
        Document document;
        RangeMarker oldRange;
        if (event == null) {
            FileStatusMap.$$$reportNull$$$0(43);
        }
        if ((oldRange = (document = event.getDocument()).getUserData(this.COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY)) != WholeFileDirtyMarker.INSTANCE && oldRange != null && oldRange.isValid() && oldRange.getTextRange().containsRange(event.getOffset(), event.getOffset() + event.getNewLength())) {
            return;
        }
        TextRange scope = new TextRange(event.getOffset(), Math.min(event.getOffset() + event.getNewLength(), document.getTextLength()));
        RangeMarker rangeMarker = combined = oldRange == WholeFileDirtyMarker.INSTANCE || event.isWholeTextReplaced() || scope.getStartOffset() == 0 && scope.getEndOffset() == document.getTextLength() ? WholeFileDirtyMarker.INSTANCE : FileStatus.combineScopes(oldRange, scope, document);
        if (combined != WholeFileDirtyMarker.INSTANCE) {
            combined.setGreedyToRight(true);
            combined.setGreedyToLeft(true);
        }
        document.putUserData(this.COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY, combined);
    }

    @NotNull
    @ApiStatus.Internal
    public TextRange getCompositeDocumentDirtyRange(@NotNull Document document) {
        RangeMarker change;
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(44);
        }
        TextRange textRange = (change = document.getUserData(this.COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY)) == WholeFileDirtyMarker.INSTANCE ? new TextRange(0, document.getTextLength()) : (change == null || !change.isValid() ? TextRange.EMPTY_RANGE : change.getTextRange());
        if (textRange == null) {
            FileStatusMap.$$$reportNull$$$0(45);
        }
        return textRange;
    }

    @ApiStatus.Internal
    public void disposeDirtyDocumentRangeStorage(@NotNull Document document) {
        RangeMarker marker;
        if (document == null) {
            FileStatusMap.$$$reportNull$$$0(46);
        }
        if ((marker = document.getUserData(this.COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY)) != null) {
            marker.dispose();
            document.putUserData(this.COMPOSITE_DOCUMENT_DIRTY_RANGE_KEY, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/FileStatusMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/FileStatusMap";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeDocumentDirtyRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyTextRange";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setErrorFoundFlag";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wasErrorFound";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "markAllFilesDirty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "assertFileStatusScopeIsNull";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markFileUpToDate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileDirtyScopeForAllPassesCombined";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFileDirtyScope";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "assertPassIsRegistered";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "markFileScopeDirtyDefensively";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "markWholeFileScopeDirty";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "markScopeDirty";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "combineDirtyScopes";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "allDirtyScopesAreNull";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "assertAllDirtyScopesAreNull";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runAllowingDirt";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentDirtyRange";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeDocumentDirtyRange";
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "disposeDirtyDocumentRangeStorage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 45 -> new IllegalStateException(string);
        };
    }
}

