/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final Key<CachedStampedMap> CACHED_DIVIDED_ELEMENTS_KEY = Key.create("CACHED_DIVIDED_ELEMENTS");
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutsideAllRoots(@NotNull PsiFile psiFile, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @Nullable Predicate<? super PsiFile> rootFilter, @NotNull Processor<? super DividedElements> processor) {
        if (psiFile == null) {
            Divider.$$$reportNull$$$0(0);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(3);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        for (PsiFile root : viewProvider.getAllFiles()) {
            if (rootFilter == null || !rootFilter.test(root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, TextRangeScalarUtil.toScalarRange(restrictRange), TextRangeScalarUtil.toScalarRange(priorityRange), processor);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, long restrictRange, long priorityRange, @NotNull Processor<? super DividedElements> processor) {
        void processor2;
        DividedElements elements;
        CachedStampedMap cache2;
        if (root == null) {
            Divider.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(5);
        }
        long modificationStamp = root.getModificationStamp();
        while (true) {
            if ((cache2 = root.getUserData(CACHED_DIVIDED_ELEMENTS_KEY)) != null && cache2.modificationStamp == modificationStamp) break;
            ((UserDataHolderEx)((Object)root)).replace(CACHED_DIVIDED_ELEMENTS_KEY, cache2, new CachedStampedMap(modificationStamp, ConcurrentCollectionFactory.createConcurrentLongObjectMap()));
        }
        ConcurrentLongObjectMap<Reference<DividedElements>> cachedMap = cache2.elements();
        DividedElements cached = SoftReference.dereference(cachedMap.get(restrictRange));
        if (cached != null && TextRangeScalarUtil.contains(cached.priorityRange, priorityRange)) {
            elements = cached;
        } else {
            ArrayList<PsiElement> inside = new ArrayList<PsiElement>();
            LongArrayList insideRanges = new LongArrayList();
            ArrayList<PsiElement> outside = new ArrayList<PsiElement>();
            LongArrayList outsideRanges = new LongArrayList();
            ArrayList parents2 = new ArrayList();
            LongArrayList parentRanges = new LongArrayList();
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, inside, insideRanges, outside, outsideRanges, parents2, parentRanges);
            elements = new DividedElements(root, priorityRange, inside, insideRanges, outside, outsideRanges, parents2, parentRanges);
            cachedMap.put(restrictRange, new java.lang.ref.SoftReference<DividedElements>(elements));
        }
        processor2.process(elements);
    }

    /*
     * WARNING - void declaration
     */
    private static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, long restrictRange, long priorityRange, @NotNull List<PsiElement> inside, @NotNull LongList insideRanges, @NotNull List<PsiElement> outside, @NotNull LongList outsideRanges, @NotNull List<? super PsiElement> list, @NotNull LongList longList) {
        void outParentRanges;
        void outParents;
        PsiElement parent;
        if (root == null) {
            Divider.$$$reportNull$$$0(6);
        }
        if (inside == null) {
            Divider.$$$reportNull$$$0(7);
        }
        if (insideRanges == null) {
            Divider.$$$reportNull$$$0(8);
        }
        if (outside == null) {
            Divider.$$$reportNull$$$0(9);
        }
        if (outsideRanges == null) {
            Divider.$$$reportNull$$$0(10);
        }
        if (list == null) {
            Divider.$$$reportNull$$$0(11);
        }
        if (longList == null) {
            Divider.$$$reportNull$$$0(12);
        }
        int startOffset = TextRangeScalarUtil.startOffset(restrictRange);
        int endOffset = TextRangeScalarUtil.endOffset(restrictRange);
        List<Condition<PsiElement>> filters = CollectHighlightsUtil.EP_NAME.getExtensionList();
        IntArrayList starts = new IntArrayList(10);
        starts.push(startOffset);
        Stack<PsiFile> elements = new Stack<PsiFile>(10);
        Stack<PsiElement> children2 = new Stack<PsiElement>(10);
        PsiElement element = root;
        PsiElement child = HAVE_TO_GET_CHILDREN;
        int offset = 0;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition<PsiElement> filter2 : filters) {
                if (filter2.value(element)) continue;
                assert (child == HAVE_TO_GET_CHILDREN);
                child = null;
                break;
            }
            if (child == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                int start;
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (startOffset <= (start = starts.popInt()) && offset <= endOffset) {
                    if (TextRangeScalarUtil.containsRange(priorityRange, start, offset)) {
                        inside.add(element);
                        insideRanges.add(TextRangeScalarUtil.toScalarRange(start, offset));
                    } else {
                        outside.add(element);
                        outsideRanges.add(TextRangeScalarUtil.toScalarRange(start, offset));
                    }
                }
                if (elements.isEmpty()) break;
                element = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset > endOffset) break;
            children2.push(child.getNextSibling());
            starts.push(offset);
            elements.push((PsiFile)element);
            element = child;
            child = HAVE_TO_GET_CHILDREN;
        }
        PsiElement psiElement = !outside.isEmpty() ? outside.get(outside.size() - 1) : (parent = !inside.isEmpty() ? inside.get(inside.size() - 1) : CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset));
        while (parent != null && !(parent instanceof PsiFile)) {
            if ((parent = parent.getParent()) == null) continue;
            outParents.add(parent);
            TextRange textRange = parent.getTextRange();
            assert (textRange != null) : "Text range for " + String.valueOf(parent) + " is null. " + String.valueOf(parent.getClass()) + "; root: " + String.valueOf(root) + ": " + String.valueOf(root.getVirtualFile());
            outParentRanges.add(TextRangeScalarUtil.toScalarRange(textRange));
        }
        assert (inside.size() == insideRanges.size());
        assert (outside.size() == outsideRanges.size());
        assert (outParents.size() == outParentRanges.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideRanges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outsideRanges";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParents";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParentRanges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideAllRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideInOneRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record CachedStampedMap(long modificationStamp, @NotNull ConcurrentLongObjectMap<Reference<DividedElements>> elements) {
        @NotNull
        private final ConcurrentLongObjectMap<Reference<DividedElements>> elements;

        /*
         * WARNING - void declaration
         */
        private CachedStampedMap(long modificationStamp, @NotNull ConcurrentLongObjectMap<Reference<DividedElements>> concurrentLongObjectMap) {
            void elements;
            if (concurrentLongObjectMap == null) {
                CachedStampedMap.$$$reportNull$$$0(0);
            }
            this.modificationStamp = modificationStamp;
            this.elements = elements;
        }

        @NotNull
        public ConcurrentLongObjectMap<Reference<DividedElements>> elements() {
            ConcurrentLongObjectMap<Reference<DividedElements>> concurrentLongObjectMap = this.elements;
            if (concurrentLongObjectMap == null) {
                CachedStampedMap.$$$reportNull$$$0(1);
            }
            return concurrentLongObjectMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/Divider$CachedStampedMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider$CachedStampedMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public record DividedElements(@NotNull PsiFile psiRoot, long priorityRange, @NotNull @NotNull List<? extends @NotNull PsiElement> inside, @NotNull LongList insideRanges, @NotNull @NotNull List<? extends @NotNull PsiElement> outside, @NotNull LongList outsideRanges, @NotNull @NotNull List<? extends @NotNull PsiElement> parents, @NotNull LongList parentRanges) {
        @NotNull
        private final PsiFile psiRoot;
        @NotNull
        private final @NotNull List<? extends @NotNull PsiElement> inside;
        @NotNull
        private final LongList insideRanges;
        @NotNull
        private final @NotNull List<? extends @NotNull PsiElement> outside;
        @NotNull
        private final LongList outsideRanges;
        @NotNull
        private final @NotNull List<? extends @NotNull PsiElement> parents;
        @NotNull
        private final LongList parentRanges;

        /*
         * WARNING - void declaration
         */
        public DividedElements(@NotNull PsiFile psiRoot, long priorityRange, @NotNull @NotNull List<? extends @NotNull PsiElement> inside, @NotNull LongList insideRanges, @NotNull @NotNull List<? extends @NotNull PsiElement> outside, @NotNull LongList outsideRanges, @NotNull @NotNull List<? extends @NotNull PsiElement> parents2, @NotNull LongList longList) {
            void parentRanges;
            if (psiRoot == null) {
                DividedElements.$$$reportNull$$$0(0);
            }
            if (inside == null) {
                DividedElements.$$$reportNull$$$0(1);
            }
            if (insideRanges == null) {
                DividedElements.$$$reportNull$$$0(2);
            }
            if (outside == null) {
                DividedElements.$$$reportNull$$$0(3);
            }
            if (outsideRanges == null) {
                DividedElements.$$$reportNull$$$0(4);
            }
            if (parents2 == null) {
                DividedElements.$$$reportNull$$$0(5);
            }
            if (longList == null) {
                DividedElements.$$$reportNull$$$0(6);
            }
            this.psiRoot = psiRoot;
            this.priorityRange = priorityRange;
            this.inside = inside;
            this.insideRanges = insideRanges;
            this.outside = outside;
            this.outsideRanges = outsideRanges;
            this.parents = parents2;
            this.parentRanges = parentRanges;
        }

        @NotNull
        public PsiFile psiRoot() {
            PsiFile psiFile = this.psiRoot;
            if (psiFile == null) {
                DividedElements.$$$reportNull$$$0(7);
            }
            return psiFile;
        }

        @NotNull
        public @NotNull List<? extends @NotNull PsiElement> inside() {
            List<? extends PsiElement> list = this.inside;
            if (list == null) {
                DividedElements.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public LongList insideRanges() {
            LongList longList = this.insideRanges;
            if (longList == null) {
                DividedElements.$$$reportNull$$$0(9);
            }
            return longList;
        }

        @NotNull
        public @NotNull List<? extends @NotNull PsiElement> outside() {
            List<? extends PsiElement> list = this.outside;
            if (list == null) {
                DividedElements.$$$reportNull$$$0(10);
            }
            return list;
        }

        @NotNull
        public LongList outsideRanges() {
            LongList longList = this.outsideRanges;
            if (longList == null) {
                DividedElements.$$$reportNull$$$0(11);
            }
            return longList;
        }

        @NotNull
        public @NotNull List<? extends @NotNull PsiElement> parents() {
            List<? extends PsiElement> list = this.parents;
            if (list == null) {
                DividedElements.$$$reportNull$$$0(12);
            }
            return list;
        }

        @NotNull
        public LongList parentRanges() {
            LongList longList = this.parentRanges;
            if (longList == null) {
                DividedElements.$$$reportNull$$$0(13);
            }
            return longList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inside";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insideRanges";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outside";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outsideRanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parents";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentRanges";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/Divider$DividedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider$DividedElements";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiRoot";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inside";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insideRanges";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "outside";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "outsideRanges";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parents";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parentRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

