/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.StatisticsComparable;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class StatisticsWeigher
extends CompletionWeigher {
    private static final Logger LOG = Logger.getInstance(StatisticsWeigher.class);
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create("Base statistics info");

    @Override
    public Comparable weigh(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        if (item == null) {
            StatisticsWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            StatisticsWeigher.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(LookupElement item) {
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(LookupElement item, @Nullable CompletionLocation location) {
        StatisticsInfo info = BASE_STATISTICS_INFO.get(item);
        if (info == null) {
            if (location == null) {
                StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                if (statisticsInfo == null) {
                    StatisticsWeigher.$$$reportNull$$$0(2);
                }
                return statisticsInfo;
            }
            info = StatisticsWeigher.calcBaseInfo(item, location);
            BASE_STATISTICS_INFO.set(item, info);
        }
        StatisticsInfo statisticsInfo = info;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(3);
        }
        return statisticsInfo;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(LookupElement item, @NotNull CompletionLocation location) {
        StatisticsInfo info;
        if (location == null) {
            StatisticsWeigher.$$$reportNull$$$0(4);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !location.getCompletionParameters().isTestingMode()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        StatisticsInfo statisticsInfo = (info = StatisticsManager.serialize(CompletionService.STATISTICS_KEY, item, location)) == null ? StatisticsInfo.EMPTY : info;
        if (statisticsInfo == null) {
            StatisticsWeigher.$$$reportNull$$$0(5);
        }
        return statisticsInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStatisticsInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBaseInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcBaseInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        private final CompletionLocation myLocation;
        private final Map<LookupElement, StatisticsComparable> myWeights = new IdentityHashMap<LookupElement, StatisticsComparable>();
        private final Set<String> myStringsWithWeights = CollectionFactory.createSmallMemoryFootprintSet();
        private final Set<LookupElement> myNoStats = new ReferenceOpenHashSet<LookupElement>();
        private final List<Function<@NotNull LookupElement, @Nullable StatisticsInfo>> mySerializers;

        public LookupStatisticsWeigher(CompletionLocation location, Classifier<LookupElement> next) {
            super(next, "stats");
            this.myLocation = location;
            this.mySerializers = this.myLocation == null ? List.of() : ContainerUtil.map(StatisticsManager.COLLECTOR.forKey(CompletionService.STATISTICS_KEY), stat -> ((CompletionStatistician)stat).forLocation(this.myLocation));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(0);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(1);
            }
            StatisticsInfo baseInfo = this.getBaseStatisticsInfo(element);
            int weight = LookupStatisticsWeigher.weigh(baseInfo);
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                if (weight != 0) {
                    this.myWeights.put(element, new StatisticsComparable(weight, baseInfo));
                    this.myStringsWithWeights.add(element.getLookupString());
                }
                if (baseInfo == StatisticsInfo.EMPTY) {
                    this.myNoStats.add(element);
                }
            }
            super.addElement(element, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
            Collection byWeight;
            List<LookupElement> initialList;
            if (source == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(2);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(3);
            }
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                initialList = this.getInitialNoStatElements(source, context);
                Iterable<LookupElement> rest = LookupStatisticsWeigher.withoutInitial(source, initialList);
                byWeight = this.buildMapByWeight(rest).descendingMap().values();
            }
            JBIterable jBIterable = JBIterable.from(initialList).append((LookupElement)((Object)JBIterable.from(byWeight).flatten(group -> this.myNext.classify(group, context))));
            if (jBIterable == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static Iterable<LookupElement> withoutInitial(Iterable<? extends LookupElement> allItems, List<? extends LookupElement> initial) {
            ReferenceOpenHashSet<? extends LookupElement> initialSet = new ReferenceOpenHashSet<LookupElement>(initial);
            return JBIterable.from(allItems).filter(element -> !initialSet.contains(element));
        }

        private List<LookupElement> getInitialNoStatElements(Iterable<? extends LookupElement> source, ProcessingContext context) {
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : this.myNext.classify(source, context)) {
                if (!this.myNoStats.contains(lookupElement)) break;
                initialList.add(lookupElement);
            }
            return initialList;
        }

        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(Iterable<? extends LookupElement> source) {
            MultiMap<String, LookupElement> byName = MultiMap.create();
            ArrayList<LookupElement> noStats = new ArrayList<LookupElement>();
            for (LookupElement lookupElement : source) {
                String string = lookupElement.getLookupString();
                if (this.myStringsWithWeights.contains(string)) {
                    byName.putValue(string, lookupElement);
                    continue;
                }
                noStats.add(lookupElement);
            }
            TreeMap<Integer, List<LookupElement>> map2 = new TreeMap<Integer, List<LookupElement>>();
            map2.put(0, noStats);
            for (String s : byName.keySet()) {
                List group = (List)byName.get(s);
                group.sort(Comparator.comparing(this::getScalarWeight).reversed());
                map2.computeIfAbsent(this.getMaxWeight(group), __ -> new ArrayList()).addAll(group);
            }
            return map2;
        }

        private int getMaxWeight(List<? extends LookupElement> group) {
            int max = 0;
            for (int i = 0; i < group.size(); ++i) {
                max = Math.max(max, this.getScalarWeight(group.get(i)));
            }
            return max;
        }

        private int getScalarWeight(LookupElement e) {
            StatisticsComparable comparable = this.myWeights.get(e);
            return comparable == null ? 0 : comparable.getScalar();
        }

        private StatisticsComparable getWeight(LookupElement t) {
            StatisticsComparable w = this.myWeights.get(t);
            if (w == null) {
                StatisticsInfo info = this.getBaseStatisticsInfo(t);
                w = new StatisticsComparable(LookupStatisticsWeigher.weigh(info), info);
                this.myWeights.put(t, w);
            }
            return w;
        }

        private static int weigh(StatisticsInfo baseInfo) {
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            int minRecency = StatisticsManager.getInstance().getLastUseRecency(baseInfo);
            return minRecency == Integer.MAX_VALUE ? 0 : 10000 - minRecency;
        }

        @Override
        public @Unmodifiable @NotNull List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
            if (items == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(5);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(6);
            }
            List<Pair<LookupElement, Object>> list = ContainerUtil.map(items, lookupElement -> new Pair<LookupElement, StatisticsComparable>((LookupElement)lookupElement, this.getWeight((LookupElement)lookupElement)));
            if (list == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(7);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElement(@NotNull LookupElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(8);
            }
            if (context == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(9);
            }
            LookupStatisticsWeigher lookupStatisticsWeigher = this;
            synchronized (lookupStatisticsWeigher) {
                this.myWeights.remove(element);
                this.myNoStats.remove(element);
            }
            super.removeElement(element, context);
        }

        @NotNull
        private StatisticsInfo getBaseStatisticsInfo(LookupElement item) {
            StatisticsInfo info = BASE_STATISTICS_INFO.get(item);
            if (info == null) {
                if (this.myLocation == null) {
                    StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                    if (statisticsInfo == null) {
                        LookupStatisticsWeigher.$$$reportNull$$$0(10);
                    }
                    return statisticsInfo;
                }
                info = this.calcBaseInfo(item);
                BASE_STATISTICS_INFO.set(item, info);
            }
            StatisticsInfo statisticsInfo = info;
            if (statisticsInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(11);
            }
            return statisticsInfo;
        }

        @NotNull
        private StatisticsInfo calcBaseInfo(LookupElement item) {
            if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myLocation.getCompletionParameters().isTestingMode()) {
                ApplicationManager.getApplication().assertIsNonDispatchThread();
            }
            for (Function<LookupElement, StatisticsInfo> serializer2 : this.mySerializers) {
                StatisticsInfo info = serializer2.apply(item);
                if (info == null) continue;
                StatisticsInfo statisticsInfo = info;
                if (statisticsInfo == null) {
                    LookupStatisticsWeigher.$$$reportNull$$$0(12);
                }
                return statisticsInfo;
            }
            StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
            if (statisticsInfo == null) {
                LookupStatisticsWeigher.$$$reportNull$$$0(13);
            }
            return statisticsInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseStatisticsInfo";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcBaseInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
                case 4: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElement";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

