/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.DeclarativeInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/completion/SingleInsertionDeclarativeInsertHandler;", "Lcom/intellij/codeInsight/completion/DeclarativeInsertHandler;", "stringToInsert", "", "popupOptions", "Lcom/intellij/codeInsight/completion/DeclarativeInsertHandler$PopupOptions;", "<init>", "(Ljava/lang/String;Lcom/intellij/codeInsight/completion/DeclarativeInsertHandler$PopupOptions;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isValueAlreadyHere", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.analysis.impl"})
@ApiStatus.Experimental
public final class SingleInsertionDeclarativeInsertHandler
extends DeclarativeInsertHandler {
    @NotNull
    private final String stringToInsert;

    public SingleInsertionDeclarativeInsertHandler(@NotNull String stringToInsert, @NotNull DeclarativeInsertHandler.PopupOptions popupOptions) {
        Intrinsics.checkNotNullParameter((Object)stringToInsert, (String)"stringToInsert");
        Intrinsics.checkNotNullParameter((Object)popupOptions, (String)"popupOptions");
        super(CollectionsKt.listOf((Object)new DeclarativeInsertHandler.RelativeTextEdit(0, 0, stringToInsert)), stringToInsert.length(), null, null, popupOptions);
        this.stringToInsert = stringToInsert;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        boolean applyTextOperations = !this.isValueAlreadyHere(editor);
        this.conditionalHandleInsert(context, item, applyTextOperations);
    }

    private final boolean isValueAlreadyHere(Editor editor) {
        int startOffset = editor.getCaretModel().getOffset();
        int valueLength = this.stringToInsert.length();
        return editor.getDocument().getTextLength() >= startOffset + valueLength && Intrinsics.areEqual((Object)editor.getDocument().getText(TextRange.create(startOffset, startOffset + valueLength)), (Object)this.stringToInsert);
    }
}

