/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertionContext {
    public static final OffsetKey TAIL_OFFSET = OffsetKey.create("tailOffset", true);
    private final OffsetMap myOffsetMap;
    private final char myCompletionChar;
    private final LookupElement[] myElements;
    private final PsiFile myPsiFile;
    private final Editor myEditor;
    private Runnable myLaterRunnable;
    private boolean myAddCompletionChar;

    public InsertionContext(OffsetMap offsetMap, char completionChar, LookupElement[] elements, @NotNull PsiFile psiFile, @NotNull Editor editor, boolean addCompletionChar) {
        if (psiFile == null) {
            InsertionContext.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            InsertionContext.$$$reportNull$$$0(1);
        }
        this.myOffsetMap = offsetMap;
        this.myCompletionChar = completionChar;
        this.myElements = elements;
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.setTailOffset(editor.getCaretModel().getOffset());
        this.myAddCompletionChar = addCompletionChar;
    }

    public void setTailOffset(int offset) {
        this.myOffsetMap.addOffset(TAIL_OFFSET, offset);
    }

    public int getTailOffset() {
        return this.myOffsetMap.getOffset(TAIL_OFFSET);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            InsertionContext.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            InsertionContext.$$$reportNull$$$0(3);
        }
        return editor;
    }

    public void commitDocument() {
        PsiDocumentManager.getInstance(this.getProject()).commitDocument(this.getDocument());
    }

    @NotNull
    public Document getDocument() {
        Document document = this.getEditor().getDocument();
        if (document == null) {
            InsertionContext.$$$reportNull$$$0(4);
        }
        return document;
    }

    public int getOffset(OffsetKey key) {
        return this.getOffsetMap().getOffset(key);
    }

    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    public OffsetKey trackOffset(int offset, boolean movableToRight) {
        OffsetKey key = OffsetKey.create("tracked", movableToRight);
        this.getOffsetMap().addOffset(key, offset);
        return key;
    }

    public int getStartOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.START_OFFSET);
    }

    public char getCompletionChar() {
        return this.myCompletionChar;
    }

    public LookupElement[] getElements() {
        return this.myElements;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPsiFile.getProject();
        if (project == null) {
            InsertionContext.$$$reportNull$$$0(5);
        }
        return project;
    }

    public int getSelectionEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    @Nullable
    public Runnable getLaterRunnable() {
        return this.myLaterRunnable;
    }

    public void setLaterRunnable(@Nullable Runnable laterRunnable) {
        this.myLaterRunnable = laterRunnable;
    }

    public void setAddCompletionChar(boolean addCompletionChar) {
        this.myAddCompletionChar = addCompletionChar;
    }

    public boolean shouldAddCompletionChar() {
        return this.myAddCompletionChar;
    }

    public static boolean shouldAddCompletionChar(char completionChar) {
        return completionChar != '\u0000' && completionChar != '\t' && completionChar != '\n';
    }

    public InsertionContext forkByOffsetMap() {
        return new InsertionContext(this.myOffsetMap.copyOffsets(this.myEditor.getDocument()), this.myCompletionChar, this.myElements, this.myPsiFile, this.myEditor, this.myAddCompletionChar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/InsertionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/InsertionContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

