/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BatchConsumer;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.Consumer;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CompletionResultSet
implements Consumer<LookupElement> {
    private final PrefixMatcher prefixMatcher;
    private final java.util.function.Consumer<? super CompletionResult> consumer;
    protected final CompletionService myCompletionService = CompletionService.getCompletionService();
    @ApiStatus.Internal
    public final CompletionContributor contributor;
    private boolean myStopped;

    protected CompletionResultSet(PrefixMatcher prefixMatcher, java.util.function.Consumer<? super CompletionResult> consumer, CompletionContributor contributor) {
        this.prefixMatcher = prefixMatcher;
        this.consumer = consumer;
        this.contributor = contributor;
    }

    @ApiStatus.Internal
    public java.util.function.Consumer<? super CompletionResult> getConsumer() {
        return this.consumer;
    }

    @Override
    public void consume(LookupElement element) {
        this.addElement(element);
    }

    public abstract void addElement(@NotNull LookupElement var1);

    public void passResult(@NotNull CompletionResult result) {
        if (result == null) {
            CompletionResultSet.$$$reportNull$$$0(0);
        }
        this.consumer.accept(result);
    }

    public void startBatch() {
        java.util.function.Consumer<? super CompletionResult> consumer = this.consumer;
        if (consumer instanceof BatchConsumer) {
            BatchConsumer batch2 = (BatchConsumer)consumer;
            batch2.startBatch();
        }
    }

    public void endBatch() {
        java.util.function.Consumer<? super CompletionResult> consumer = this.consumer;
        if (consumer instanceof BatchConsumer) {
            BatchConsumer batch2 = (BatchConsumer)consumer;
            batch2.endBatch();
        }
    }

    public void addAllElements(@NotNull Iterable<? extends LookupElement> elements) {
        if (elements == null) {
            CompletionResultSet.$$$reportNull$$$0(1);
        }
        this.startBatch();
        int seldomCounter = 0;
        for (LookupElement lookupElement : elements) {
            this.addElement(lookupElement);
            if (++seldomCounter % 1000 != 0) continue;
            ProgressManager.checkCanceled();
        }
        this.endBatch();
    }

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher var1);

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet withPrefixMatcher(@NotNull String var1);

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter var1);

    public abstract void addLookupAdvertisement(@NlsContexts.PopupAdvertisement @NotNull String var1);

    @Contract(pure=true)
    @NotNull
    public abstract CompletionResultSet caseInsensitive();

    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.prefixMatcher;
        if (prefixMatcher == null) {
            CompletionResultSet.$$$reportNull$$$0(2);
        }
        return prefixMatcher;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    public void stopHere() {
        this.myStopped = true;
    }

    public LinkedHashSet<CompletionResult> runRemainingContributors(CompletionParameters parameters, boolean passResult) {
        LinkedHashSet<CompletionResult> elements = new LinkedHashSet<CompletionResult>();
        this.runRemainingContributors(parameters, result -> {
            if (passResult) {
                this.passResult((CompletionResult)result);
            }
            elements.add((CompletionResult)result);
        });
        return elements;
    }

    public void runRemainingContributors(CompletionParameters parameters, Consumer<? super CompletionResult> consumer) {
        this.runRemainingContributors(parameters, consumer, true);
    }

    public void runRemainingContributors(CompletionParameters parameters, Consumer<? super CompletionResult> consumer, boolean stop) {
        this.runRemainingContributors(parameters, consumer, stop, null);
    }

    public void runRemainingContributors(CompletionParameters parameters, final Consumer<? super CompletionResult> consumer, boolean stop, CompletionSorter customSorter) {
        if (stop) {
            this.stopHere();
        }
        this.myCompletionService.getVariantsFromContributors(parameters, this.contributor, this.getPrefixMatcher(), (Consumer<? super CompletionResult>)new BatchConsumer<CompletionResult>(){

            @Override
            public void startBatch() {
                CompletionResultSet.this.startBatch();
            }

            @Override
            public void endBatch() {
                CompletionResultSet.this.endBatch();
            }

            @Override
            public void consume(CompletionResult result) {
                consumer.consume(result);
            }
        }, customSorter);
    }

    public void restartCompletionOnPrefixChange(String prefix) {
        this.restartCompletionOnPrefixChange((ElementPattern<String>)StandardPatterns.string().equalTo(prefix));
    }

    public abstract void restartCompletionOnPrefixChange(ElementPattern<String> var1);

    public void restartCompletionOnAnyPrefixChange() {
        this.restartCompletionOnPrefixChange(StandardPatterns.string());
    }

    public abstract void restartCompletionWhenNothingMatches();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionResultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionResultSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "passResult";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAllElements";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

